/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.store.path;

import com.cognos.cm.constants.CMConstants;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.store.path.CMPathStepTokenizer;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePathPredicate;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateAttribute;
import com.cognos.cm.store.path.CMStorePredicateBool;
import com.cognos.cm.store.path.CMStorePredicateElement;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.ArrayList;

public class CMStoreXPathStep
extends CMStorePathStep {
    public CMObjectClass classpredicate_ = null;
    private boolean validateClassPredicate_;

    public CMStoreXPathStep(int axis, boolean validateClassPredicate) {
        super(axis);
        this.validateClassPredicate_ = validateClassPredicate;
    }

    public CMStoreXPathStep(int axis) {
        super(axis);
    }

    @Override
    protected void initTokenizer(StreamTokenizer toker) {
        super.initTokenizer(toker);
        toker.ordinaryChar(124);
        toker.ordinaryChars(40, 41);
        toker.ordinaryChar(44);
    }

    @Override
    public void Parse(CMPathStepTokenizer toker) throws IOException, CMStoreParseException {
        int iToken;
        this.Predicates = new ArrayList();
        String previousWord = "";
        this.initTokenizer(toker);
        boolean classPredicateSet = false;
        while ((iToken = toker.nextToken()) != -1 && iToken != 41 && iToken != 44) {
            if (iToken == -3) {
                if (this.parsingPredicates) {
                    if (toker.sval.equalsIgnoreCase("and")) {
                        this.Predicates.add(new CMStorePredicateBool("and"));
                        continue;
                    }
                    if (toker.sval.equalsIgnoreCase("or")) {
                        this.Predicates.add(new CMStorePredicateBool("or"));
                        continue;
                    }
                    throw new CMStoreParseException("cmBadNodeTestDef");
                }
                previousWord = previousWord + toker.sval;
                continue;
            }
            if (iToken == 58) {
                iToken = toker.nextToken();
                if (iToken == 58) {
                    if (this.axis != 99) {
                        throw new CMStoreParseException("cmPathAxisOnce");
                    }
                    if (previousWord.equalsIgnoreCase("child")) {
                        this.axis = 1;
                    } else if (previousWord.equalsIgnoreCase("descendant")) {
                        this.axis = 7;
                    } else if (previousWord.equalsIgnoreCase("descendant-or-self")) {
                        this.axis = 8;
                    } else if (previousWord.equalsIgnoreCase("directChild")) {
                        this.axis = 1;
                    } else if (previousWord.equalsIgnoreCase("directDescendant")) {
                        this.axis = 7;
                    } else if (previousWord.equalsIgnoreCase("parent")) {
                        this.axis = 11;
                    } else if (previousWord.equalsIgnoreCase("ancestor")) {
                        this.axis = 12;
                    } else if (previousWord.equalsIgnoreCase("traverse")) {
                        this.axis = 13;
                    } else if (previousWord.equalsIgnoreCase("ancestor-or-self")) {
                        this.axis = 14;
                    } else if (previousWord.length() > 0) {
                        throw new CMStoreParseException("cmBadAxisDefAt", new CMException.Parm("Value", previousWord));
                    }
                    previousWord = "";
                    continue;
                }
                previousWord = previousWord + ':';
                toker.pushBack();
                continue;
            }
            if (iToken == 91) {
                CMStorePredicateElement predTest;
                Object obj;
                if (!classPredicateSet) {
                    this.SetClassPredicate(previousWord);
                }
                classPredicateSet = true;
                if (this.Predicates.size() > 0 && (obj = this.Predicates.get(this.Predicates.size() - 1)).getClass().getName().equals("com.cognos.cm.store.CMStorePathPredicate")) {
                    this.Predicates.add(new CMStorePredicateBool("and"));
                }
                this.parsingPredicates = true;
                CMStorePathPredicate pred = new CMStorePathPredicate(toker, 93);
                if ((previousWord == null || previousWord.length() <= 0 || previousWord.equalsIgnoreCase("*")) && (predTest = pred.PredicateExpressions.get(0)).getClass() == CMStorePathPredicateFunction.class) {
                    CMStorePathPredicateFunction func = (CMStorePathPredicateFunction)predTest;
                    if (func.function_ == CMConstants.FUNC_LAST_DEF) {
                        throw new CMStoreParseException("cmInvalidPathLast");
                    }
                }
                previousWord = "";
                this.Predicates.add(pred);
                this.initTokenizer(toker);
                continue;
            }
            if (iToken == 47 || iToken == 124) {
                toker.pushBack();
                if (iToken != 124) break;
                previousWord = previousWord.trim();
                break;
            }
            if (iToken == 40) {
                CMConstants.FunctionDef function = CMConstants.findNodeSetFunction(previousWord = previousWord.trim());
                if (function == null) {
                    throw new CMStoreParseException("cmBadCharInNodeTest", new CMException.Parm("Value", Integer.toString(iToken)));
                }
                toker.pushBack();
                CMStorePathPredicateFunction functionPred = new CMStorePathPredicateFunction(function, toker);
                this.Predicates.add(functionPred);
                this.initTokenizer(toker);
                this.SetNodeTest("*");
                classPredicateSet = true;
                continue;
            }
            if (iToken == 39) {
                throw new CMStoreParseException("cmBadCharInNodeTest", new CMException.Parm("Value", Integer.toString(iToken)));
            }
            previousWord = previousWord + (char)iToken;
        }
        toker.pushBack();
        if (!classPredicateSet) {
            this.SetClassPredicate(previousWord);
            classPredicateSet = true;
        }
        if (this.NodeTest.length() <= 0 && this.axis == 11) {
            this.SetNodeTest("*");
        }
        if (this.NodeTest.length() <= 0) {
            throw new CMStoreParseException("cmEmptyNodeTest");
        }
        this.filterPermissions_ = toker.getFilterPermissions();
        this.requiresReadAccess_ = toker.requiresReadAccess();
    }

    private void SetClassPredicate(String classDefinition) throws CMStoreParseException {
        if (classDefinition == null || classDefinition.length() <= 0) {
            return;
        }
        this.SetNodeTest("*");
        if (classDefinition.equalsIgnoreCase("*")) {
            return;
        }
        if (classDefinition.equals("..")) {
            if (this.axis != 99 && this.axis != 11) {
                throw new CMStoreParseException("cmPathAxisOnce");
            }
            this.axis = 11;
            return;
        }
        try {
            Object obj;
            CMStorePathPredicate pred = new CMStorePathPredicate();
            this.classpredicate_ = pred.CreateClassPredicate(classDefinition);
            if (this.validateClassPredicate_) {
                this.validateClassPredicateNotObsolete();
            }
            if (this.Predicates.size() > 0 && (obj = this.Predicates.get(this.Predicates.size() - 1)).getClass().getName().equals("com.cognos.cm.store.path.CMStorePathPredicate")) {
                this.Predicates.add(0, new CMStorePredicateBool("and"));
            }
            this.Predicates.add(0, pred);
        }
        catch (CMStoreParseException e) {
            throw e;
        }
        catch (CMStoreNotAvailable cMStoreNotAvailable) {
        }
        catch (CMStoreUnexpected cMStoreUnexpected) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        if (this.Predicates != null && this.Predicates.size() > 0) {
            for (int index = 0; index < this.Predicates.size(); ++index) {
                CMStorePathPredicate pred = (CMStorePathPredicate)this.Predicates.get(index);
                String predName = pred.getName();
                if (predName == null) continue;
                return predName;
            }
        }
        return null;
    }

    @Override
    public void setClass(CMObjectClass objClass) {
        this.classpredicate_ = objClass;
        if (this.Predicates != null && this.Predicates.size() > 0) {
            CMStorePredicateElement predEl;
            CMStorePathPredicate pred = (CMStorePathPredicate)this.Predicates.get(0);
            if (pred.PredicateExpressions.size() == 3 && (predEl = pred.PredicateExpressions.get(0)).getClass() == CMStorePredicateAttribute.class) {
                CMStorePredicateAttribute predAttr = (CMStorePredicateAttribute)predEl;
                if (predAttr.property == CMProperty.OBJECTCLASS && (predEl = pred.PredicateExpressions.get(2)).getClass() == CMStorePredicateStringLiteral.class) {
                    CMStorePredicateStringLiteral predLiteral = (CMStorePredicateStringLiteral)predEl;
                    predLiteral.literal = objClass.getName();
                }
            }
        }
    }

    public void validateClassPredicateNotObsolete() throws CMStoreParseException {
        if (this.classpredicate_ != null && this.classpredicate_.isObsolete()) {
            throw new CMStoreParseException("cmBadClass", new CMException.Parm("Class", this.classpredicate_.getName()));
        }
    }

    @Override
    public boolean isBurstStep() {
        boolean b = super.isBurstStep();
        if (this.classpredicate_ != null && !b) {
            b = this.classpredicate_.isBurstable();
        }
        return b;
    }
}

