/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.synchromesh.task;

import com.cognos.cm.notification.Notification;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.search.indexing.SubscriptionChecker;
import java.util.Map;

public class SynchromeshSubscriptionChecker
implements SubscriptionChecker {
    @Override
    public boolean isSubscribed(CMProperty property) {
        return property.isSynchromeshPayload();
    }

    @Override
    public boolean isSubscribed(CMObjectClass objectClass) {
        return objectClass.isSynchromeshable();
    }

    @Override
    public boolean isSubscribed(Notification notification) {
        return this.isSynchromeshable(notification);
    }

    private boolean isSynchromeshable(Notification notification) {
        if (!this.isSynchromeshable(notification.getObjectClass())) {
            return false;
        }
        if (this.isUpdate(notification)) {
            return this.hasSynchromeshMonitoredProperty(notification);
        }
        return true;
    }

    private boolean isSynchromeshable(CMObjectClass objectClass) {
        return objectClass != null && objectClass.isSynchromeshable();
    }

    private boolean isUpdate(Notification notification) {
        return "update".equals(notification.getOperation());
    }

    private boolean hasSynchromeshMonitoredProperty(Notification notification) {
        String updateProperties = this.getUpdateProperties(notification);
        for (String propertyName : updateProperties.split(";")) {
            if (!this.isSynchromeshMonitored(notification, propertyName)) continue;
            return true;
        }
        return false;
    }

    private String getUpdateProperties(Notification notification) {
        Map<String, Object> parameters = notification.getAdditionalParameters();
        String properties = parameters != null ? parameters.get("updateProperties") : "";
        return properties instanceof String ? properties : "";
    }

    private boolean isSynchromeshMonitored(Notification notification, String propertyName) {
        CMObjectClass objectClass = notification.getObjectClass();
        CMProperty property = objectClass.getProperty(propertyName);
        return property != null && property.isSynchromeshMonitored();
    }
}

