/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.synchromesh.task;

import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskAction;
import com.cognos.cm.backgroundTaskPluginAPI.IBackgroundTaskExectutionContext;
import com.cognos.cm.backgroundTaskPluginAPI.ICMQueueItem;
import com.cognos.cm.search.indexing.TraceLogger;
import com.cognos.cm.search.indexing.indexers.BatchIndexer;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.synchromesh.task.SynchromeshFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dom4j.Element;

public class SynchromeshTaskAction
implements IBackgroundTaskAction {
    private static final TraceLogger logger = new TraceLogger("Trace.CM.SYNCHROMESH");
    private BatchIndexer batchIndexer;
    private SynchromeshFactory factory;

    public SynchromeshTaskAction() {
        this(new SynchromeshFactory());
    }

    protected SynchromeshTaskAction(SynchromeshFactory factory) {
        this.factory = factory;
    }

    @Override
    public void initialize(IBackgroundTaskExectutionContext context, Element runOptionsElement) throws Exception {
        this.batchIndexer = this.factory.createBatchIndexer(logger);
    }

    @Override
    public void setupExecute(IBackgroundTaskExectutionContext context) throws Exception {
    }

    @Override
    public void execute(IBackgroundTaskExectutionContext context, List<?> items) throws Exception {
        if (!items.isEmpty()) {
            this.sendBatch(this.createBatchItems(items), context.getStore());
        }
    }

    private List<ICMQueueItem> createBatchItems(List<?> items) {
        ArrayList<ICMQueueItem> batchItems = new ArrayList<ICMQueueItem>();
        for (Object o : items) {
            ICMQueueItem item = (ICMQueueItem)o;
            batchItems.add(item);
        }
        return batchItems;
    }

    private void sendBatch(List<ICMQueueItem> batchItems, CMStore store) throws CMException {
        this.batchIndexer.sendBatchItems(batchItems, store);
    }

    @Override
    public void execute(String storeID, IBackgroundTaskExectutionContext context, Object item) throws Exception {
        this.execute(context, Arrays.asList(item));
    }

    @Override
    public void tearDown() {
    }

    BatchIndexer getBatchIndexer() {
        return this.batchIndexer;
    }
}

