/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.trustedServices;

import com.cognos.CAM.AAA_AznRequest_t;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class trustedService {
    public static int PERMISSION_INVALID = -1;
    public static int PERMISSION_EXECUTE_GRANTS_READ = 2;
    public static int PERMISSION_EXECUTE_GRANTS_READ_ALLOBJECTS = 3;
    public static int PERMISSION_GRANT_ALL_OBJECT = 4;
    public static int PERMISSION_GRANT_ALL_ALLOBJECTS = 5;
    public static int PERMISSION_GRANT_SOME_OBJECT = 8;
    public static int PERMISSION_GRANT_SOME_ALLOBJECTS = 9;
    private String serviceId_;
    private Object[] permissions_;
    private boolean bAppliesToAllPermissions_;
    private boolean fullyTrusted_;
    private boolean internal_;
    private boolean canRunAsOwner_;
    private boolean unfilteredTenantAccess_;

    public trustedService(String serviceId, NodeList xmlPermissions) throws CMException {
        CMStore store = CMExecutionContext.get().getStore();
        this.bAppliesToAllPermissions_ = false;
        this.serviceId_ = serviceId;
        this.fullyTrusted_ = false;
        ArrayList<trustedServicePermission> perms = new ArrayList<trustedServicePermission>();
        for (int i = 0; i < xmlPermissions.getLength(); ++i) {
            Element permElem = (Element)xmlPermissions.item(i);
            String permission = permElem.getAttribute("permission");
            String objectclass = permElem.getAttribute("class");
            boolean allowDeleteDescendants = false;
            int type = -1;
            if (permission.equalsIgnoreCase("fullyTrusted")) {
                this.fullyTrusted_ = true;
                continue;
            }
            if (permission.equalsIgnoreCase("internal")) {
                this.internal_ = true;
                continue;
            }
            if (permission.equalsIgnoreCase("canRunAsOwner")) {
                this.canRunAsOwner_ = true;
                continue;
            }
            if (permission.equalsIgnoreCase("unfilteredTenantAccess")) {
                this.unfilteredTenantAccess_ = true;
                continue;
            }
            if (permission.equalsIgnoreCase("executeorread")) {
                if (objectclass == null || objectclass.length() == 0) {
                    throw new CMException("cmBadClass", new CMException.Parm("Class", "<null>"));
                }
                type = PERMISSION_EXECUTE_GRANTS_READ;
            } else if (permission.equalsIgnoreCase("all") || permission.equalsIgnoreCase("all+recursive_delete")) {
                if (objectclass == null || objectclass.length() == 0) {
                    throw new CMException("cmBadClass", new CMException.Parm("Class", "<null>"));
                }
                type = PERMISSION_GRANT_ALL_OBJECT;
                this.bAppliesToAllPermissions_ = true;
                if (permission.equalsIgnoreCase("all+recursive_delete")) {
                    allowDeleteDescendants = true;
                }
            } else {
                type = PERMISSION_GRANT_SOME_OBJECT;
            }
            HashMap<String, String> propertyMap = new HashMap<String, String>();
            NodeList propertyNL = permElem.getElementsByTagName("property");
            for (int k = 0; k < propertyNL.getLength(); ++k) {
                Element propElem = (Element)propertyNL.item(k);
                String propName = propElem.getAttribute("name");
                String propPermission = propElem.getAttribute("permission");
                propertyMap.put(propName, propPermission);
            }
            perms.add(new trustedServicePermission(type, permission, objectclass, store, propertyMap, allowDeleteDescendants));
        }
        if (perms.size() > 0) {
            this.permissions_ = perms.toArray();
        }
    }

    public boolean trustedCheckAccess(AAA_AznRequest_t[] tests, CMObjectClass objectClass) {
        if (this.permissions_ == null) {
            return false;
        }
        boolean bDontCallAccManCheckAccess = false;
        for (int iPerm = 0; iPerm < this.permissions_.length; ++iPerm) {
            int iAccess;
            trustedServicePermission theTrustedPerm = (trustedServicePermission)this.permissions_[iPerm];
            int permType = theTrustedPerm.getType();
            if ((permType & 1) != 1 && !objectClass.subclassof(theTrustedPerm.getObjectClass())) continue;
            if ((permType & 0xFE) == PERMISSION_GRANT_ALL_OBJECT) {
                for (iAccess = 0; iAccess < tests.length; ++iAccess) {
                    tests[iAccess].nAccess = 0;
                }
                bDontCallAccManCheckAccess = true;
                break;
            }
            if ((permType & 0xFE) == PERMISSION_EXECUTE_GRANTS_READ) {
                for (iAccess = 0; iAccess < tests.length; ++iAccess) {
                    if (!tests[iAccess].sPermission.equalsIgnoreCase("execute") || tests[iAccess].nAccess != 0) continue;
                    for (int iAccess2 = 0; iAccess2 < tests.length; ++iAccess2) {
                        if (!tests[iAccess2].sPermission.equalsIgnoreCase("read")) continue;
                        tests[iAccess2].nAccess = 0;
                    }
                }
                continue;
            }
            if ((permType & 0xFE) != PERMISSION_GRANT_SOME_OBJECT) continue;
            for (iAccess = 0; iAccess < tests.length; ++iAccess) {
                if (!tests[iAccess].sPermission.equalsIgnoreCase(theTrustedPerm.getPermission())) continue;
                tests[iAccess].nAccess = 0;
            }
        }
        return bDontCallAccManCheckAccess;
    }

    public boolean canDeleteDescendants(CMObjectClass objClass) {
        if (this.permissions_ != null) {
            for (int i = 0; i < this.permissions_.length; ++i) {
                trustedServicePermission perm = (trustedServicePermission)this.permissions_[i];
                if (!objClass.subclassof(perm.getObjectClass())) continue;
                return perm.getAllowDeleteDescendants();
            }
        }
        return false;
    }

    public boolean trustedCheckAccess(int[] results, List<String> permissions, CMObjectClass objectClass) {
        if (this.permissions_ == null) {
            return false;
        }
        boolean bDontCallAccManCheckAccess = false;
        for (int iPerm = 0; iPerm < this.permissions_.length; ++iPerm) {
            int iAccess;
            trustedServicePermission theTrustedPerm = (trustedServicePermission)this.permissions_[iPerm];
            int permType = theTrustedPerm.getType();
            if ((permType & 1) != 1 && !objectClass.subclassof(theTrustedPerm.getObjectClass())) continue;
            if ((permType & 0xFE) == PERMISSION_GRANT_ALL_OBJECT) {
                for (iAccess = 0; iAccess < results.length; ++iAccess) {
                    results[iAccess] = 0;
                }
                bDontCallAccManCheckAccess = true;
                break;
            }
            if ((permType & 0xFE) == PERMISSION_EXECUTE_GRANTS_READ) {
                for (iAccess = 0; iAccess < results.length; ++iAccess) {
                    if (!permissions.get(iAccess).equalsIgnoreCase("execute") || results[iAccess] != 0) continue;
                    for (int iAccess2 = 0; iAccess2 < results.length; ++iAccess2) {
                        if (!permissions.get(iAccess2).equalsIgnoreCase("read")) continue;
                        results[iAccess2] = 0;
                    }
                }
                continue;
            }
            if ((permType & 0xFE) != PERMISSION_GRANT_SOME_OBJECT) continue;
            for (iAccess = 0; iAccess < results.length; ++iAccess) {
                if (!permissions.get(iAccess).equalsIgnoreCase(theTrustedPerm.getPermission())) continue;
                results[iAccess] = 0;
            }
        }
        return bDontCallAccManCheckAccess;
    }

    public String getClassPropertyPermission(CMObjectClass objectClass, String propertyName) {
        String permission = null;
        ArrayList<String> classHierarchy = new ArrayList<String>();
        classHierarchy.add(objectClass.getName());
        for (CMObjectClass tempObj = objectClass.getBaseClass(); tempObj != null; tempObj = tempObj.getBaseClass()) {
            classHierarchy.add(tempObj.getName());
        }
        Object[] perms = this.permissions_;
        for (int i = 0; i < perms.length; ++i) {
            Map<String, String> classProperties;
            trustedServicePermission tsPermission = (trustedServicePermission)perms[i];
            if (!classHierarchy.contains(tsPermission.getObjectClass().getName()) || null == (classProperties = tsPermission.getProperties()) || !classProperties.containsKey(propertyName)) continue;
            permission = classProperties.get(propertyName);
        }
        return permission;
    }

    public boolean getFullyTrusted() {
        return this.fullyTrusted_;
    }

    public boolean getInternal() {
        return this.internal_;
    }

    public boolean getCanRunAsOwner() {
        return this.canRunAsOwner_;
    }

    public boolean hasUnfilteredTenantAccess() {
        return this.unfilteredTenantAccess_;
    }

    public boolean getAppliesToAllPermissions() {
        return this.bAppliesToAllPermissions_;
    }

    public String getId() {
        return this.serviceId_;
    }

    private static class trustedServicePermission {
        private int type_;
        private String permission_;
        private Map<String, String> properties_;
        private CMObjectClass objClass_;
        private boolean allowDeleteDescendants_;

        public trustedServicePermission(int type, String permission, String className, CMStore store, Map<String, String> properties, boolean allowDeleteDescendants) throws CMException {
            this.type_ = type;
            this.permission_ = permission;
            this.properties_ = properties;
            this.allowDeleteDescendants_ = allowDeleteDescendants;
            if (className.equalsIgnoreCase("All")) {
                this.type_ |= 1;
            } else {
                this.objClass_ = store.getObjectClasses().getClassByName(className);
                if (this.objClass_ == null) {
                    throw new CMException("cmBadClass", new CMException.Parm("Class", className));
                }
            }
        }

        public int getType() {
            return this.type_;
        }

        public CMObjectClass getObjectClass() {
            return this.objClass_;
        }

        public String getPermission() {
            return this.permission_;
        }

        public Map<String, String> getProperties() {
            return this.properties_;
        }

        public boolean getAllowDeleteDescendants() {
            return this.allowDeleteDescendants_;
        }
    }
}

