/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.constants.ArchiveStatus;
import com.cognos.cm.notification.ArchivalNotificationParameters;
import com.cognos.cm.server.InstalledComponentsCache;
import java.util.HashMap;
import java.util.Map;

public class ArchivingUtil {
    protected static InstalledComponentsCache installedComponentsCache;
    protected static Boolean isArchivingSoftwareInstalledObject;

    public static boolean archivingIsDisabled(Map<String, Object> additionalParameters) {
        return ArchivingUtil.isImport(additionalParameters);
    }

    public static boolean getArchivingTriggerPropHasValue(Map<String, Object> additionalParameters) {
        boolean archivingTriggerPropHasValue = true;
        ArchivalNotificationParameters archivalParameters = ArchivingUtil.getArchivalNotificationParameters(additionalParameters);
        if (archivalParameters != null) {
            archivingTriggerPropHasValue = archivalParameters.getArchivingTriggerPropHasValue();
        }
        return archivingTriggerPropHasValue;
    }

    public static boolean isImport(Map<String, Object> additionalParameters) {
        boolean isImport = false;
        ArchivalNotificationParameters archivalParameters = ArchivingUtil.getArchivalNotificationParameters(additionalParameters);
        if (archivalParameters != null) {
            isImport = archivalParameters.isImport();
        }
        return isImport;
    }

    public static boolean isAdd(Map<String, Object> additionalParameters) {
        boolean isAdd = false;
        ArchivalNotificationParameters archivalParameters = ArchivingUtil.getArchivalNotificationParameters(additionalParameters);
        if (archivalParameters != null) {
            isAdd = archivalParameters.isAdd();
        }
        return isAdd;
    }

    private static ArchivalNotificationParameters getArchivalNotificationParameters(Map<String, Object> additionalParameters) {
        Object params;
        if (additionalParameters != null && additionalParameters.containsKey("ArchivalNotificationParameters") && (params = additionalParameters.get("ArchivalNotificationParameters")) instanceof ArchivalNotificationParameters) {
            return (ArchivalNotificationParameters)params;
        }
        return null;
    }

    public static Map<String, Object> setNotificationParameterForArchivingTriggerPropNotSet(Map<String, Object> notificationParameters) {
        ArchivalNotificationParameters archivalParameters;
        if (notificationParameters == null) {
            notificationParameters = new HashMap<String, Object>();
        }
        if ((archivalParameters = ArchivingUtil.getArchivalNotificationParameters(notificationParameters)) == null) {
            archivalParameters = new ArchivalNotificationParameters(false);
        }
        archivalParameters.setArchivingTriggerPropHasValue(false);
        notificationParameters.put("ArchivalNotificationParameters", archivalParameters);
        return notificationParameters;
    }

    public static Map<String, Object> setNotificationParameterForAdd(Map<String, Object> notificationParameters) {
        ArchivalNotificationParameters archivalParameters;
        if (notificationParameters == null) {
            notificationParameters = new HashMap<String, Object>();
        }
        if ((archivalParameters = ArchivingUtil.getArchivalNotificationParameters(notificationParameters)) == null) {
            archivalParameters = new ArchivalNotificationParameters(false);
        }
        archivalParameters.setAdd(true);
        notificationParameters.put("ArchivalNotificationParameters", archivalParameters);
        return notificationParameters;
    }

    public boolean isRepositoryIntegrationInstalled() {
        return this.isArchivingSoftwareInstalled() && ArchivingUtil.getInstalledComponentCache().isComponentInstalled("repositoryIntegration");
    }

    protected void loadArchiveBinaryCode() throws ClassNotFoundException {
        Class.forName("com.ibm.cognos.cm.notification.observers.ArchiveOutputObserver");
    }

    protected static InstalledComponentsCache getInstalledComponentCache() {
        if (installedComponentsCache == null) {
            installedComponentsCache = InstalledComponentsCache.getInstance();
        }
        return installedComponentsCache;
    }

    public static String getArchiveStatusForCopy() {
        return ArchiveStatus.NOTSET.getValue();
    }

    public static String getArchiveStatusForAdd() {
        return ArchiveStatus.HOLD.getValue();
    }

    public static String getArchiveStatusForUpdate() {
        return ArchiveStatus.HOLD.getValue();
    }

    public static String getArchiveStatusForDatabaseDefault() {
        return ArchiveStatus.NOTSET.getValue();
    }

    public boolean isArchivingSoftwareInstalled() {
        boolean isArchivingSoftwareInstalled = false;
        if (isArchivingSoftwareInstalledObject != null) {
            isArchivingSoftwareInstalled = isArchivingSoftwareInstalledObject;
        } else {
            try {
                this.loadArchiveBinaryCode();
                isArchivingSoftwareInstalled = true;
            }
            catch (ClassNotFoundException ex) {
                isArchivingSoftwareInstalled = false;
            }
            isArchivingSoftwareInstalledObject = new Boolean(isArchivingSoftwareInstalled);
        }
        return isArchivingSoftwareInstalled;
    }
}

