/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.deployment.DeploymentExecutionContext;
import com.cognos.cm.diagnostics.DiagnosticsContext;
import com.cognos.cm.request.contentManagerService.v1.run;
import com.cognos.cm.server.ASyncRequestManager;
import com.cognos.cm.server.AsyncRequest;
import com.cognos.cm.server.AsyncRequestState;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ContentManager;
import com.cognos.cm.server.Request;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class AsyncThreadPool {
    private ThreadPoolExecutor executorPool;
    private Map<String, RunRequestTask> id2Task = Collections.synchronizedMap(new HashMap());

    public AsyncThreadPool(int nThreads) {
        this.executorPool = new ThreadPoolExecutor(nThreads, nThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.executorPool.prestartAllCoreThreads();
    }

    protected ASyncRequestManager getAsyncRequestManager() {
        return ASyncRequestManager.getInstance();
    }

    public int getMaxThreads() {
        return this.executorPool.getMaximumPoolSize();
    }

    public void setMaxThreads(int max) {
        if (max < 1) {
            return;
        }
        this.executorPool.setCorePoolSize(max);
        this.executorPool.setMaximumPoolSize(max);
        this.executorPool.prestartAllCoreThreads();
    }

    public void cancelWorkerThread(String sThreadId) {
        RunRequestTask task = this.id2Task.get(sThreadId);
        if (task != null) {
            task.cancel();
        }
    }

    public void execute(AsyncRequest request, run runHandler, Request rq, CMExecutionContext ectx, DeploymentExecutionContext dctx) {
        String sId = rq.threadId;
        RunRequestTask task = new RunRequestTask(runHandler, request, sId, ectx, dctx);
        this.getAsyncRequestManager().createRequestStatus(sId, new AsyncRequestState(4));
        this.id2Task.put(sId, task);
        this.executorPool.execute(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateWorkerThreads() {
        this.executorPool.shutdown();
        Map<String, RunRequestTask> map = this.id2Task;
        synchronized (map) {
            for (String key : this.id2Task.keySet()) {
                RunRequestTask task = this.id2Task.get(key);
                task.cmShutdown();
            }
        }
    }

    private class RunRequestTask
    implements Runnable {
        private DiagnosticsContext diagCtxCopy;
        private Object statusMutex;
        private volatile int status;
        private run runHandler;
        private AsyncRequest request;
        private String id;
        private CMExecutionContext execCtx;
        private DeploymentExecutionContext deployCtx;

        private RunRequestTask(run runHandler, AsyncRequest request, String id, CMExecutionContext execCtx, DeploymentExecutionContext deployCtx) {
            this.runHandler = runHandler;
            this.request = request;
            this.id = id;
            this.execCtx = execCtx;
            this.deployCtx = deployCtx;
            this.statusMutex = new Object();
            this.status = 4;
            this.diagCtxCopy = DiagnosticsContext.get().save();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object = this.statusMutex;
            synchronized (object) {
                if (this.status != 1) {
                    this.status = 2;
                    AsyncThreadPool.this.getAsyncRequestManager().updateRequestStatus(this.id, 2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cmShutdown() {
            Object object = this.statusMutex;
            synchronized (object) {
                if (this.status != 1) {
                    this.status = 5;
                    AsyncThreadPool.this.getAsyncRequestManager().updateRequestStatus(this.id, 5);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean shouldRun = false;
            Object object = this.statusMutex;
            synchronized (object) {
                if (this.status != 2 && this.status != 5) {
                    this.status = 0;
                    AsyncThreadPool.this.getAsyncRequestManager().updateRequestStatus(this.id, 0);
                    shouldRun = true;
                }
            }
            if (shouldRun) {
                CMExecutionContext.setUp();
                CMExecutionContext.set(this.execCtx);
                DeploymentExecutionContext.set(this.deployCtx);
                ContentManager.diagnosticsManager.reset();
                DiagnosticsContext.get().restore(this.diagCtxCopy);
                this.diagCtxCopy = null;
                try {
                    this.request.doAsyncRequest();
                    object = this.statusMutex;
                    synchronized (object) {
                        if (this.status != 2 && this.status != 5) {
                            this.status = 1;
                            AsyncThreadPool.this.getAsyncRequestManager().updateRequestStatus(this.id, 1);
                        }
                    }
                }
                catch (Exception e) {
                    AsyncThreadPool.this.getAsyncRequestManager().updateRequestStatus(this.id, 3, e);
                }
                finally {
                    this.runHandler.done();
                    ContentManager.diagnosticsManager.update();
                    CMExecutionContext.tearDown();
                    DeploymentExecutionContext.clear();
                }
            }
            AsyncThreadPool.this.id2Task.remove(this.id);
        }
    }
}

