/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.CAM.AAAException;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreStringArray;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMAAAObjectPropertiesDoc {
    private Object[] values_;
    private CMProperty[] props_;
    private boolean[] hasProps_;
    private boolean[] modifyableProps_;
    private String propList_;

    public CMAAAObjectPropertiesDoc(CMObjectClass objectClass, String objectID, CMProperty[] props) throws CMException {
        this("CAMID(" + SearchPathEncoder.quoteString((String)objectID) + ")", null, objectClass, props);
    }

    public CMAAAObjectPropertiesDoc(String path, String marker, CMObjectClass objectClass, CMProperty ... props) throws CMException {
        this.props_ = props;
        this.hasProps_ = new boolean[props.length];
        this.modifyableProps_ = new boolean[props.length];
        this.values_ = new Object[props.length];
        StringBuffer propList = new StringBuffer();
        int propCount = 0;
        for (int j = 0; j < props.length; ++j) {
            CMProperty prop = props[j];
            if (prop == null || !objectClass.hasProperty(prop)) continue;
            ++propCount;
            propList.append("<item xsi:type='bus:propEnum'>").append(prop.getName()).append("</item>");
            this.hasProps_[j] = true;
        }
        this.propList_ = propList.toString();
        if (this.propList_.length() <= 0) {
            return;
        }
        StringBuffer query2 = new StringBuffer();
        query2.append(CMSOAPConstants.SOAPEnvHeaderStart);
        if (marker != null) {
            int insertPos = 0;
            if (CMSOAPConstants.SOAPEnvHeaderStart.startsWith("<?xml")) {
                insertPos = CMSOAPConstants.SOAPEnvHeaderStart.indexOf("?>") + 2;
            }
            query2.insert(insertPos, marker);
        }
        query2.append(CMExecutionContext.get().getCAMAdditionalInfo());
        query2.append(CMSOAPConstants.SOAPHeaderToBody);
        query2.append("<bus:query><search>");
        query2.append(XMLUtils.escape((String)path));
        query2.append("</search><properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:propEnum[");
        query2.append(Integer.toString(propCount));
        query2.append("]\">");
        query2.append(propList.toString());
        query2.append("</properties></bus:query>");
        query2.append(CMSOAPConstants.SOAPBodyEnvEnd);
        String results = query2.toString();
        try {
            results = CMServlet.AAA.Search(CMExecutionContext.get().getAccManPassportID(), results);
        }
        catch (AAAException exaa) {
            CMIndications.CMTrace("cmBadSecurityID", new CMException.Parm("ID", path), new CMException.Parm("Details", exaa.toString()));
        }
        if (results != null) {
            try {
                Document doc = CMXMLUtils.parse(new InputSource(new StringReader(results)));
                Node responseNode = doc.getFirstChild();
                if (responseNode != null) {
                    Node resultNode = responseNode.getFirstChild();
                    NodeList objects = resultNode.getChildNodes();
                    Element objectElement = null;
                    NodeList properties = null;
                    if (objects.getLength() == 1) {
                        objectElement = (Element)objects.item(0);
                        properties = objectElement.getChildNodes();
                        for (int i = 0; i < props.length; ++i) {
                            ArrayList<String> ret;
                            if (!this.hasProps_[i]) continue;
                            Element currentProperty = CMAAAObjectPropertiesDoc.findProperty(props[i], properties);
                            if (currentProperty == null) {
                                this.hasProps_[i] = false;
                                continue;
                            }
                            if (props[i] == CMProperty.MEMBERS) {
                                // empty if block
                            }
                            NodeList propNodes = currentProperty.getChildNodes();
                            if (props[i] == CMProperty.ANCESTORS) {
                                this.values_[i] = ret = AccMan.parseAncestorsValue(propNodes.item(0), path);
                                continue;
                            }
                            if (props[i] == CMProperty.CAPABILITIES) {
                                ret = AccMan.parseCapabilitesValue(propNodes.item(0));
                                this.values_[i] = new CMDbStoreStringArray(ret);
                                continue;
                            }
                            if (props[i] == CMProperty.PARAMETERS) {
                                String value = AccMan.parseParametersValue(propNodes.item(0));
                                this.values_[i] = value;
                                continue;
                            }
                            if (propNodes == null) continue;
                            Element propValue = (Element)propNodes.item(0);
                            String propValueStr = null;
                            if (CMXMLUtils.isNilValue(propValue)) {
                                this.modifyableProps_[i] = true;
                            } else {
                                propValueStr = CMXMLUtils.getCharacterContentProper(propValue);
                            }
                            this.values_[i] = propValueStr != null ? new CMDbStoreString(propValueStr) : null;
                        }
                    }
                }
            }
            catch (SAXException ex) {
                CMIndications.logException(ex, results);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Element findProperty(String propertyName, NodeList nodes) {
        int numProperties = nodes.getLength();
        for (int i = 0; i < numProperties; ++i) {
            Node curNode = nodes.item(i);
            if (curNode.getNodeType() != 1 || !curNode.getNodeName().equals(propertyName)) continue;
            return (Element)curNode;
        }
        return null;
    }

    private static Element findProperty(CMProperty prop, NodeList nodes) {
        return CMAAAObjectPropertiesDoc.findProperty(prop.getName(), nodes);
    }

    public boolean hasProperty(int index) {
        if (index < 0 || index >= this.props_.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.hasProps_[index];
    }

    public boolean isModifyableProperty(int index) {
        if (index < 0 || index >= this.props_.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.modifyableProps_[index];
    }

    public Object getValue(int index) {
        if (index < 0 || index >= this.props_.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (!this.hasProps_[index]) {
            return null;
        }
        return this.values_[index];
    }
}

