/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

public class CMBuildVersion
implements Comparable<Object> {
    public static final int PRODUCT_MAJOR = 0;
    public static final int PRODUCT_MINOR = 1;
    public static final int BUILD_MAJOR = 2;
    public static final int BUILD_MINOR = 3;
    private int[] ver_ = new int[4];

    public CMBuildVersion(String strVer) {
        this.setTo(strVer);
    }

    public CMBuildVersion(int majVer, int minVer, int majBld, int minBld) {
        this.setTo(majVer, minVer, majBld, minBld);
    }

    public CMBuildVersion(CMBuildVersion source) {
        this.set(0, source.get(0));
        this.set(1, source.get(1));
        this.set(2, source.get(2));
        this.set(3, source.get(3));
    }

    public void setTo(String strVer) {
        int start = 0;
        for (int i = 0; i < 3; ++i) {
            int end = strVer.indexOf(46, start);
            if (end == -1) {
                throw new NumberFormatException("Invalid version number " + strVer);
            }
            this.ver_[i] = Integer.parseInt(strVer.substring(start, end), 10);
            start = end + 1;
        }
        this.ver_[3] = Integer.parseInt(strVer.substring(start), 10);
    }

    public void setTo(int majVer, int minVer, int majBld, int minBld) {
        this.ver_[0] = majVer;
        this.ver_[1] = minVer;
        this.ver_[2] = majBld;
        this.ver_[3] = minBld;
    }

    @Override
    public int compareTo(Object cmp) {
        CMBuildVersion other = cmp instanceof String ? new CMBuildVersion((String)cmp) : (CMBuildVersion)cmp;
        int result = 0;
        result = this.ver_[0] - other.ver_[0];
        if (result != 0) {
            return result;
        }
        result = this.ver_[1] - other.ver_[1];
        if (result != 0) {
            return result;
        }
        result = this.ver_[2] - other.ver_[2];
        if (result != 0) {
            return result;
        }
        return this.ver_[3] - other.ver_[3];
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(this.ver_[i]);
        }
        return buf.toString();
    }

    public String getReleaseVersion() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                buf.append('.');
            }
            buf.append(this.ver_[i]);
        }
        return buf.toString();
    }

    public void set(int field, int value) {
        this.ver_[field] = value;
    }

    public int get(int field) {
        return this.ver_[field];
    }
}

