/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.CAM.AAAException;
import com.cognos.cm.accman.CMCAMNamespace;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreObjectReference;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.multipart.Base64;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AccMan;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreObjectNotFound;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStorePathFunctionArgument;
import com.cognos.cm.store.path.CMStorePathPredicateFunction;
import com.cognos.cm.store.path.CMStorePathStep;
import com.cognos.cm.store.path.CMStorePredicateStringLiteral;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.CMQueryUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMCAMIDHelper {
    public static final String OPENID_NS_PREFIX = "OIDC";
    private static final String cognosNSPathStr_ = "/directory/namespace[@id=':']";
    private static final String namespaceQuery = "<searchSpecificationDocument  recurse=\"false\" language=\"en-us\"><object class=\"namespace\"/></searchSpecificationDocument>";

    public static String storeID2CAMID(String storeID) {
        if (storeID.length() == 0 || storeID.charAt(0) != 'x') {
            return storeID;
        }
        byte[] in = storeID.getBytes();
        byte[] out = Base64.decode(in, 1, in.length - 1, true);
        String result = null;
        try {
            result = new String(out, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            CMIndications.logException(ex);
        }
        return result;
    }

    public static String CAMID2storeID(String CAMID2) {
        if (CAMID2.length() == 0) {
            return "x";
        }
        String result = "x";
        try {
            byte[] in = CAMID2.getBytes("utf-8");
            result = result + Base64.encode(in, 0, in.length, true);
        }
        catch (UnsupportedEncodingException ex) {
            CMIndications.logException(ex);
        }
        return result;
    }

    public static String normalizeStoreID(String storeID) throws CMException {
        if (storeID == null || storeID.length() == 0) {
            return storeID;
        }
        char c = storeID.charAt(0);
        if (c != 'i' && c != 'x') {
            String camid;
            CMStoreXPath xp = new CMStoreXPath(storeID);
            String string = camid = xp.size() == 1 ? xp.getCAMIDFromFirstStep() : null;
            if (camid == null) {
                throw new CMException("cmErrCache");
            }
            storeID = CMCAMIDHelper.CAMID2storeID(camid);
        }
        return storeID;
    }

    public static CMStorePath getInternalPathFromCAMID(CMStorePath qPath) {
        String CAMID2 = null;
        CMStorePathStep firstStep = qPath.size() > 0 ? qPath.stepAt(0) : null;
        CMStorePathPredicateFunction parsedFunc = (CMStorePathPredicateFunction)firstStep.Predicates.get(0);
        if (parsedFunc.args.size() > 0) {
            CMStorePathFunctionArgument arg = (CMStorePathFunctionArgument)parsedFunc.args.get(0);
            CMStorePredicateStringLiteral camidLiteral = (CMStorePredicateStringLiteral)arg.PredicateExpressions.get(0);
            CAMID2 = camidLiteral.literal;
        }
        if (CAMID2 != null) {
            CMStoreXPath newPath = null;
            try {
                if (CAMID2.startsWith(":") && !CMCAMIDHelper.isFixedCAMID(CAMID2)) {
                    String cognosNSPath = CMCAMIDHelper.CognosNSPathFromCAMID(CAMID2);
                    newPath = new CMStoreXPath(cognosNSPath);
                } else {
                    newPath = new CMStoreXPath("/directory//*[@id='" + CMStoreXPath.attributeEncodeString(CAMID2, '\'') + "']");
                }
                newPath.append(qPath, 1);
                qPath = newPath;
            }
            catch (CMStoreParseException e) {
                return null;
            }
        }
        return qPath;
    }

    public static boolean isCognosNamespace(String str) {
        String camid;
        int iStart = str.indexOf("CAMID(");
        return iStart > -1 && (camid = CMCAMIDHelper.CAMIDFromSearchPath(str)) != null && camid.startsWith(":");
    }

    public static String SelectFromCAMID(String camid) {
        return "CAMID(\"" + camid + "\")";
    }

    public static String CAMIDFromSearchPath(String searchPath) {
        try {
            CMStoreXPath path = new CMStoreXPath(searchPath);
            return path.getCAMIDFromFirstStep();
        }
        catch (CMStoreParseException cMStoreParseException) {
            return null;
        }
    }

    public static boolean CAMIDIsExternal(String camid) {
        return !camid.startsWith(":");
    }

    public static boolean isExtNamespace(String literal) {
        return literal.indexOf(58) == -1;
    }

    public static boolean isExtNamespaceFolder(String nsLiteral, String literal) {
        return literal.startsWith(nsLiteral + ":f:");
    }

    public static boolean isSpecialCAMID(String camid) {
        return camid != null && (camid.equals("::All Authenticated Users") || camid.equals("::Everyone") || camid.equals("::System Administrators") || camid.equals("::Tenant Administrators") || camid.equals("::Anonymous"));
    }

    public static boolean isFixedCAMID(String camid) {
        return camid.equals(":") || camid.equals("::All Authenticated Users") || camid.equals("::Everyone") || camid.equals("::System Administrators") || camid.equals("::Tenant Administrators") || camid.equals("::Anonymous");
    }

    public static CMCAMNamespace getNamespaceFromCAMID(String camid) {
        if (camid == null) {
            return null;
        }
        int colonPos = camid.indexOf(58);
        if (colonPos == -1) {
            colonPos = camid.length();
        }
        return CMServlet.namespaceManager.getNamespace(camid.substring(0, colonPos));
    }

    public static String getNamespaceIDFromCAMID(String camid) {
        if (camid == null) {
            return null;
        }
        if (camid.startsWith(":")) {
            return ":";
        }
        int colonPos = camid.indexOf(58);
        if (colonPos == -1) {
            colonPos = camid.length();
        }
        return camid.substring(0, colonPos);
    }

    public static String getNamespaceIDFromSearchPath(String searchPath) {
        return CMCAMIDHelper.getNamespaceIDFromCAMID(CMCAMIDHelper.CAMIDFromSearchPath(searchPath));
    }

    public static String CognosNSPathFromCAMID(String camid) {
        camid = camid.substring(":".length());
        StringBuffer buf = new StringBuffer();
        buf.append("/directory/namespace[@id='");
        buf.append(":");
        buf.append("']");
        if (camid.startsWith("::")) {
            buf.append("/*[@id='").append(camid).append("']");
        } else {
            int camidLen = camid.length();
            int curChar = 0;
            if (camidLen > 0) {
                buf.append("/*[@name='");
            }
            while (curChar < camidLen) {
                char c = camid.charAt(curChar);
                if (c == ':') {
                    if (++curChar >= camidLen) break;
                    c = camid.charAt(curChar);
                    if (c != ':') {
                        buf.append("']/*[@name='");
                    }
                }
                if (c == '\'') {
                    buf.append("''");
                } else {
                    buf.append(c);
                }
                ++curChar;
            }
            if (camidLen > 0) {
                buf.append("']");
            }
        }
        String searchPath = buf.toString();
        return searchPath;
    }

    public static String getNamespaceCAMID(String namespace) {
        String namespacePath = "/" + namespace;
        try {
            StringBuffer query2 = new StringBuffer();
            query2.append(CMSOAPConstants.SOAPEnvHeaderStart);
            query2.append(CMExecutionContext.get().getCAMAdditionalInfo());
            query2.append(CMSOAPConstants.SOAPHeaderToBody);
            query2.append(namespaceQuery);
            query2.append(CMSOAPConstants.SOAPBodyEnvEnd);
            String results = CMServlet.AAA.Search(null, query2.toString());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder domBuilder = null;
            try {
                domBuilder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
            try {
                Document doc = domBuilder.parse(new InputSource(new StringReader(results)));
                Node responseNode = doc.getFirstChild();
                NodeList els = responseNode.getChildNodes();
                for (int i = 0; i < els.getLength(); ++i) {
                    NamedNodeMap attrs;
                    Node objectNode = els.item(i);
                    if (objectNode.getNodeType() != 1 || (attrs = objectNode.getAttributes()) == null) continue;
                    Node attrID = attrs.getNamedItem("id");
                    Node attrPath = attrs.getNamedItem("path");
                    if (!namespacePath.equalsIgnoreCase(attrPath.getNodeValue())) continue;
                    return attrID.getNodeValue();
                }
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
            }
        }
        catch (AAAException aAAException) {
            // empty catch block
        }
        return null;
    }

    public static CMObjectReference normalizeSecurityReference(CMStore store, String reference, boolean normalizeCAMIDs, boolean createProxy, boolean mustExist, boolean bAcquireLocks) throws CMException {
        return CMCAMIDHelper.normalizeSecurityReference(store, new CMStoreXPath(reference), normalizeCAMIDs, createProxy, mustExist, bAcquireLocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CMObjectReference normalizeSecurityReference(CMStore store, CMStoreXPath reference, boolean normalizeCAMIDs, boolean createProxy, boolean mustExist, boolean bAcquireLocks) throws CMException {
        block28: {
            int lockUsageBackup;
            CMStoreQueryResults results;
            block26: {
                CMDbStoreObjectReference cMDbStoreObjectReference;
                CMObjectClass objectClass;
                int objectID;
                String sNormalizedSearchPath;
                String sNormalizedCAMID3222222;
                block27: {
                    reference.ResolveCurrentUserSteps(false);
                    String sCAMID = null;
                    if (reference.size() > 0 && !reference.getOriginalPath().startsWith("~")) {
                        sCAMID = reference.getCAMIDFromFirstStep();
                    }
                    if (!(sCAMID == null || createProxy || mustExist || normalizeCAMIDs || reference.size() != 1)) {
                        return new CMDbStoreObjectReference(reference.getOriginalPath());
                    }
                    String passport = CMExecutionContext.get().getAccManPassportID();
                    if (passport != null && sCAMID != null && !sCAMID.startsWith(":")) {
                        try {
                            String sNormalizedCAMID2 = null;
                            sNormalizedCAMID2 = reference.size() > 1 ? AccMan.normalizeExternalSearch(reference) : AccMan.normalizeExternalSearch(reference.toString());
                            if (sNormalizedCAMID2 == null) {
                                if (!mustExist) return new CMDbStoreObjectReference(-1, null, reference.getOriginalPath(), true);
                                throw new CMException("cmBadSecurityReferenceDoesNotExist", new CMException.Parm("Reference", reference.getOriginalPath()));
                            }
                            if (!createProxy) return new CMDbStoreObjectReference(sNormalizedCAMID2, true);
                            try {
                                sCAMID = CMCAMIDHelper.CAMIDFromSearchPath(sNormalizedCAMID2);
                                int objectID2 = store.createSecurityProxyObject(sCAMID, null, null);
                                CMDbStoreObjectReference cMDbStoreObjectReference2 = new CMDbStoreObjectReference(objectID2, store.getObjectClass(objectID2), sNormalizedCAMID2, true);
                                return cMDbStoreObjectReference2;
                            }
                            finally {
                                if (bAcquireLocks) {
                                    store.getLockManager().releaseLocks();
                                }
                            }
                        }
                        catch (AAAException ex) {
                            if (ex.getMessage().indexOf("CAM-AAA-0005") >= 0 && reference.size() == 1 && !mustExist) {
                                return new CMDbStoreObjectReference(-1, null, reference.getOriginalPath());
                            }
                            throw new CMException((Exception)((Object)ex), "cmBadSecurityReferenceCAMError", new CMException.Parm("Reference", reference.getOriginalPath()));
                        }
                    }
                    results = null;
                    lockUsageBackup = reference.getLockManagerUsageFlag();
                    if (bAcquireLocks) {
                        reference.setLockManagerUsageFlag(10);
                        store.getLockManager().requestLocks(reference);
                    }
                    if (!(results = store.executeQuery(reference, null, null, 0, 512, null)).next()) break block26;
                    sNormalizedCAMID3222222 = results.getSecurityReference();
                    sNormalizedSearchPath = results.getSearchPath();
                    objectID = results.getObjectID();
                    objectClass = results.getObjectClass();
                    if (sNormalizedCAMID3222222 == null) {
                        sNormalizedCAMID3222222 = sNormalizedSearchPath;
                    }
                    if (results.next()) {
                        throw new CMException("cmBadSecurityReferenceMultipleSelect", new CMException.Parm("Reference", reference.getOriginalPath()));
                    }
                    if (!createProxy || objectID != 0 || passport == null) break block27;
                    if (!bAcquireLocks) {
                        throw new IllegalStateException("Caller has set bAcquireLocks=false and createProxy=true. Locks must be obatined to create a proxy object.");
                    }
                    store.getLockManager().releaseLocks();
                    sCAMID = CMCAMIDHelper.CAMIDFromSearchPath(sNormalizedSearchPath);
                    objectID = store.createSecurityProxyObject(sCAMID, null, null);
                    if (mustExist && objectID == -1) break block27;
                    CMDbStoreObjectReference cMDbStoreObjectReference3 = new CMDbStoreObjectReference(objectID, objectClass, sNormalizedCAMID3222222);
                    CMQueryUtils.safeQueryResultsRelease(results);
                    if (!bAcquireLocks) return cMDbStoreObjectReference3;
                    store.getLockManager().releaseLocks();
                    reference.clearLocksHaveBeenObtained();
                    reference.setLockManagerUsageFlag(lockUsageBackup);
                    return cMDbStoreObjectReference3;
                }
                try {
                    if (objectID == 0 || objectClass != CMObjectClass.ACCOUNT && objectClass != CMObjectClass.GROUP && objectClass != CMObjectClass.ROLE && objectClass != CMObjectClass.DISTRIBUTIONLIST && objectClass != CMObjectClass.CONTACT) {
                        objectID = -1;
                    }
                    cMDbStoreObjectReference = new CMDbStoreObjectReference(objectID, objectClass, sNormalizedSearchPath, sNormalizedCAMID3222222);
                }
                catch (CMStoreObjectNotFound sNormalizedCAMID3222222) {
                    CMQueryUtils.safeQueryResultsRelease(results);
                    if (bAcquireLocks) {
                        store.getLockManager().releaseLocks();
                        reference.clearLocksHaveBeenObtained();
                        reference.setLockManagerUsageFlag(lockUsageBackup);
                    }
                    break block28;
                    catch (CMException ex) {
                        block29: {
                            CMDbStoreObjectReference cMDbStoreObjectReference4;
                            try {
                                AAAException aaaEx;
                                Exception cause;
                                if (ex.getCode() != "cmNameSpaceQueryErr" || (cause = ex.getException()) == null || !(cause instanceof AAAException) || (aaaEx = (AAAException)((Object)cause)).getMessage().indexOf("CAM-AAA-0005") < 0 || mustExist) break block29;
                                cMDbStoreObjectReference4 = new CMDbStoreObjectReference(-1, null, reference.getOriginalPath());
                            }
                            catch (Throwable throwable) {
                                CMQueryUtils.safeQueryResultsRelease(results);
                                if (!bAcquireLocks) throw throwable;
                                store.getLockManager().releaseLocks();
                                reference.clearLocksHaveBeenObtained();
                                reference.setLockManagerUsageFlag(lockUsageBackup);
                                throw throwable;
                            }
                            CMQueryUtils.safeQueryResultsRelease(results);
                            if (!bAcquireLocks) return cMDbStoreObjectReference4;
                            store.getLockManager().releaseLocks();
                            reference.clearLocksHaveBeenObtained();
                            reference.setLockManagerUsageFlag(lockUsageBackup);
                            return cMDbStoreObjectReference4;
                        }
                        throw ex;
                    }
                }
                CMQueryUtils.safeQueryResultsRelease(results);
                if (!bAcquireLocks) return cMDbStoreObjectReference;
                store.getLockManager().releaseLocks();
                reference.clearLocksHaveBeenObtained();
                reference.setLockManagerUsageFlag(lockUsageBackup);
                return cMDbStoreObjectReference;
            }
            CMQueryUtils.safeQueryResultsRelease(results);
            if (bAcquireLocks) {
                store.getLockManager().releaseLocks();
                reference.clearLocksHaveBeenObtained();
                reference.setLockManagerUsageFlag(lockUsageBackup);
            }
        }
        if (!mustExist) return new CMDbStoreObjectReference(-1, null, reference.getOriginalPath());
        throw new CMException("cmBadSecurityReferenceDoesNotExist", new CMException.Parm("Reference", reference.getOriginalPath()));
    }

    public static int objectIdFromInternalCAMID(String CAMID2) {
        int idxEnd = CAMID2.indexOf(":", 2);
        if (idxEnd < 3) {
            return -1;
        }
        return Integer.parseInt(CAMID2.substring(2, idxEnd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMObjectClass getClassFromCAMID(CMStore store, String sCamID) throws CMException {
        CMStoreXPath camPath = new CMStoreXPath(sCamID);
        CMProperty[] camProps = new CMProperty[]{CMProperty.OBJECTCLASS};
        CMStoreQueryResults camResults = store.executeQuery(camPath, camProps, null, 0, 512, null);
        try {
            camResults.next();
            CMObjectClass cMObjectClass = camResults.getObjectClass();
            return cMObjectClass;
        }
        finally {
            CMQueryUtils.safeQueryResultsRelease(camResults);
        }
    }

    public static CMStoreXPath getCognosNSPath() throws CMStoreParseException {
        return new CMStoreXPath(cognosNSPathStr_);
    }

    public static String getCAMIDFromInternalPath(String sIDPath, boolean bReturnAsCAMFunc) {
        int p1 = sIDPath.lastIndexOf("@id=") + 5;
        char c = sIDPath.charAt(p1 - 1);
        int p2 = sIDPath.lastIndexOf(c);
        String ret = sIDPath.substring(p1, p2);
        if (bReturnAsCAMFunc) {
            ret = "CAMID(" + c + ret + c + ")";
        }
        return ret;
    }

    public static String replaceObjIDInInternalCAMID(int objectID, String srcCAMID) {
        String ret = null;
        int index = -1;
        if (!srcCAMID.startsWith("::")) {
            return ret;
        }
        index = srcCAMID.lastIndexOf(58);
        if (index > 3) {
            String origTimeHex = srcCAMID.substring(index + 1);
            ret = "::" + String.valueOf(objectID) + ":" + origTimeHex;
        }
        return ret;
    }

    public static CMStorePath newInternalPath(String namespaceID) throws CMStoreParseException {
        namespaceID = CMStoreXPath.attributeEncodeString(namespaceID);
        CMStoreXPath path = new CMStoreXPath("/directory/namespace[@id='" + namespaceID + "']");
        return path;
    }

    public static CMStorePath newInternalPath(String namespaceID, String descendantID) throws CMStoreParseException {
        namespaceID = CMStoreXPath.attributeEncodeString(namespaceID);
        descendantID = CMStoreXPath.attributeEncodeString(descendantID);
        CMStoreXPath path = new CMStoreXPath("/directory/namespace[@id='" + namespaceID + "']/descendant::*[@id='" + descendantID + "']");
        return path;
    }

    public static boolean isCurrentUser(ICMStorePath sPath) {
        if (CMExecutionContext.get().getContext().getCurrentUserSession() == null) {
            throw new IllegalArgumentException("Function isCurrentUser() can only be called after the userSession is initialized");
        }
        if (sPath == null) {
            return false;
        }
        boolean bRet = false;
        if (sPath.size() == 1) {
            CMStorePathStep step = sPath.stepAt(0);
            if (step.bCurrentUser_) {
                bRet = true;
            } else {
                String sCurrentUserSearchPath = CMExecutionContext.get().getCurrentUserSearchPath();
                String sCurrentUserCAMID = CMCAMIDHelper.CAMIDFromSearchPath(sCurrentUserSearchPath);
                String sCAMID = sPath.getCAMIDFromFirstStep();
                if (sCAMID != null && sCAMID.equals(sCurrentUserCAMID)) {
                    bRet = true;
                }
            }
        }
        return bRet;
    }

    public static boolean isOpenIDNamespaceObject(String camid) {
        CMCAMNamespace ns = CMCAMIDHelper.getNamespaceFromCAMID(camid);
        return ns != null && ns.isOpenID();
    }

    public static ArrayList<String> getOpenIDNSAncestors(String camid) {
        if (!CMCAMIDHelper.isOpenIDNamespaceObject(camid)) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        String openIDNS = CMCAMIDHelper.getNamespaceIDFromCAMID(camid);
        StringBuilder buf = new StringBuilder();
        buf.append("/directory");
        result.add(buf.toString());
        buf.append("/*[@id=").append(SearchPathEncoder.quoteString((String)openIDNS)).append(']');
        result.add(buf.toString());
        buf.append("/*[@id=").append(SearchPathEncoder.quoteString((String)camid)).append(']');
        result.add(buf.toString());
        return result;
    }
}

