/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CMDOMUtils {
    public static void DumpDOM(Document doc, OutputStream os) {
        PrintStream out = new PrintStream(os, true);
        CMDOMUtils.DumpDOM(doc, out);
    }

    public static void DumpDOM(Document doc, PrintStream out) {
        try {
            out.println("Dom=" + doc.getNodeName());
            NodeList nodes = doc.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Element elem = (Element)nodes.item(i);
                    CMDOMUtils._DumpDOMElement(elem, out, 1);
                }
            }
            out.println("--END");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void _DumpDOMElement(Element elem, PrintStream out, int indent) {
        CMDOMUtils._DoIndent(out, indent);
        out.print("elem=" + elem.getNodeName());
        String sValue = elem.getNodeValue();
        if (sValue != null && sValue.length() > 0) {
            out.print(" '" + sValue + "'");
        }
        out.println("");
        NodeList nodes = elem.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element el = (Element)nodes.item(i);
                CMDOMUtils._DumpDOMElement(el, out, indent + 1);
            }
        }
    }

    private static void _DoIndent(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.write(32);
            out.write(32);
        }
    }

    public static final Element getChildElement(Element parent) {
        NodeList children = parent.getChildNodes();
        int nodeCount = children.getLength();
        for (int nodeIdx = 0; nodeIdx != nodeCount; ++nodeIdx) {
            if (children.item(nodeIdx).getNodeType() != 1) continue;
            return (Element)children.item(nodeIdx);
        }
        return null;
    }

    public static final String getTypeValue(Element el) {
        if (el != null) {
            return el.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        }
        return "";
    }
}

