/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.CAM.AAAException;
import com.cognos.cm.constants.CMSOAPConstants;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreString;
import com.cognos.cm.dbstore.properties.CMDbStoreTypedNameValuePairArray;
import com.cognos.cm.plugin.Interface.CMUpgradeData;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyTypes;
import com.cognos.cm.server.AddDef;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.server.XMLPolicyTransformer;
import com.cognos.cm.util.CMLocaleUtils;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cm.util.CMXMLGenerator;
import com.cognos.cm.util.CMXMLUtils;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.MalformedInputException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class CMDataUpgradeUtils {
    public static final String REPORT_ADMINISTRATORS = "Report Administrators";
    public static final String PORTAL_ADMINISTRATORS = "Portal Administrators";
    public static final String METRICS_ADMINISTRATORS = "Metrics Administrators";
    public static final String METRICS_AUTHORS = "Metrics Authors";
    public static final String METRICS_USERS = "Metrics Users";
    public static final String PLANNING_ADMINISTRATORS = "Planning Administrators";
    public static final String PLANNING_RIGHTS_ADMINISTRATORS = "Planning Rights Administrators";
    public static final String PLANNING_USERS = "Planning Users";
    public static final String PLANNING_CONTRIBUTOR_USERS = "Planning Contributor Users";
    public static final String CONTROLLER_ADMINISTRATORS = "Controller Administrators";
    public static final String POWERPLAY_ADMINISTRATORS = "PowerPlay Administrators";
    public static final String CONTROLLER_USERS = "Controller Users";
    public static final String ANALYSIS_USERS = "Analysis Users";
    public static final String POWERPLAY_USERS = "PowerPlay Users";
    public static final String DATA_MANAGER_AUTHORS = "Data Manager Authors";
    public static final String READERS = "Readers";
    public static final String EXPRESS_AUTHORS = "Express Authors";
    public static final String DIRECTORY_ADMINISTRATORS = "Directory Administrators";
    public static final String AUTHORS = "Authors";
    public static final String QUERY_USERS = "Query Users";
    public static final String CONSUMERS = "Consumers";
    public static final String EXPRESS = "Express";
    public static final String SEARCHPATH_REPORT_ADMIN_ROLE = "CAMID(\":Report Administrators\")";
    public static final String SEARCHPATH_PORTAL_ADMIN_ROLE = "CAMID(\":Portal Administrators\")";
    public static final String SEARCHPATH_METRICS_ADMIN_ROLE = "CAMID(\":Metrics Administrators\")";
    public static final String SEARCHPATH_METRICS_AUTHORS_ROLE = "CAMID(\":Metrics Authors\")";
    public static final String SEARCHPATH_METRICS_USERS_ROLE = "CAMID(\":Metrics Users\")";
    public static final String SEARCHPATH_PLANNING_ADMIN_ROLE = "CAMID(\":Planning Administrators\")";
    public static final String SEARCHPATH_PLANNING_RIGHTS_ADMIN_ROLE = "CAMID(\":Planning Rights Administrators\")";
    public static final String SEARCHPATH_PLANNING_USERS_ROLE = "CAMID(\":Planning Users\")";
    public static final String SEARCHPATH_PLANNING_CONTRIBUTOR_USERS_ROLE = "CAMID(\":Planning Contributor Users\")";
    public static final String SEARCHPATH_CONTROLLER_ADMIN_ROLE = "CAMID(\":Controller Administrators\")";
    public static final String SEARCHPATH_POWERPLAY_ADMIN_ROLE = "CAMID(\":PowerPlay Administrators\")";
    public static final String SEARCHPATH_CONTROLLER_USERS_ROLE = "CAMID(\":Controller Users\")";
    public static final String SEARCHPATH_ANALYSIS_USERS_ROLE = "CAMID(\":Analysis Users\")";
    public static final String SEARCHPATH_POWERPLAY_USERS_ROLE = "CAMID(\":PowerPlay Users\")";
    public static final String SEARCHPATH_DATA_MANAGER_AUTHORS_ROLE = "CAMID(\":Data Manager Authors\")";
    public static final String SEARCHPATH_READERS_ROLE = "CAMID(\":Readers\")";
    public static final String SEARCHPATH_EXPRESS_AUTHORS_ROLE = "CAMID(\":Express Authors\")";
    public static final String SEARCHPATH_DIRECTORY_ADMIN_ROLE = "CAMID(\":Directory Administrators\")";
    public static final String SEARCHPATH_AUTHORS_ROLE = "CAMID(\":Authors\")";
    public static final String SEARCHPATH_QUERY_USERS_ROLE = "CAMID(\":Query Users\")";
    public static final String SEARCHPATH_CONSUMERS_ROLE = "CAMID(\":Consumers\")";
    private static Map<String, HashMap<String, String>> RenamedRolesMapping_;
    private static ArrayList<String> RenamedRoles;
    private static CMXMLGenerator XMLGenerator_;
    public static final String policiesTail = "                   </value>\n               </policies>\n";
    public static final String expressAuthorsPoliciesTX = "                <item xsi:type=\"bus:policy\">\n                     <securityObject xsi:type=\"bus:nil\">\n                        <searchPath xsi:type=\"bus:stringProp\">\n                          <!-- Express Authors T X -->\n                            \t<value xsi:type=\"xsd:string\" xml:space=\"preserve\">CAMID(&quot;:Express Authors&quot;)</value>\n                        </searchPath>\n                    </securityObject>\n                    <permissions xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:permission[2]\">\n                    <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">traverse</name>\n                       \t<access xsi:type=\"bus:accessEnum\">grant</access>\n                   </item>\n                   <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">execute</name>\n                       \t<access xsi:type=\"cm:accessEnum\">grant</access>\n                   </item>\n                   </permissions>\n             </item>\n";
    public static final String readersPolicies = "                   <item xsi:type=\"bus:policy\">\n                     \"<securityObject xsi:type=\"bus:nil\">\n                     \"   <searchPath xsi:type=\"cm:stringProp\">\n                          <!-- Readers T X -->\n                            \t<value xsi:type=\"xsd:string\" xml:space=\"preserve\">CAMID(&quot;:Readers&quot;)</value>\n                       \t</searchPath>\n                   </securityObject>\n                   <permissions xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:permission[2]\">\n                   <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">traverse</name>\n                       \t<access xsi:type=\"bus:accessEnum\">grant</access>\n                   </item>\n                   <item xsi:type=\"bus:permission\">\n                       \t<name xsi:type=\"xsd:string\">execute</name>\n                       \t<access xsi:type=\"bus:accessEnum\">grant</access>\n                   </item>\n                   </permissions>\n             </item>\n";

    public static synchronized void initRenamedRoles() {
        if (RenamedRoles == null) {
            RenamedRolesMapping_ = new HashMap<String, HashMap<String, String>>();
            RenamedRoles = new ArrayList();
            CMDataUpgradeUtils.renameRole("cmInitPlanningAdministrators", "cmInitPlanningAdministratorsOLD");
            CMDataUpgradeUtils.renameRole("cmInitPlanningUsers", "cmInitPlanningUsersOLD");
            CMDataUpgradeUtils.renameRole("cmInitAnalyticsViewer", "cmInitInformationDistribution");
        }
    }

    public static String getRenamedRole(String searchPath, ArrayList<String> locales) {
        for (int i = 0; i < locales.size(); ++i) {
            HashMap<String, String> rolesForLocale;
            String locale = locales.get(i);
            if (!RenamedRolesMapping_.containsKey(locale) || !(rolesForLocale = RenamedRolesMapping_.get(locale)).containsKey(searchPath)) continue;
            return rolesForLocale.get(searchPath);
        }
        return null;
    }

    public static boolean isRoleRenamed(String searchPath) {
        return RenamedRoles.contains(searchPath);
    }

    private static void renameRole(String initMsgNew, String initMsgOld) {
        CMLocalizedStringArray names = null;
        CMLocalizedStringArray namesOld = null;
        try {
            names = CMLocaleUtils.getLocalizedStringsForMessageID(initMsgNew);
            namesOld = CMLocaleUtils.getLocalizedStringsForMessageID(initMsgOld);
        }
        catch (CMException ex) {
            return;
        }
        if (names != null && namesOld != null && names.getSize() == namesOld.getSize()) {
            for (int i = 0; i < names.getSize(); ++i) {
                CMDbStoreLocalizedString stringNew = (CMDbStoreLocalizedString)names.getItem(i);
                CMDbStoreLocalizedString stringOld = (CMDbStoreLocalizedString)namesOld.getItem(i);
                if (stringOld.getLocale() != stringNew.getLocale()) continue;
                HashMap<Object, Object> roles = null;
                if (!RenamedRolesMapping_.containsKey(stringOld.getLocale().toString())) {
                    roles = new HashMap();
                    RenamedRolesMapping_.put(stringOld.getLocale().toString(), roles);
                } else {
                    roles = RenamedRolesMapping_.get(stringOld.getLocale().toString());
                }
                RenamedRoles.add(CMDataUpgradeUtils.searchPathFromRole(stringOld.getValue()));
                roles.put(CMDataUpgradeUtils.searchPathFromRole(stringOld.getValue()), CMDataUpgradeUtils.searchPathFromRole(stringNew.getValue()));
            }
        }
    }

    private static String searchPathFromRole(String role) {
        return "CAMID(\":" + role + "\")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getValueFromProp(CMProperty prop, Object value) throws CMException {
        CMExecutionContext ctx = CMExecutionContext.get();
        String propName = prop.getName();
        String propValue = "";
        if (CMDataUpgradeUtils.isSpecialPropForDataUpgrade(propName)) {
            CMPropertyTypes.Type propType = prop.getType();
            if (propType == CMPropertyTypes.XML_ANYTYPE || propType == CMPropertyTypes.BIBUS_ANYTYPEMIME || propType == CMPropertyTypes.BIBUS_XMLENCODEDXMLMIME || propType == CMPropertyTypes.BIBUS_POWERPLAYDATABLOCKARRAY) {
                if (value instanceof String || value instanceof CMDbStoreString) {
                    return value.toString();
                }
                Reader reader = null;
                CMTempOutputStream tempFileOutputStream = null;
                if (value instanceof InputStream) {
                    if (prop == CMProperty.MODEL || prop == CMProperty.DATABLOCKS) {
                        tempFileOutputStream = new CMTempOutputStream();
                        try {
                            CMStreamUtils.copyStream((InputStream)((InputStream)value), (OutputStream)tempFileOutputStream);
                            tempFileOutputStream.close();
                            reader = new InputStreamReader((InputStream)new GZIPInputStream(tempFileOutputStream.getInputStream()), "UTF-8");
                        }
                        catch (IOException exTemp) {
                            CMStreamUtils.quietClose((Reader)reader);
                            try {
                                tempFileOutputStream.delete();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (exTemp instanceof MalformedInputException) {
                                throw new CMException((Exception)exTemp, "cmBadDataEncoding", new CMException.Parm("Prop", propName));
                            }
                            throw new CMException((Exception)exTemp, "cmPropReadFail", new CMException.Parm("Prop", propName));
                        }
                    }
                    try {
                        reader = new InputStreamReader((InputStream)new GZIPInputStream(new BufferedInputStream((InputStream)value, 32768)), "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                    }
                    catch (IOException ex) {
                        throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                    }
                }
                reader = (Reader)value;
                try {
                    propValue = CMStreamUtils.readReaderIntoString((Reader)reader);
                }
                catch (IOException ex) {
                    throw new CMException((Exception)ex, "cmPropReadFail", new CMException.Parm("Prop", propName));
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                            reader = null;
                        }
                        catch (IOException iOException) {}
                    }
                    if (tempFileOutputStream != null) {
                        try {
                            tempFileOutputStream.delete();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else if (prop == CMProperty.POLICIES) {
            byte[] arrPolicy = (byte[])value;
            if (arrPolicy.length > 0) {
                try {
                    propValue = CMServlet.AAA.DescribePolicy(null, arrPolicy, "<properties xmlns=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[]\"><item xsi:type=\"cm:propEnum\">searchPath</item></properties>", ctx.getCAMAdditionalInfo());
                    XMLPolicyTransformer trns = new XMLPolicyTransformer();
                    propValue = trns.transformXML(propValue);
                }
                catch (AAAException ex) {
                    throw new CMException((Exception)((Object)ex), "cmNoReadPolicy");
                }
                catch (Exception ex) {
                    throw new CMException(ex, "cmNoReadPolicy");
                }
            }
        } else {
            if (XMLGenerator_ == null) {
                XMLGenerator_ = new CMXMLGenerator(ctx.getStore());
            }
            CMXMLGenerator cMXMLGenerator = XMLGenerator_;
            synchronized (cMXMLGenerator) {
                propValue = XMLGenerator_.getPropertyXML(prop, value);
            }
        }
        return propValue;
    }

    public static boolean isSpecialPropForDataUpgrade(String sPropName) {
        boolean bIsExceptional = false;
        bIsExceptional = sPropName.equals("model") || sPropName.equals("specification") || sPropName.equals("dataBlocks");
        return bIsExceptional;
    }

    private static String normalize_xsiType(String type) {
        int pos = type.indexOf(":");
        if (pos == -1) {
            return type;
        }
        return type.substring(pos + 1, type.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPropertyIntoAddDef(AddDef addDef, CMProperty prop, String propValue, CMObjectClass objClass) throws CMException {
        if (addDef == null) {
            return;
        }
        CMExecutionContext ctx = CMExecutionContext.get();
        XMLElement valueElm = null;
        if (CMDataUpgradeUtils.isSpecialPropForDataUpgrade(prop.getName())) {
            boolean xmlEncode;
            boolean bl = xmlEncode = prop.getType() != CMPropertyTypes.BIBUS_POWERPLAYDATABLOCKARRAY;
            valueElm = xmlEncode ? CMXMLUtils.convertXMLString2XMLElement(CMXMLUtils.wrapInCDATASection(propValue)) : CMXMLUtils.convertXMLString2XMLElement(propValue);
        } else {
            XMLElement root = CMXMLUtils.convertXMLString2XMLElement(propValue);
            if (root != null) {
                XMLElement theProp = root.getChild(0);
                if (theProp != null) {
                    valueElm = theProp.getOptionalChildWithName("value");
                }
                if (valueElm == null) {
                    valueElm = new XMLElement().addChild(null, "value", null, null, null);
                    valueElm.isNil_ = true;
                }
                if (prop == CMProperty.OPTIONS) {
                    if (valueElm.children_ != null) {
                        CMDbStoreTypedNameValuePairArray optionsPropValue = CMDataUpgradeUtils.collectOptionsValue(valueElm);
                        addDef.addUnique(prop, optionsPropValue);
                    }
                    return;
                }
                if (prop.getType() == CMPropertyTypes.BIBUS_POLICYARRAY || prop.getType() == CMPropertyTypes.BIBUS_USERCAPABILITYPOLICYARRAY) {
                    try {
                        if (XMLGenerator_ == null) {
                            XMLGenerator_ = new CMXMLGenerator(ctx.getStore());
                        }
                        CMXMLGenerator optionsPropValue = XMLGenerator_;
                        synchronized (optionsPropValue) {
                            addDef.put(prop, XMLGenerator_.packPolicies(prop, valueElm));
                        }
                    }
                    catch (CMException ex) {
                        throw new CMException((Exception)ex, "cmBadPropertyData", new CMException.Parm("Property", prop.getName()));
                    }
                    return;
                }
            }
        }
        if (valueElm != null) {
            if (XMLGenerator_ == null) {
                XMLGenerator_ = new CMXMLGenerator(ctx.getStore());
            }
            CMXMLGenerator cMXMLGenerator = XMLGenerator_;
            synchronized (cMXMLGenerator) {
                XMLGenerator_.addOnePropertyIntoAddDef(addDef, prop, valueElm, objClass);
            }
        }
    }

    protected static CMDbStoreTypedNameValuePairArray collectOptionsValue(XMLElement valueElm) throws CMException {
        CMDbStoreTypedNameValuePairArray optionsPropValue = new CMDbStoreTypedNameValuePairArray();
        ListIterator<XMLElement> iter = valueElm.getChildren().listIterator();
        while (iter.hasNext()) {
            XMLElement elOption = iter.next();
            XMLElement elName = elOption.getOptionalChildWithName("name");
            XMLElement elValue = elOption.getOptionalChildWithName("value");
            if (elName == null) continue;
            if (elValue != null) {
                elValue.normalize();
                optionsPropValue.add(elName.value_, CMDataUpgradeUtils.normalize_xsiType(elName.xsiType_), elValue.makeXML("", true, false, false), CMDataUpgradeUtils.normalize_xsiType(elOption.xsiType_));
                continue;
            }
            StringBuffer valueBuf = new StringBuffer();
            ListIterator<XMLElement> it = elOption.getChildren().listIterator();
            while (it.hasNext()) {
                XMLElement el = it.next();
                if (el.name_.equals("name")) continue;
                el.normalize();
                valueBuf.append(el.makeXML("", true, false, false));
            }
            if (valueBuf.length() == 0) {
                throw new CMException("cmMissingNameOrValue");
            }
            optionsPropValue.add(elName.value_, CMDataUpgradeUtils.normalize_xsiType(elName.xsiType_), valueBuf.toString(), CMDataUpgradeUtils.normalize_xsiType(elOption.xsiType_));
        }
        return optionsPropValue;
    }

    public static void addPolicyToPolicyArray(XMLElement elPolicyArray, String searchPath, String[] actions) {
        CMDataUpgradeUtils.addPolicyToPolicyArray(elPolicyArray, searchPath, actions, "grant");
    }

    public static void addPolicyToPolicyArray(XMLElement elPolicyArray, String searchPath, String[] actions, String access) {
        XMLElement newPolicy = elPolicyArray.addChild(null, "item", CMSOAPConstants.NS_XMLSCHEMAINSTANCE, "policy", null);
        XMLElement elem = newPolicy.addChild(null, "securityObject", CMSOAPConstants.NS_BIBUS, "baseClass", null);
        elem = elem.addChild(null, "searchPath", CMSOAPConstants.NS_BIBUS, "stringProp", null);
        elem = elem.addChild(null, "value", CMSOAPConstants.NS_XMLSCHEMA, "string", searchPath);
        XMLElement elemPerms = newPolicy.addChild(null, "permissions", CMSOAPConstants.NS_BIBUS, "permission", null);
        elemPerms.isArray_ = true;
        XMLElement permItem = null;
        for (int i = 0; i < actions.length; ++i) {
            permItem = elemPerms.addChild(null, "item", CMSOAPConstants.NS_BIBUS, "permission", null);
            elem = permItem.addChild(null, "name", CMSOAPConstants.NS_XMLSCHEMA, "string", actions[i]);
            elem = permItem.addChild(null, "access", CMSOAPConstants.NS_BIBUS, "accessEnum", access);
        }
    }

    public static int convertSeverityEnumToIPFLevel(String severity) {
        if (severity == null) {
            return -1;
        }
        int ipfLevel = -1;
        if (severity.equalsIgnoreCase("fatal")) {
            ipfLevel = 50000;
        } else if (severity.equalsIgnoreCase("error")) {
            ipfLevel = 40000;
        } else if (severity.equalsIgnoreCase("warn")) {
            ipfLevel = 30000;
        } else if (severity.equalsIgnoreCase("info")) {
            ipfLevel = 20000;
        } else if (severity.equalsIgnoreCase("debug")) {
            ipfLevel = 10000;
        }
        return ipfLevel;
    }

    public static String convertIPFLevelToSeverityEnum(int ipfLevel) {
        String severity = null;
        switch (ipfLevel) {
            case 50000: {
                severity = "fatal";
                break;
            }
            case 40000: {
                severity = "error";
                break;
            }
            case 30000: {
                severity = "warn";
                break;
            }
            case 20000: {
                severity = "info";
                break;
            }
            case 10000: {
                severity = "debug";
            }
        }
        return severity;
    }

    public static int cmUpgradeSeverityToIpfSeverity(int upgradeSeverity) {
        switch (upgradeSeverity) {
            case 10000: {
                return 10000;
            }
            case 40000: {
                return 40000;
            }
            case 50000: {
                return 50000;
            }
            case 20000: {
                return 20000;
            }
            case 30000: {
                return 30000;
            }
        }
        return 40000;
    }

    public static String getPropertyValue(CMUpgradeData upgradeData, String propName) throws Exception {
        XMLDocParser parser;
        XMLElement propEl;
        XMLElement propValueEl;
        String propXML = (String)upgradeData.getPropertyValue(propName);
        if (propXML != null && (propValueEl = (propEl = (parser = new XMLDocParser()).readXMLFragment(propXML).getRootXMLElement().getChildWithName(propName)).getOptionalChildWithName("value")) != null) {
            return propValueEl.value_;
        }
        return null;
    }

    public static String buildDelete(String searchPath, boolean recursive) {
        StringBuffer gather = new StringBuffer();
        String isRecursive = recursive ? "true" : "false";
        gather.append("<cm:delete xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n <search xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)searchPath)).append("</search>\n <options xsi:type=\"bus:deleteOptions\">\n  <recursive xsi:type=\"xsd:boolean\">").append(isRecursive).append("</recursive>\n </options>\n</cm:delete>");
        return gather.toString();
    }

    public static String buildQuery(String searchPath, String[] properties) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:query xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("\t<search xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)searchPath)).append("</search>\n\t<properties xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:propEnum[").append(properties.length).append("]\">\n");
        for (int i = 0; i < properties.length; ++i) {
            gather.append("\t\t<item xsi:type=\"cm:propEnum\">").append(properties[i]).append("</item>\n");
        }
        gather.append("\t</properties>\n</cm:query>");
        return gather.toString();
    }

    public static Element parseResponse(String response) throws Exception {
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(response));
        List responseList = XMLUtils.selectNodes((Document)document, (String)"/*[local-name()='Envelope']/*[local-name()='Body']/*/*");
        if (responseList.size() != 1) {
            throw new Exception("Unexpected response from CM, expecting single result from xpath '/*[local-name()='Envelope']/*[local-name()='Body']/*/*', response:\n" + response);
        }
        return (Element)responseList.get(0);
    }

    public static void validateResponse(String response) throws Exception {
        if (response == null) {
            throw new Exception("CM has been shutdown. Data upgrade has been aborted.");
        }
        if (response.indexOf("<SOAP-ENV:Fault") != -1) {
            throw new Exception("Request failed:\n" + response);
        }
    }

    public static String buildUpdate(String searchPath, String objectClass, String[] propertyAndValueXMLs) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:update    xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\"    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"    xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"    xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("   <objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">\n       <item xsi:type=\"bus:").append(objectClass).append("\">\n            <searchPath xsi:type=\"bus:stringProp\">\n                <value xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)searchPath)).append("</value>\n            </searchPath>");
        for (String propAndValueXML : propertyAndValueXMLs) {
            gather.append(propAndValueXML);
        }
        gather.append("       </item>\n   </objects>\n</cm:update>");
        return gather.toString();
    }

    public static String buildAdd(String searchPath, String objectClass, List<String> objs) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:add    xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("  <requests xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"cm:addRequest[1]\">\n").append("    <item xsi:type=\"cm:addRequest\">\n").append("      <search xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)searchPath)).append("</search>\n").append("      <objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[").append(objs.size()).append("]\">\n");
        for (String props : objs) {
            gather.append("        <item xsi:type=\"bus:").append(objectClass).append("\">\n");
            gather.append(props);
            gather.append("        </item>\n");
        }
        gather.append("      </objects>\n").append("    </item>\n").append("  </requests>\n").append("</cm:add>");
        return gather.toString();
    }

    public static String buildMove(String sourceSearchPath, String targetSearchPath) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:move    xmlns:cm=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("      <search xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)sourceSearchPath)).append("</search>\n").append("      <target xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)targetSearchPath)).append("</target>\n").append("</cm:move>");
        return gather.toString();
    }

    public static String buildMoveRename(String sourceSearchPath, String targetSearchPath, String objectClass, String newName) {
        StringBuffer gather = new StringBuffer();
        gather.append("<cm:moveRename    xmlns:cm=\"http://developer.cognos.com/schemas/contentManagerService/1\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">\n").append("<objects xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">\n    <item xsi:type=\"bus:").append(objectClass).append("\">\n        <searchPath xsi:type=\"bus:stringProp\">\n            <value xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)sourceSearchPath)).append("</value>\n        </searchPath>").append("    </item>\n</objects>\n").append("<targetPath xsi:type=\"bus:searchPathSingleObject\">").append(XMLUtils.escape((String)targetSearchPath)).append("</targetPath>\n").append("<newNames xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:baseClass[1]\">\n    <item xsi:type=\"xsd:string\">").append(XMLUtils.escape((String)newName)).append("</item>\n</newNames>\n").append("</cm:moveRename>");
        return gather.toString();
    }

    public static List<Element> extractSecuredFeaturesElements(String response) throws Exception {
        Document responseDoc;
        List result = null;
        SAXReader reader = new SAXReader();
        try {
            responseDoc = reader.read((Reader)new StringReader(response));
        }
        catch (DocumentException e1) {
            throw new Exception("Query response is not valid XML");
        }
        try {
            Element soapBodyEle = responseDoc.getRootElement().element("Body");
            Element queryResponseEle = soapBodyEle.element("queryResponse");
            Element queryResultEle = queryResponseEle.element("queryResult");
            result = queryResultEle.elements("item");
        }
        catch (NullPointerException e) {
            throw new Exception("Query response does not contain item elements");
        }
        return result;
    }

    public static boolean getIsFromDeployment(CMUpgradeData data) throws CMException {
        String deployment = (String)data.getPropertyValue("UPGRADE_FROM");
        if (deployment == null) {
            throw new CMException("UPGRADE_FROM info was not provided!");
        }
        if (deployment.equalsIgnoreCase("DEPLOYMENT")) {
            return true;
        }
        if (!deployment.equalsIgnoreCase("DB")) {
            throw new CMException("UPGRADE_FROM info has invalid value!");
        }
        return false;
    }

    public static String getSearchPath(CMUpgradeData data) throws CMException {
        String searchPathXML = (String)data.getPropertyValue("searchPath");
        if (searchPathXML == null || searchPathXML.length() == 0) {
            return null;
        }
        XMLElement searchPathRootXML = CMXMLUtils.convertXMLString2XMLElement(searchPathXML);
        if (searchPathRootXML == null) {
            return null;
        }
        return searchPathRootXML.getOptionalValueFromChildWithNameWithinChildWithName("searchPath", "value");
    }

    public static boolean getAreAcquired(CMUpgradeData data) throws CMException {
        String acquired = (String)data.getPropertyValue("POLICIES_ACQUIRED");
        if (acquired == null) {
            throw new CMException("POLICIES_ACQUIRED info was not provided!");
        }
        if (acquired.equalsIgnoreCase("TRUE")) {
            return true;
        }
        if (!acquired.equalsIgnoreCase("FALSE")) {
            throw new CMException("POLICIES_ACQUIRED info has invalid value!");
        }
        return false;
    }

    public static List<String> extractPoliciesFromResponseXML(String response) throws Exception {
        Document document;
        ArrayList<String> toReturn = new ArrayList<String>();
        SAXReader reader = new SAXReader();
        try {
            document = reader.read((Reader)new StringReader(response));
        }
        catch (DocumentException e) {
            throw new Exception("Response is not valid XML");
        }
        try {
            Element soapBodyEle = document.getRootElement().element("Body");
            Element queryResponseEle = soapBodyEle.element("queryResponse");
            Element queryResultEle = queryResponseEle.element("queryResult");
            Element queryResultItemEle = queryResultEle.element("item");
            Element policiesEle = queryResultItemEle.element("policies");
            Element valueEle = policiesEle.element("value");
            if (valueEle == null) {
                return toReturn;
            }
            List policiesItems = valueEle.elements("item");
            for (int i = 0; i < policiesItems.size(); ++i) {
                toReturn.add(((Node)policiesItems.get(i)).asXML());
            }
            return toReturn;
        }
        catch (NullPointerException e) {
            throw new Exception("Unable to parse XML");
        }
    }

    public static String getPoliciesHead(int items) {
        return "     <policies><value xsi:type=\"SOAP-ENC:Array\" SOAP-ENC:arrayType=\"bus:policy[" + items + "]\">\n";
    }

    static {
        XMLGenerator_ = null;
    }
}

