/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.util.CMLocalTimestamp;
import com.cognos.cmutils.date.DateUtils;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class CMDateUtils
extends DateUtils {
    protected static Calendar staticCalendarForTesting = null;
    protected static Clock clock = new Clock();

    public static void setCalendarInstanceForTesting(Calendar calendar) {
        staticCalendarForTesting = calendar;
        clock = calendar == null ? new Clock() : new Clock(){

            @Override
            public long getTimeMillis() {
                return staticCalendarForTesting.getTimeInMillis();
            }
        };
    }

    public static Calendar getCalendarInstance() {
        Calendar calendar = staticCalendarForTesting;
        if (calendar == null) {
            calendar = Calendar.getInstance(CMDateUtils.getUTCTimeZone());
        }
        return calendar;
    }

    public static Clock getClock() {
        return clock;
    }

    public static String getIsoDate(Timestamp date, Calendar calendar) {
        calendar.setTime(date);
        calendar.set(14, date.getNanos() / 1000000);
        return CMDateUtils.getIsoDate((Calendar)calendar);
    }

    public static String getIsoDate(Date date, Calendar calendar) {
        calendar.setTime(date);
        return CMDateUtils.getIsoDate((Calendar)calendar);
    }

    public static String getIsoDate() {
        return CMDateUtils.getIsoDate((Calendar)CMDateUtils.getCalendarInstance());
    }

    public static String getIsoDate(Date date) {
        Calendar calendar = CMDateUtils.getCalendarInstance();
        return CMDateUtils.getIsoDate(date, calendar);
    }

    public static Date getTime() {
        Calendar gmtCalendar = CMDateUtils.getCalendarInstance();
        return gmtCalendar.getTime();
    }

    public static Timestamp getTimestamp(Date date, boolean adjustForTimestamp) {
        if (adjustForTimestamp) {
            return new Timestamp(CMDateUtils.getUTCTimeAdjustedForTimestamp(date));
        }
        return new Timestamp(DateUtils.getUTCTime((Date)date));
    }

    public static Timestamp getTimestamp(boolean adjustForTimestamp) {
        return CMDateUtils.getTimestamp(new Date(clock.getTimeMillis()), adjustForTimestamp);
    }

    public static long getUTCTimeFromTimestamp(Timestamp ts) {
        if (ts instanceof CMLocalTimestamp) {
            return DateUtils.getUTCTime((Date)ts);
        }
        return ts.getTime();
    }

    public static long getUTCTime() {
        return DateUtils.getUTCTime((Date)CMDateUtils.getTime());
    }

    public static boolean isTimeAroundFirstHourOfDSTTransition(Timestamp ts) {
        long tsTime;
        boolean result = false;
        if (localTimeZoneUsesDST_ && tzDSTSavings_ > 0 && !localTimeZone_.inDaylightTime(new Date((tsTime = ts.getTime()) - (long)tzDSTSavings_)) && localTimeZone_.inDaylightTime(new Date(tsTime + (long)tzDSTSavings_))) {
            result = true;
        }
        return result;
    }

    private static long getUTCTimeAdjustedForTimestamp(Date date) {
        long gmtOffset = defaultTimeZone.getRawOffset();
        long gmtTime = date.getTime() - gmtOffset;
        if (defaultTimeZone.inDaylightTime(new Date(gmtTime))) {
            gmtTime -= (long)defaultTimeZone.getDSTSavings();
        }
        return gmtTime;
    }

    public static class Clock {
        public long getTimeMillis() {
            return System.currentTimeMillis();
        }
    }
}

