/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreUtil;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreNotAvailable;
import com.cognos.cm.store.CMStoreUnexpected;
import com.cognos.cm.util.CMDeferredInitAction;
import com.cognos.cm.util.CMMethodInvoker;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CMDeferredInitActionUtils {
    public static void addDeferredAction(CMMethodInvoker action, String actionType, String actionName) {
        Properties props = ConfigurationFactory.getConfig().getProperties();
        Object propValue = props.get(actionType);
        ArrayList<CMDeferredInitAction> postInitActions = propValue == null ? new ArrayList<CMDeferredInitAction>() : (ArrayList<CMDeferredInitAction>)propValue;
        CMDeferredInitAction deferredAction = new CMDeferredInitAction(action, actionName);
        postInitActions.add(deferredAction);
        props.put(actionType, postInitActions);
    }

    public static void executeDeferredInitActions(CMDbConnection con, String actionType) throws CMException {
        CMException.Parm[] parms = new CMException.Parm[]{new CMException.Parm("action", actionType)};
        CMIndications.Audit_Message_FreeFormText("cmDeferedInitActionStart", parms, 50000, "StartService", "ContentManagerService", "", "Info", null);
        List<?> postInitOps = ConfigurationFactory.getConfig().getList(actionType);
        if (postInitOps == null) {
            return;
        }
        for (int i = 0; i != postInitOps.size(); ++i) {
            Object op = postInitOps.get(i);
            if (!(op instanceof CMDeferredInitAction)) {
                throw new CMConfigurationException("cmUnexpectedError");
            }
            CMDeferredInitAction deferredAction = (CMDeferredInitAction)op;
            try {
                CMExecutionContext.checkCancelOrTimeOut();
                deferredAction.methodInvoker_.invoke();
                if (deferredAction.actionName_ == null) continue;
                CMDbStoreUtil.deleteScriptStepName(con, deferredAction.actionName_);
                continue;
            }
            catch (CMException e) {
                throw e;
            }
            catch (SQLException e) {
                CMStore store = CMExecutionContext.get().getStore();
                CMException ex = store.analyzeException(e);
                if (ex instanceof CMStoreNotAvailable) {
                    throw ex;
                }
                if (!CMIndications.logEnabled("Trace.CM.SQL", 30000)) continue;
                CMIndications.CMTrace("cmSQLConnectionException", new CMException.Parm[]{new CMException.Parm("Exception", ex.getMessage()), new CMException.Parm("ConID", con == null ? "null" : Integer.toString(con.getID()))});
                continue;
            }
            catch (Exception e) {
                throw new CMStoreUnexpected(e, "cmUnexpectedError");
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        CMIndications.Audit_Message_FreeFormText("cmDeferedInitActionEnd", parms, 50000, "StartService", "ContentManagerService", "", "Info", null);
        postInitOps.clear();
    }
}

