/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.DeploymentCipherStreamSession;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.request.Deployment;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMServlet;
import com.cognos.cm.util.MultiVolumeZipFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class CMDeploymentArchive {
    private File archiveFile_;
    private byte[] archivePassword_;
    private String archiveName_;
    private ZipFile zipFile_;
    private ZipInputStream zipStream_;
    private HashSet<String> seenEntries_;
    private DeploymentCipherStreamSession cipherSession_;
    public static boolean debug_ = false;
    public static final String decryptedArchiveDir_ = "decryptedArchive";
    private File decryptDir_ = null;

    public CMDeploymentArchive(String archiveName, byte[] archiveEncryptPassword) throws CMException {
        this.archiveName_ = archiveName;
        this.archivePassword_ = archiveEncryptPassword;
        try {
            File deploymentFolder = Deployment.getDeploymentFolder();
            this.archiveFile_ = new File(deploymentFolder, this.archiveName_ + ".zip");
        }
        catch (Exception e) {
            throw new CMException(e, "cmArchiveNotExist", new CMException.Parm("Archive", this.archiveName_));
        }
        if (!this.archiveFile_.exists()) {
            throw new CMException("cmArchiveNotExist", new CMException.Parm("Archive", this.archiveName_));
        }
        this.open();
        this.validate();
    }

    private void open() throws CMException {
        try {
            this.zipFile_ = new MultiVolumeZipFile(this.archiveFile_);
        }
        catch (CMException e) {
            if (e.getCode() == "cmArchiveBad") {
                throw e;
            }
            throw new CMException((Exception)e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
        }
        catch (Exception e) {
            this.resetStream();
            if (this.isSingleStreamArchive()) {
                return;
            }
            this.close();
            String msg = e.getMessage();
            if (msg.indexOf("filename") != -1 && msg.indexOf("incorrect") != -1) {
                throw new CMException(e, "cmBadArchiveName1", new CMException.Parm("Archive", this.archiveName_));
            }
            throw new CMException(e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
        }
    }

    public List<String> entries() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.zipFile_ != null) {
            Enumeration<? extends ZipEntry> it = this.zipFile_.entries();
            while (it.hasMoreElements()) {
                ZipEntry entry = it.nextElement();
                list.add(this.getEntryName(entry));
            }
        }
        return list;
    }

    private String getEntryName(ZipEntry e) {
        String s = e.getName();
        if (s.endsWith("Encrypt")) {
            return s.substring(0, s.length() - "Encrypt".length());
        }
        return s;
    }

    private boolean isSingleStreamArchive() {
        boolean isSingleStreamArchive = false;
        if (!this.archiveContains("volume.id") && !this.archiveContains("data/0.dat")) {
            isSingleStreamArchive = true;
        }
        return isSingleStreamArchive;
    }

    private boolean archiveContains(String property) {
        try {
            this.getInputStream(property);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void validate() throws CMException {
        try {
            int n;
            InputStream is = this.getInputStream("content.xml");
            byte[] buffer = new byte[14];
            int off = 0;
            do {
                if ((n = is.read(buffer, off, 14 - off)) != -1) continue;
                throw new CMException("cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
            } while ((off += n) < 14);
            String str = new String(buffer, 0, 14, "UTF-8");
            if (!str.equals("<?xml version=")) {
                throw new CMException("cmImportCryptoFailed", new CMException.Parm("Archive", this.archiveName_));
            }
            is.close();
        }
        catch (CMException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            throw new CMException(e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
        }
    }

    private void resetStream() throws CMException {
        try {
            if (this.zipStream_ != null) {
                this.zipStream_.close();
            }
            this.seenEntries_ = new HashSet();
            this.zipStream_ = new ZipInputStream(new FileInputStream(this.archiveFile_));
        }
        catch (Exception e) {
            throw new CMException(e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
        }
    }

    private ZipEntry findEntry(String entryName) throws CMException {
        ZipEntry entry = null;
        if (this.zipFile_ != null) {
            entry = this.zipFile_.getEntry(entryName);
            if (entry == null) {
                entry = this.zipFile_.getEntry(entryName + "Encrypt");
            }
        } else {
            String encryptedName = entryName + "Encrypt";
            if (this.seenEntries_.contains(entryName) || this.seenEntries_.contains(encryptedName)) {
                this.resetStream();
            }
            try {
                while ((entry = this.zipStream_.getNextEntry()) != null) {
                    String name = entry.getName();
                    this.seenEntries_.add(name);
                    if (!name.equals(entryName) && !name.equals(encryptedName)) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new CMException(e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
            }
        }
        if (entry == null) {
            throw new CMException("cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
        }
        return entry;
    }

    private InputStream getInputStream(ZipEntry entry) throws CMException {
        boolean isEncrypted = false;
        if (entry.getName().endsWith("Encrypt")) {
            isEncrypted = true;
        }
        InputStream stream = null;
        try {
            stream = this.zipFile_ != null ? this.zipFile_.getInputStream(entry) : new FilterInputStream(this.zipStream_){

                @Override
                public void close() {
                }
            };
            if (isEncrypted) {
                if (this.archivePassword_ == null) {
                    throw new CMException("cmArchiveEncrypted", new CMException.Parm("Archive", this.archiveName_));
                }
                if (this.cipherSession_ == null) {
                    this.cipherSession_ = CMServlet.CAMFactory_.createDeploymentCipherStreamSession(this.archivePassword_);
                }
                stream = this.cipherSession_.createDecryptingInputStream(stream);
                stream = new BufferedInputStream(stream);
            }
        }
        catch (CAMCryptoException e) {
            throw new CMException((Exception)((Object)e), "cmImportCryptoFailed", new CMException.Parm("Archive", this.archiveName_));
        }
        catch (CMException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMException(e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
        }
        return stream;
    }

    public InputStream getInputStream(String entryName) throws CMException {
        return this.getInputStream(this.findEntry(entryName));
    }

    public void close() {
        try {
            if (this.zipFile_ != null) {
                this.zipFile_.close();
                this.zipFile_ = null;
            }
            if (this.zipStream_ != null) {
                this.zipStream_.close();
                this.zipStream_ = null;
            }
        }
        catch (Exception e) {
            CMException ex = new CMException(e, "cmArchiveBad", new CMException.Parm("Archive", this.archiveName_));
            CMIndications.logException(ex);
        }
    }

    public void dump() {
        if (!debug_) {
            return;
        }
        if (this.zipFile_ == null && this.zipStream_ == null) {
            return;
        }
        try {
            File deploymentFolder = Deployment.getDeploymentFolder();
            this.decryptDir_ = new File(deploymentFolder, decryptedArchiveDir_);
            this.decryptDir_.mkdir();
            if (this.zipFile_ != null) {
                Enumeration<? extends ZipEntry> it = this.zipFile_.entries();
                while (it.hasMoreElements()) {
                    ZipEntry entry = it.nextElement();
                    if (entry.isDirectory()) {
                        new File(this.decryptDir_, entry.getName()).mkdirs();
                        continue;
                    }
                    InputStream is = this.getInputStream(entry);
                    this.dumpEntry(is, entry.getName());
                    is.close();
                }
            } else {
                ZipEntry entry;
                this.resetStream();
                while ((entry = this.zipStream_.getNextEntry()) != null) {
                    InputStream is = this.getInputStream(entry);
                    this.dumpEntry(is, entry.getName());
                    this.zipStream_.closeEntry();
                }
                this.resetStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void dumpEntry(InputStream istream, String entryName) {
        try {
            int numBytes;
            File archiveFile;
            File parent;
            if (entryName.endsWith("Encrypt")) {
                int len = entryName.length() - "Encrypt".length();
                entryName = entryName.substring(0, len);
            }
            if ((parent = (archiveFile = new File(this.decryptDir_, entryName)).getParentFile()) != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (archiveFile.exists()) {
                archiveFile.delete();
            }
            archiveFile.createNewFile();
            FileOutputStream outStream = new FileOutputStream(archiveFile);
            byte[] buffer = new byte[8096];
            while ((numBytes = istream.read(buffer)) >= 0) {
                outStream.write(buffer, 0, numBytes);
            }
            outStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getName() {
        return this.archiveName_;
    }
}

