/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class CMIndentedPrintStream
extends PrintStream {
    private boolean bIndentedLine = false;
    private int indentLevel = 0;
    private String tab = "\t";

    public CMIndentedPrintStream(PrintStream out) {
        super(out);
    }

    public CMIndentedPrintStream(OutputStream out) {
        super(out);
    }

    public CMIndentedPrintStream(OutputStream out, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
        super(out, autoFlush, encoding);
    }

    private void doIndent() {
        if (!this.bIndentedLine) {
            for (int i = 0; i < this.indentLevel; ++i) {
                super.print(this.tab);
            }
            this.bIndentedLine = true;
        }
    }

    public void setTab(String s) {
        this.tab = s;
    }

    public String getTab() {
        return this.tab;
    }

    public void indent() {
        ++this.indentLevel;
    }

    public void unindent() {
        --this.indentLevel;
    }

    public void adjustIndentLevel(int delta) {
        this.indentLevel += delta;
    }

    public int getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(int level) {
        this.indentLevel = level;
    }

    private void newLine() {
        this.print("\n");
        this.bIndentedLine = false;
    }

    @Override
    public void print(boolean flag) {
        this.doIndent();
        super.print(flag);
    }

    @Override
    public void print(char c) {
        this.doIndent();
        super.print(c);
    }

    @Override
    public void print(int i) {
        this.doIndent();
        super.print(i);
    }

    @Override
    public void print(long l) {
        this.doIndent();
        super.print(l);
    }

    @Override
    public void print(float f) {
        this.doIndent();
        super.print(f);
    }

    @Override
    public void print(double d) {
        this.doIndent();
        super.print(d);
    }

    @Override
    public void print(char[] ac) {
        this.doIndent();
        super.print(ac);
    }

    public void print(byte[] ab) {
        this.doIndent();
        super.write(ab, 0, ab.length);
    }

    @Override
    public void print(String s) {
        this.doIndent();
        super.print(s);
    }

    @Override
    public void print(Object obj) {
        this.doIndent();
        super.print(obj);
    }

    @Override
    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(boolean flag) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(flag);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char c) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(c);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(int i) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(i);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(long l) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(l);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(float f) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(f);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(double d) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(d);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(char[] ac) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(ac);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(byte[] ab) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(new String(ab));
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(String s) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(s);
            this.newLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void println(Object obj) {
        CMIndentedPrintStream cMIndentedPrintStream = this;
        synchronized (cMIndentedPrintStream) {
            this.print(obj);
            this.newLine();
        }
    }
}

