/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import java.util.ArrayList;

public class CMIntList {
    private int size_;
    private int chunkSize_ = 1024;
    private ArrayList<int[]> data_ = new ArrayList();

    public CMIntList() {
        this.chunkSize_ = 1024;
    }

    public CMIntList(int chunkSize) {
        if (chunkSize <= 0) {
            throw new IllegalStateException("chunkSize is not a positive number.");
        }
        this.chunkSize_ = chunkSize;
    }

    public void add(int value) {
        int[] chunk;
        int entryIndex = this.size_ / this.chunkSize_;
        int entryOffset = this.size_ % this.chunkSize_;
        if (entryIndex > this.data_.size()) {
            throw new IllegalStateException("Internal error: wrong entryIndex");
        }
        if (entryIndex == this.data_.size()) {
            chunk = new int[this.chunkSize_];
            this.data_.add(chunk);
        } else {
            chunk = this.data_.get(entryIndex);
        }
        chunk[entryOffset] = value;
        ++this.size_;
    }

    public void set(int index, int value) {
        if (index < 0 || index >= this.size_) {
            throw new IndexOutOfBoundsException();
        }
        int entryIndex = index / this.chunkSize_;
        int entryOffset = index % this.chunkSize_;
        int[] chunk = this.data_.get(entryIndex);
        chunk[entryOffset] = value;
    }

    public void setSize(int size) {
        if (size > this.size_) {
            int entryIndex = size / this.chunkSize_;
            while (entryIndex >= this.data_.size()) {
                int[] chunk = new int[this.chunkSize_];
                this.data_.add(chunk);
            }
        }
        this.size_ = size;
    }

    public int size() {
        return this.size_;
    }

    public int get(int index) {
        if (index >= this.size_) {
            throw new IndexOutOfBoundsException();
        }
        int entryIndex = index / this.chunkSize_;
        int entryOffset = index % this.chunkSize_;
        int[] chunk = this.data_.get(entryIndex);
        return chunk[entryOffset];
    }

    public int[] toArray() {
        int[] ret = new int[this.size_];
        int[] currChunk = null;
        int chunkNum = -1;
        int offset = -1;
        int currChunkNum = -1;
        for (int i = 0; i < this.size_; ++i) {
            chunkNum = i / this.chunkSize_;
            offset = i % this.chunkSize_;
            if (currChunk == null || currChunkNum != chunkNum) {
                currChunk = this.data_.get(chunkNum);
                currChunkNum = chunkNum;
            }
            ret[i] = currChunk[offset];
        }
        return ret;
    }

    public boolean contains(int value) {
        int[] currChunk = null;
        int chunkNum = -1;
        int offset = -1;
        int currChunkNum = -1;
        for (int i = 0; i < this.size_; ++i) {
            chunkNum = i / this.chunkSize_;
            offset = i % this.chunkSize_;
            if (currChunk == null || currChunkNum != chunkNum) {
                currChunk = this.data_.get(chunkNum);
                currChunkNum = chunkNum;
            }
            if (value != currChunk[offset]) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.size_ = 0;
    }
}

