/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedString;
import com.cognos.cm.dbstore.properties.CMDbStoreLocalizedStringArray;
import com.cognos.cm.dbstore.properties.CMDbStoreStringLocales;
import com.cognos.cm.properties.CMLocalizedStringArray;
import com.cognos.cm.properties.CMStringLocale;
import com.cognos.cm.server.CMConfigurationException;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.CMStoreXPathStep;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cmutils.path.SearchPathEncoder;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class CMLocaleUtils {
    private static ArrayList theSystemLocales_ = null;
    private static ArrayList<String> theInitLocales_ = null;

    public static CMLocalizedStringArray getLocalizedStringsForMessageID(String messageID) throws CMException {
        ArrayList<String> locales = CMLocaleUtils.getInitLocales();
        CMDbStoreLocalizedStringArray stringList = new CMDbStoreLocalizedStringArray();
        ListIterator<String> iter = locales.listIterator();
        while (iter.hasNext()) {
            CMStringLocale locale;
            String valueIdLocale = iter.next();
            String value = CMError.getMessage(messageID, null, CMLocaleUtils.parseLocale(valueIdLocale));
            String localeID = null;
            try {
                IConfiguration config = ConfigurationFactory.getConfig();
                localeID = config.normalizeLocale(valueIdLocale);
                if (!config.validateContentLocale(localeID)) {
                    localeID = null;
                }
            }
            catch (CMConfigurationException ex) {
                throw new CMException(ex, "cmUnexpectedError");
            }
            if (localeID == null || (locale = CMDbStoreStringLocales.findLocale(localeID)) == null) continue;
            CMDbStoreLocalizedString string = new CMDbStoreLocalizedString(locale, value);
            stringList.add(string);
        }
        return stringList;
    }

    public static ArrayList getSystemLocales() {
        if (theSystemLocales_ != null) {
            return theSystemLocales_;
        }
        theSystemLocales_ = CMLocaleUtils.getLocales("cmmsgs");
        return theSystemLocales_;
    }

    public static ArrayList<String> getInitLocales() {
        if (theInitLocales_ != null) {
            return theInitLocales_;
        }
        theInitLocales_ = CMLocaleUtils.getLocales("cmmsgsRL");
        return theInitLocales_;
    }

    private static ArrayList getLocales(String resourceFileName) {
        int iUnderscoreCharPos = resourceFileName.length();
        ArrayList<String> locales = new ArrayList<String>();
        String strServerLocale = null;
        String strMappedServerLocale = null;
        CMResourceLoader resourceLoader = CMResourceUtils.getResourceLoader();
        String[] resourceNames = resourceLoader.listResourceNames("/WEB-INF/classes/");
        if (resourceNames != null) {
            try {
                IConfiguration config = ConfigurationFactory.getConfig();
                strServerLocale = ConfigurationFactory.getConfig().getServerLocale().toString();
                strMappedServerLocale = config.mapContentLocale(strServerLocale, false);
            }
            catch (CMConfigurationException config) {
                // empty catch block
            }
            int bestServerLocaleMatch = 0;
            int serverLocaleMatchScore = 5;
            IConfiguration config = null;
            for (int i = 0; i < resourceNames.length; ++i) {
                int dotIndex;
                String name = resourceNames[i];
                if (!name.startsWith(resourceFileName) || (dotIndex = name.lastIndexOf(46)) <= 0 || dotIndex <= iUnderscoreCharPos + 1 || name.charAt(iUnderscoreCharPos) != '_') continue;
                String strLocale = name.substring(iUnderscoreCharPos + 1, dotIndex);
                try {
                    String localeThere;
                    int compare;
                    config = ConfigurationFactory.getConfig();
                    String localeID = config.normalizeLocale(strLocale);
                    if (localeID == null) continue;
                    int iL = 0;
                    for (iL = 0; iL < locales.size() && (compare = (localeThere = (String)locales.get(iL)).compareTo(localeID)) != 0; ++iL) {
                        if (compare <= 0) continue;
                        locales.add(iL, localeID);
                        break;
                    }
                    if (iL != locales.size()) continue;
                    locales.add(localeID);
                    continue;
                }
                catch (CMConfigurationException cMConfigurationException) {
                    // empty catch block
                }
            }
            try {
                for (int iL = 0; iL < locales.size(); ++iL) {
                    String localeID = (String)locales.get(iL);
                    if (serverLocaleMatchScore > 1 && strServerLocale.equalsIgnoreCase(localeID)) {
                        bestServerLocaleMatch = iL;
                        serverLocaleMatchScore = 1;
                        continue;
                    }
                    if (serverLocaleMatchScore > 2 && strMappedServerLocale != null && strMappedServerLocale.equalsIgnoreCase(localeID)) {
                        bestServerLocaleMatch = iL;
                        serverLocaleMatchScore = 2;
                        continue;
                    }
                    if (serverLocaleMatchScore <= 3) continue;
                    String strMappedLocaleID = config.mapContentLocale(localeID, false);
                    if (strMappedServerLocale != null && strMappedServerLocale.equalsIgnoreCase(strMappedLocaleID)) {
                        bestServerLocaleMatch = iL;
                        serverLocaleMatchScore = 3;
                    }
                    if (serverLocaleMatchScore <= 4 || !localeID.startsWith("en")) continue;
                    bestServerLocaleMatch = iL;
                    serverLocaleMatchScore = 4;
                }
            }
            catch (CMConfigurationException iL) {
                // empty catch block
            }
            if (bestServerLocaleMatch > 0) {
                Object newfirst = locales.get(bestServerLocaleMatch);
                for (int iL = bestServerLocaleMatch; iL > 0; --iL) {
                    Object moveForward = locales.get(iL - 1);
                    locales.set(iL, (String)moveForward);
                }
                locales.set(0, (String)newfirst);
            }
        }
        if (locales.size() < 1) {
            locales.add("en");
        }
        return locales;
    }

    public static String toString(Locale locale) {
        StringBuffer buf = new StringBuffer();
        buf.append(locale.getLanguage());
        String str = locale.getCountry();
        if (str != null && str.length() > 0) {
            buf.append('-');
            buf.append(str);
        }
        if ((str = locale.getVariant()) != null && str.length() > 0) {
            buf.append('-');
            buf.append(str);
        }
        return buf.toString();
    }

    public static Locale parseLocale(String localeStr) {
        if (localeStr == null) {
            return null;
        }
        int nBreak = localeStr.indexOf(45);
        if (nBreak < 0) {
            nBreak = localeStr.indexOf(95);
        }
        String language = localeStr;
        String country = null;
        String variant = null;
        if (nBreak > 0) {
            language = localeStr.substring(0, nBreak);
            country = localeStr.substring(nBreak + 1);
            if ((nBreak = country.indexOf(45)) < 0) {
                nBreak = country.indexOf(95);
            }
            if (nBreak > 0) {
                variant = country.substring(nBreak + 1);
                country = country.substring(0, nBreak);
            }
        } else {
            country = "";
        }
        if (variant == null) {
            return new Locale(language, country);
        }
        return new Locale(language, country, variant);
    }

    public static List<String> localizeNameAttributesInSearchPaths(List<String> searchPaths) throws CMException {
        ArrayList<String> localizedSearchPaths = new ArrayList<String>();
        for (String searchPath : searchPaths) {
            CMStoreXPath pathTemplate = new CMStoreXPath(searchPath);
            String localizedSearchPath = searchPath;
            int pathTemplateSize = pathTemplate.size();
            HashMap<String, String> msgIdToLocalizedStringMap = new HashMap<String, String>();
            for (int stepIndex = 0; stepIndex < pathTemplateSize; ++stepIndex) {
                CMStoreXPathStep step = (CMStoreXPathStep)pathTemplate.stepAt(stepIndex);
                String msgId = step.getName();
                if (msgId == null || msgIdToLocalizedStringMap.containsKey(msgId)) continue;
                String localizedName = CMLocaleUtils.getLocalizedString(msgId);
                msgIdToLocalizedStringMap.put(msgId, localizedName);
            }
            for (String msgId : msgIdToLocalizedStringMap.keySet()) {
                String regexMatchesMsgIdInSingleOrDoubleQuotes = "('|\\\")" + msgId + "\\1";
                String replaceValue = SearchPathEncoder.quoteString((String)((String)msgIdToLocalizedStringMap.get(msgId)));
                localizedSearchPath = localizedSearchPath.replaceAll(regexMatchesMsgIdInSingleOrDoubleQuotes, replaceValue);
            }
            localizedSearchPaths.add(localizedSearchPath);
        }
        return localizedSearchPaths;
    }

    private static String getLocalizedString(String msgId) {
        ArrayList<String> systemLocales = CMLocaleUtils.getInitLocales();
        if (systemLocales.size() > 0) {
            String defaultSystemLocaleID = systemLocales.get(0);
            return CMError.getMessage(msgId, null, CMLocaleUtils.parseLocale(defaultSystemLocaleID));
        }
        return msgId;
    }
}

