/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMBadEncodingException;

public class CMNameEncode {
    static final String strEncodeChars = new String("[]/.%:*");
    static final String[] strEncodeCharsValues = new String[]{new String("%5B"), new String("%5D"), new String("%2F"), new String("%2E"), new String("%25"), new String("%3A"), new String("%2A")};

    public static final boolean InvalidEncoding(String strName) {
        int nLength = strName.length();
        for (int i = 0; i < nLength; ++i) {
            char c = strName.charAt(i);
            if (strEncodeChars.indexOf(c) < 0) continue;
            if (c == '%') {
                char c1 = strName.charAt(i + 1);
                char c2 = strName.charAt(i + 2);
                if ((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f')) continue;
            }
            return true;
        }
        return false;
    }

    public static final boolean AnyEncodingsToDo(String strName) {
        int nLength = strName.length();
        for (int i = 0; i < nLength; ++i) {
            char c = strName.charAt(i);
            if (strEncodeChars.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    public static final boolean AnyDecodingsToDo(String strName) {
        return strName.indexOf(37) >= 0;
    }

    public static final String Encode(String strName) {
        if (!CMNameEncode.AnyEncodingsToDo(strName)) {
            return strName;
        }
        StringBuffer strBufName = new StringBuffer(strName);
        CMNameEncode.Encode(strBufName);
        return strBufName.toString();
    }

    public static final String Decode(String strName) throws CMBadEncodingException {
        StringBuffer strBufName = new StringBuffer(strName);
        CMNameEncode.Decode(strBufName);
        return strBufName.toString();
    }

    public static final void Encode(StringBuffer strName) {
        strName.ensureCapacity(strName.length() * 3);
        int nLen = strName.length();
        for (int i = 0; i < nLen; ++i) {
            int index = strEncodeChars.indexOf(strName.charAt(i));
            if (index < 0) continue;
            strName.replace(i, i + 1, strEncodeCharsValues[index]);
            i += 2;
            nLen += 2;
        }
    }

    public static final void Decode(StringBuffer strName) throws CMBadEncodingException {
        char[] cHex = new char[]{'0', 'x', 'X', 'Y'};
        for (int i = 0; i < strName.length(); ++i) {
            if (strName.charAt(i) == '%' && strName.length() > i + 2) {
                char c1 = strName.charAt(i + 1);
                char c2 = strName.charAt(i + 2);
                if (!((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f'))) {
                    throw new CMBadEncodingException(new CMException.Parm("badChars", strName.substring(i, i + 3)));
                }
                cHex[2] = strName.charAt(i + 1);
                cHex[3] = strName.charAt(i + 2);
                String strHexNum = new String(cHex);
                Integer anInteger = Integer.decode(strHexNum);
                char c = (char)anInteger.intValue();
                strName.setCharAt(i, c);
                strName.delete(i + 1, i + 3);
                continue;
            }
            if (strEncodeChars.indexOf(strName.charAt(i)) < 0) continue;
            throw new CMBadEncodingException(new CMException.Parm("badChars", strName.substring(i, i + 1)));
        }
    }
}

