/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.constants.CMSOAPConstants;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;

public class CMNamespacePrefixes
extends LinkedList {
    private static final long serialVersionUID = -4353751892125409168L;
    private HashMap mNames_ = new HashMap();
    private boolean bDoingImport_ = false;

    public CMNamespacePrefixes() {
    }

    public CMNamespacePrefixes(boolean bImport) {
        this.bDoingImport_ = bImport;
    }

    public void add(String prefix, String namespace) {
        if (prefix != null && prefix.length() == 0) {
            return;
        }
        CMSOAPConstants.XMLNamespace ns = null;
        if (namespace != null && (ns = CMSOAPConstants.findXMLNamespace(namespace)) == null && this.bDoingImport_ && namespace.equals("http://developer.cognos.com/schemas/bibus/2/")) {
            ns = CMSOAPConstants.NS_BIBUS;
        }
        Entry e = new Entry(prefix, ns);
        this.add(0, e);
        if (this.mNames_ == null) {
            this.mNames_ = new HashMap();
        }
        this.mNames_.put(prefix, ns);
    }

    public void remove(String prefix) {
        Entry ns = null;
        String sPrefix = null;
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        ListIterator iter = this.listIterator(0);
        while (iter.hasNext()) {
            ns = (Entry)iter.next();
            sPrefix = ns.sPrefix_;
            if ((sPrefix != null || prefix != null) && sPrefix.compareTo(prefix) != 0) continue;
            iter.remove();
            if (this.mNames_ == null) break;
            this.mNames_.remove(prefix);
            CMSOAPConstants.XMLNamespace nsNew = this.findNSInLinkedList(prefix);
            if (nsNew == null) break;
            this.mNames_.put(prefix, nsNew);
            break;
        }
    }

    private CMSOAPConstants.XMLNamespace findNSInLinkedList(String prefix) {
        CMSOAPConstants.XMLNamespace ret = null;
        ListIterator iter = this.listIterator(0);
        while (iter.hasNext()) {
            Entry nsEntry = (Entry)iter.next();
            String targetPrefix = nsEntry.sPrefix_;
            if ((prefix != null || targetPrefix != null) && (prefix == null || targetPrefix == null || targetPrefix.compareTo(prefix) != 0)) continue;
            ret = nsEntry.namespace_;
            break;
        }
        return ret;
    }

    public CMSOAPConstants.XMLNamespace findNS(String prefix) {
        CMSOAPConstants.XMLNamespace ret = null;
        if (this.mNames_ != null) {
            ret = (CMSOAPConstants.XMLNamespace)this.mNames_.get(prefix);
        }
        return ret;
    }

    public static class Entry {
        public String sNamespace_;
        public CMSOAPConstants.XMLNamespace namespace_;
        public String sPrefix_;

        public Entry(String sPrefix, CMSOAPConstants.XMLNamespace namespace) {
            this.namespace_ = namespace;
            this.sPrefix_ = sPrefix;
            if (this.sPrefix_ != null && this.sPrefix_.length() == 0) {
                this.sPrefix_ = null;
            }
            if (namespace != null) {
                this.sNamespace_ = namespace.getUri();
            }
        }
    }
}

