/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.util.clock.CMClock;

public class CMPerfAlarm {
    public static final double NO_RATIO_ALARM = -1.0;

    public static long getSystemTicks() {
        long nOpStart = CMClock.getTicks();
        return nOpStart;
    }

    public static long ticksToMillis(long ticks) {
        return (long)CMClock.convertTicksToMillis((long)ticks);
    }

    public static void alarmTicksNow1Arg(long startTicks, long threshold, String module, String methName, Object arg1) {
        long ticks = CMPerfAlarm.getSystemTicks() - startTicks;
        long millis = CMPerfAlarm.ticksToMillis(ticks);
        if (millis > threshold) {
            StringBuffer sb = new StringBuffer();
            CMPerfAlarm.writeAlarmDetail(module, methName, sb);
            CMPerfAlarm.writeDuration(millis, sb);
            sb.append(", args=(").append(arg1).append(")");
            CMPerfAlarm.logException(sb.toString());
        }
    }

    public static void alarmTicksNowArgs(long startTicks, long threshold, String module, String methName, Object[] args) {
        long ticks = CMPerfAlarm.getSystemTicks() - startTicks;
        long millis = CMPerfAlarm.ticksToMillis(ticks);
        CMPerfAlarm.alarmMillisDurationArgs(millis, threshold, module, methName, args);
    }

    public static void alarmMillisDurationArgs(long durationMillis, long threshold, String module, String methName, Object[] args) {
        if (durationMillis > threshold) {
            StringBuffer sb = new StringBuffer();
            CMPerfAlarm.writeAlarmDetail(module, methName, sb);
            CMPerfAlarm.writeDuration(durationMillis, sb);
            CMPerfAlarm.writeArgs(args, sb);
            CMPerfAlarm.logException(sb.toString());
        }
    }

    public static boolean alarmRatioViolation(long hits, long evictions, String module, String methName) {
        if (CMPerfAlarm.isRatioFail(hits, evictions)) {
            CMPerfAlarm.issueRatioAlarm(module, methName, hits, evictions);
            return true;
        }
        return false;
    }

    public static boolean isRatioFail(long hits, long evictions) {
        double ratio = AdvancedSettings.HIT_EVICTION_ALARM_RATIO;
        if (ratio == -1.0) {
            return false;
        }
        if (ratio > 0.0 && evictions > 0L && hits == 0L) {
            return true;
        }
        return ratio < (double)evictions / (double)hits;
    }

    private static void issueRatioAlarm(String module, String methName, long hits, long evictions) {
        StringBuffer sb = new StringBuffer();
        CMPerfAlarm.writeAlarmDetail(module, methName, sb);
        sb.append(": hits=").append(hits);
        sb.append(": evictions=").append(evictions);
        CMPerfAlarm.logException(sb.toString());
    }

    private static void writeArgs(Object[] args, StringBuffer sb) {
        sb.append(", args=(");
        if (args != null) {
            String sep = "";
            for (int i = 0; i < args.length; ++i) {
                sb.append(sep).append(args[i]);
                sep = ",";
            }
        }
        sb.append(")");
    }

    private static void logException(String s) {
        Exception ex = new Exception(s);
        CMIndications.logException(ex);
    }

    private static void writeDuration(long durationMillis, StringBuffer sb) {
        sb.append(": duration=").append(durationMillis);
    }

    private static void writeAlarmDetail(String module, String methName, StringBuffer sb) {
        sb.append("CM-PERF-ALARM: ").append(module).append(".").append(methName);
    }
}

