/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreParseException;
import com.cognos.cm.store.path.CMStorePath;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.store.path.ICMStorePath;
import com.cognos.cm.util.ICMQueryUtils;

public class CMQueryUtils
implements ICMQueryUtils {
    public static int getChildCountForTenantId(CMStore store, String containerSearchPath, CMObjectClass childObjectClass, String tenantId) throws CMStoreParseException, CMException {
        if (tenantId == null) {
            tenantId = "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(containerSearchPath).append("/").append(childObjectClass.getName());
        builder.append("[@").append(CMProperty.TENANTID.getName()).append("='").append(CMStoreXPath.attributeEncodeString(tenantId)).append("']");
        return CMQueryUtils.getCount(store, CMStoreXPath.parse(builder.toString()));
    }

    public static int getChildCount(CMStore store, String containerSearchPath, CMObjectClass childObjectClass) throws CMStoreParseException, CMException {
        StringBuilder builder = new StringBuilder();
        builder.append(containerSearchPath).append("/").append(childObjectClass.getName());
        return CMQueryUtils.getCount(store, CMStoreXPath.parse(builder.toString()));
    }

    public static Object getProp(CMStore store, CMStorePath targetPath, CMProperty prop) throws CMException {
        return CMQueryUtils.getProp(store, targetPath, prop, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getProp(CMStore store, CMStorePath targetPath, CMProperty prop, int requiredPermissions) throws CMException {
        Object obj = null;
        CMStoreQueryResults results = null;
        try {
            CMProperty[] props = new CMProperty[]{prop};
            results = store.executeQuery(targetPath, props, null, 0, requiredPermissions, null);
            if (results.next()) {
                obj = results.getValue(0);
            }
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(CMStore store, CMStorePath targetPath) throws CMException {
        int size = 0;
        CMStoreQueryResults results = null;
        try {
            results = store.executeQuery(targetPath, null, null, 0, 512, null);
            while (results.next()) {
                ++size;
            }
        }
        catch (Throwable throwable) {
            CMQueryUtils.safeQueryResultsRelease(results);
            throw throwable;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CMStorePath getParentSearchPath(CMStore store, CMStorePath targetPath) throws CMException {
        CMStoreQueryResults results;
        block5: {
            CMStorePath cMStorePath;
            boolean found = true;
            results = null;
            try {
                CMStorePath objectContext;
                results = store.executeQuery(targetPath, null, null, 0, 512, null);
                if (!results.next()) {
                    results.release();
                    results = null;
                    results = store.executeQuery(targetPath, null, null, 9, 512, null);
                    if (!results.next()) {
                        found = false;
                    }
                }
                if (!found) break block5;
                String path = results.getParentSearchPath();
                cMStorePath = objectContext = CMStoreXPath.parse(path);
            }
            catch (Throwable throwable) {
                CMQueryUtils.safeQueryResultsRelease(results);
                throw throwable;
            }
            CMQueryUtils.safeQueryResultsRelease(results);
            return cMStorePath;
        }
        CMQueryUtils.safeQueryResultsRelease(results);
        CMStorePath pathParent = targetPath.getParent();
        if (pathParent == null) {
            throw new CMException("cmNoParent", new CMException.Parm("Path", targetPath.toString()));
        }
        return pathParent;
    }

    public static final void safeQueryResultsRelease(CMStoreQueryResults results) {
        try {
            if (results != null) {
                results.release();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static final void safeReleaseLocks(CMExecutionContext ctx) {
        try {
            ctx.getStore().getLockManager().releaseLocks();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getPath(CMStore store, String stargetPath) {
        if (stargetPath == null) {
            return null;
        }
        try {
            CMStorePath targetPath = CMStoreXPath.parse(stargetPath);
            return CMQueryUtils.getPath(store, targetPath);
        }
        catch (CMException e) {
            return stargetPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPath(CMStore store, ICMStorePath targetPath) {
        if (targetPath == null) {
            return null;
        }
        String path = null;
        String originalPath = targetPath.getOriginalPath();
        String madePath = null;
        CMStoreQueryResults results = null;
        boolean found = false;
        try {
            while (!found && targetPath.size() > 0) {
                results = store.executeQuery(targetPath, null, null, 9, 1, null);
                if (results.next()) {
                    path = results.getPath();
                    found = true;
                    continue;
                }
                results.release();
                results = null;
                String lastName = targetPath.getPathNameForNode(-1);
                if (lastName == null) {
                    throw new CMException("useTheOriginalPath");
                }
                lastName = "/" + lastName;
                madePath = madePath == null ? lastName : lastName + madePath;
                targetPath = targetPath.removeStep(-1);
            }
            if (madePath != null) {
                path = path == null ? madePath : path + madePath;
            } else if (path == null) {
                path = originalPath;
            }
        }
        catch (Exception ex) {
            path = originalPath;
        }
        finally {
            if (results != null) {
                results.release();
            }
        }
        return path;
    }

    public static String createSlashPath(CMStore store, String stargetPath) {
        if (stargetPath == null) {
            return null;
        }
        try {
            CMStorePath targetPath = CMStoreXPath.parse(stargetPath);
            return CMQueryUtils.createSlashPath(store, targetPath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String createSlashPath(CMStore store, CMStorePath targetPath) {
        block15: {
            String string;
            block14: {
                CMAncestors ancestors;
                CMStoreQueryResults results;
                StringBuffer madePath;
                block12: {
                    String string2;
                    block13: {
                        block10: {
                            String string3;
                            block11: {
                                if (targetPath == null) {
                                    return null;
                                }
                                madePath = new StringBuffer();
                                results = null;
                                CMProperty[] props = new CMProperty[]{CMProperty.ANCESTORS};
                                results = store.executeQuery(targetPath, props, null, 0, 1, null);
                                if (results.next()) break block10;
                                string3 = null;
                                if (results == null) break block11;
                                CMQueryUtils.safeQueryResultsRelease(results);
                            }
                            return string3;
                        }
                        ancestors = null;
                        ancestors = (CMAncestors)results.getValue(0);
                        if (ancestors != null) break block12;
                        string2 = null;
                        if (results == null) break block13;
                        CMQueryUtils.safeQueryResultsRelease(results);
                    }
                    return string2;
                }
                try {
                    for (int i = 0; i < ancestors.getSize(); ++i) {
                        madePath.append('/');
                        madePath.append(ancestors.getObjectClass(i));
                        madePath.append("[@");
                        madePath.append(CMProperty.NAME.getName());
                        madePath.append("=");
                        madePath.append(CMStoreXPath.attributeQuoteString(ancestors.getName(i)));
                        madePath.append("]");
                    }
                    madePath.append('/');
                    madePath.append(results.getObjectClass().getName());
                    madePath.append("[@");
                    madePath.append(CMProperty.NAME.getName());
                    madePath.append("=");
                    madePath.append(CMStoreXPath.attributeQuoteString(results.getName()));
                    madePath.append("]");
                    string = madePath.toString();
                    if (results == null) break block14;
                }
                catch (Exception exception) {
                    if (results != null) {
                        CMQueryUtils.safeQueryResultsRelease(results);
                    }
                    break block15;
                    catch (Throwable throwable) {
                        if (results != null) {
                            CMQueryUtils.safeQueryResultsRelease(results);
                        }
                        throw throwable;
                    }
                }
                CMQueryUtils.safeQueryResultsRelease(results);
            }
            return string;
        }
        return null;
    }

    @Override
    public Object getObjectProp(CMStore store, CMStorePath targetPath, CMProperty prop, int requiredPermissions) throws CMException {
        return CMQueryUtils.getProp(store, targetPath, prop, requiredPermissions);
    }
}

