/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cmutils.io.CMStreamUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CMStringUtils {
    public static final String sEOL = "\r\n";
    public static final String sManyTabs = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";

    public static String getTabs(int nTabs) {
        if (nTabs <= 0) {
            return "";
        }
        int maxTabs = sManyTabs.length();
        if (nTabs > maxTabs) {
            nTabs = maxTabs;
        }
        return sManyTabs.substring(0, nTabs);
    }

    public static byte[] getUTF8BytesFromString(String s) {
        byte[] baRet = null;
        if (s != null) {
            try {
                baRet = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                CMIndications.logException(ex);
            }
        }
        return baRet;
    }

    public static String subBraceStringAdd(String sTarget, String sToSub, String sToReplace) {
        String str = CMStringUtils.subBraceString(sTarget, sToSub, sToReplace);
        if (str.equals(sTarget) && sToSub != null) {
            StringBuffer strBuf = new StringBuffer(sTarget);
            strBuf.append("; ");
            strBuf.append(sToSub);
            strBuf.append("=");
            if (sToReplace == null) {
                strBuf.append("null");
            } else {
                strBuf.append(sToReplace);
            }
            str = strBuf.toString();
        }
        return str;
    }

    public static String subBraceString(String sTarget, String sToSub, String sToReplace) {
        if (sTarget == null) {
            return null;
        }
        String strRep = new String("{" + sToSub + "}");
        int startPos = sTarget.indexOf(strRep);
        if (startPos < 0) {
            return sTarget;
        }
        int endPos = startPos + strRep.length();
        if (endPos <= startPos) {
            return sTarget;
        }
        if (sToReplace == null) {
            sToReplace = "";
        }
        StringBuffer strBuf = new StringBuffer(sTarget);
        strBuf.replace(startPos, endPos, sToReplace);
        sTarget = strBuf.toString();
        return sTarget;
    }

    public static List<String> getBraceStringSubs(String strTarget) {
        int nStart;
        ArrayList<String> subList = new ArrayList<String>();
        if (strTarget == null) {
            return subList;
        }
        for (int nLast = 0; nLast < strTarget.length() && (nStart = strTarget.indexOf(123, nLast)) >= 0 && (nLast = strTarget.indexOf(125, nStart + 1)) >= nStart; ++nLast) {
            String sSub = strTarget.substring(nStart + 1, nLast);
            subList.add(sSub);
        }
        return subList;
    }

    public static final int getUTF8Length(String str) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int charCount = str.length();
        for (int charIdx = 0; charIdx != charCount; ++charIdx) {
            char x = str.charAt(charIdx);
            if (x > '\u07ff') {
                count += 3;
                continue;
            }
            if (x > '\u007f') {
                count += 2;
                continue;
            }
            ++count;
        }
        return count;
    }

    public static final byte[] compressUTF8String(String str) throws IOException {
        byte[] data = null;
        if (str.length() > 0) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(str.length());
            OutputStreamWriter os = new OutputStreamWriter((OutputStream)new GZIPOutputStream(baos), "UTF-8");
            os.write(str);
            ((Writer)os).close();
            data = baos.toByteArray();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String decompressUTF8String(InputStream is) throws IOException {
        String result = null;
        Reader reader = null;
        if (is != null) {
            try {
                reader = new InputStreamReader((InputStream)new GZIPInputStream(is), "UTF-8");
                result = CMStreamUtils.readReaderIntoString((Reader)reader);
            }
            catch (IOException ex) {
                if (reader != null) {
                    reader.close();
                }
                reader = null;
                CMTempOutputStream tempFileOutputStream = null;
                is.reset();
                try {
                    tempFileOutputStream = new CMTempOutputStream();
                    CMStreamUtils.copyStream((InputStream)is, (OutputStream)tempFileOutputStream);
                    tempFileOutputStream.close();
                    reader = new InputStreamReader((InputStream)new GZIPInputStream(tempFileOutputStream.getInputStream()), "UTF-8");
                    result = CMStreamUtils.readReaderIntoString((Reader)reader);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tempFileOutputStream != null) {
                        try {
                            tempFileOutputStream.delete();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return result;
    }

    public static String removeChar(String s, char c) {
        StringBuffer r = new StringBuffer();
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == c) continue;
                r.append(s.charAt(i));
            }
        }
        return r.toString();
    }

    public static String join(String separator, String ... args) {
        if (args.length == 0) {
            return "";
        }
        if (args.length == 1) {
            return args[0];
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String s : args) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static String join(String separator, Collection<String> args) {
        if (args.size() == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String s : args) {
            if (first) {
                first = false;
            } else {
                buf.append(separator);
            }
            buf.append(s);
        }
        return buf.toString();
    }

    public static ArrayList<String> split(String s, char separator, boolean trim) {
        int end;
        ArrayList<String> parts = new ArrayList<String>();
        int start = 0;
        do {
            if ((end = s.indexOf(separator, start)) == -1) {
                end = s.length();
            }
            String part = s.substring(start, end);
            if (trim) {
                part = part.trim();
            }
            parts.add(part);
        } while ((start = end + 1) < s.length());
        return parts;
    }

    public static ArrayList<String> split(String s, char separator) {
        return CMStringUtils.split(s, separator, false);
    }

    public static String removeQuotes(String text) {
        char dQ = '\"';
        char sQ = '\'';
        if (text.charAt(0) == dQ && text.charAt(text.length() - 1) == dQ || text.charAt(0) == sQ && text.charAt(text.length() - 1) == sQ) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static Set<String> parseParameterListSetAsComaSeparatedString(String buf) {
        if (buf != null) {
            StringTokenizer tokenizer = new StringTokenizer(buf, ", ", false);
            HashSet<String> result = new HashSet<String>(tokenizer.countTokens());
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken());
            }
            return result;
        }
        return null;
    }

    public static String normalizeApostropheAndQuote(String name) {
        if (name.contains("'") && name.contains("\"")) {
            name = name.replaceAll("\"", "_");
        }
        return name;
    }

    public static String collapseWhitespace(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        char[] buf = new char[s.length()];
        s.getChars(0, buf.length, buf, 0);
        int end = buf.length;
        for (int i = 0; i < end; ++i) {
            int n;
            if (buf[i] > ' ') continue;
            buf[i] = 32;
            for (n = i + 1; n < end && buf[n] <= ' '; ++n) {
            }
            if (i + 1 == n) continue;
            System.arraycopy(buf, n, buf, i + 1, end - n);
            end -= n - i - 1;
        }
        if (end < buf.length) {
            return new String(buf, 0, end);
        }
        return s;
    }
}

