/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cmutils.values.CMInt;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfMonitor;
import java.util.HashMap;

public class CMSynchronizedLRUCache {
    private Entry head_;
    private Entry tail_;
    protected HashMap<Object, Entry> entries_;
    private CMInt maxEntryCount_;
    private String name_;
    private PerfCounter perfCounterHits_;
    private PerfCounter perfCounterMisses_;

    public CMSynchronizedLRUCache(int size, String name) {
        this(new CMInt(size), name);
    }

    public CMSynchronizedLRUCache(CMInt size, String name) {
        this.entries_ = new HashMap(size.intValue());
        this.maxEntryCount_ = size;
        this.name_ = name;
        this.perfCounterHits_ = PerfMonitor.getCounter((String)("com.cognos.cm.cache." + this.name_ + ".hits"), (String)("The number of " + this.name_ + " hits"), (int)6);
        this.perfCounterMisses_ = PerfMonitor.getCounter((String)("com.cognos.cm.cache." + this.name_ + ".misses"), (String)("The number of " + this.name_ + " misses"), (int)6);
    }

    public synchronized void add(Object key, Object value) {
        Entry entry = this.entries_.get(key);
        if (entry != null) {
            entry.value_ = value;
        } else {
            entry = this.addEntry(key, value);
        }
        this.touch(entry);
    }

    public Object get(Object key) {
        Object value = this.getEntryValue(key);
        if (value == null) {
            this.perfCounterMisses_.incr();
            return null;
        }
        this.perfCounterHits_.incr();
        return value;
    }

    public void remove(Object key) {
        Entry entry = this.entries_.remove(key);
        if (entry != null) {
            this.unlink(entry);
        }
    }

    public void clear() {
        this.entries_.clear();
        this.head_ = null;
        this.tail_ = null;
    }

    protected void touch(Entry entry) {
        if (entry != this.head_) {
            this.unlink(entry);
            this.insertAtHead(entry);
        }
    }

    private void unlink(Entry entry) {
        Entry prevEntry = entry.previous_;
        Entry nextEntry = entry.next_;
        if (prevEntry != null) {
            prevEntry.next_ = nextEntry;
            entry.previous_ = null;
        } else if (this.head_ == entry) {
            this.head_ = nextEntry;
        }
        if (nextEntry != null) {
            nextEntry.previous_ = prevEntry;
            entry.next_ = null;
        } else if (this.tail_ == entry) {
            this.tail_ = prevEntry;
        }
    }

    private void insertAtHead(Entry entry) {
        if (this.head_ != null) {
            this.head_.previous_ = entry;
            entry.next_ = this.head_;
        } else {
            this.tail_ = entry;
        }
        this.head_ = entry;
    }

    protected Entry addEntry(Object key, Object value) {
        Entry entry;
        if (this.maxEntryCount_.intValue() > this.entries_.size()) {
            entry = new Entry(key, value);
            this.entries_.put(key, entry);
        } else {
            entry = this.entries_.remove(this.tail_.key_);
            while (this.maxEntryCount_.intValue() <= this.entries_.size()) {
                this.entries_.remove(this.tail_.key_);
            }
            entry.key_ = key;
            entry.value_ = value;
            this.entries_.put(key, entry);
        }
        return entry;
    }

    private synchronized Object getEntryValue(Object key) {
        Entry entry = this.entries_.get(key);
        if (entry == null) {
            return null;
        }
        this.touch(entry);
        return entry.value_;
    }

    private void dumpInLRUOrder() {
        Entry iter = this.tail_;
        while (iter != null) {
            System.out.println("key : " + iter.key_.toString());
            iter = iter.previous_;
        }
    }

    public static void main(String[] args) {
        CMSynchronizedLRUCache cache = new CMSynchronizedLRUCache(15, "TestCache");
        for (int i = 0; i < 25; ++i) {
            Integer val = new Integer((int)(Math.random() * 100.0));
            if (cache.get(val) != null) {
                System.out.println("found object " + val.toString());
                if (!(Math.random() * 100.0 < 20.0)) continue;
                System.out.println("removing object " + val.toString());
                cache.remove(val);
                continue;
            }
            System.out.println("adding object " + val.toString());
            cache.add(val, new Object());
        }
        cache.dumpInLRUOrder();
    }

    protected static class Entry {
        Object key_;
        Object value_;
        Entry next_;
        Entry previous_;

        public Entry(Object key, Object value) {
            this.key_ = key;
            this.value_ = value;
        }
    }
}

