/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.dbstore.CMDbAsyncLOBReadRunnable;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMTempFileCache;
import com.cognos.cm.util.CMTempFileCacheKey;
import com.cognos.cm.util.CMThreadPool;
import com.cognos.cm.util.CMThreadPoolRunnable;
import com.cognos.cmutils.config.ConfigurationException;
import com.cognos.cmutils.tempcache.CMTempDataReaderWriter;
import com.cognos.cmutils.tempcache.CMTempFile;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import com.cognos.cmutils.tempcache.CMTempFileLRUCacheBase;
import com.cognos.cmutils.values.CMInt;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CMTempFileLRUCache
extends CMTempFileLRUCacheBase
implements CMTempFileCache {
    public static final String TEMP_FILE_THREAD_POOL_WRITER = "threadPoolWriter";
    public static final String ASYNC_DATA_READ_THREAD_NAME = "CMAsyncDataRead";
    public static final int OBJECT_ID_INIT_MAP_SIZE = 100;
    public static final int OBJECT_ID_INIT_LIST_SIZE = 10;
    private CMTempFileFactory tempFileFactory;
    private Map<Integer, List<Object>> objectIds;
    private CMThreadPool asyncDataReadThreadPool;
    private Set<String> contentTypes;
    private String contentTypesString;

    public CMTempFileLRUCache(CMTempFileFactory tempFileFactory, int maxSize, int fileLifeTimeMinutes) {
        this(tempFileFactory, new CMInt(maxSize), fileLifeTimeMinutes);
    }

    public CMTempFileLRUCache(CMTempFileFactory tempFileFactory, CMInt maxSize, int fileLifeTimeMinutes) {
        super(tempFileFactory, maxSize, fileLifeTimeMinutes);
        this.tempFileFactory = tempFileFactory;
        this.contentTypes = new HashSet<String>();
        this.contentTypesString = null;
        HashMap objIdsMap = new HashMap(100);
        this.objectIds = Collections.synchronizedMap(objIdsMap);
        this.asyncDataReadThreadPool = AdvancedSettings.ASYNCDATAREAD_ENABLED ? new CMThreadPool(AdvancedSettings.ASYNCDATAREAD_MAXTHREADS, AdvancedSettings.ASYNCDATAREAD_MAXIDLETHREADS) : null;
    }

    @Override
    public CMTempFile add(Object key, CMTempDataReaderWriter dataReaderWriter, CMProperty property, String contentType, boolean bLockAndReturn) throws CMException {
        CMTempFile ret = null;
        boolean bAsyncDataRead = this.isAsyncDataReadNeeded(contentType);
        if (bAsyncDataRead) {
            bLockAndReturn = false;
            bAsyncDataRead = this.doAddWithAsyncDataRead(key, property);
        }
        try {
            if (!bAsyncDataRead) {
                ret = super.add(key, dataReaderWriter, contentType, bLockAndReturn);
            }
        }
        catch (ConfigurationException e) {
            throw new CMException((Exception)((Object)e));
        }
        return ret;
    }

    @Override
    public CMTempFile add(Object key, InputStream dataStream, CMProperty property, String contentType, boolean bLockAndReturn) throws CMException {
        CMTempDataReaderWriter dataReaderWriter = new CMTempDataReaderWriter(dataStream);
        CMTempFile ret = this.add(key, dataReaderWriter, property, contentType, bLockAndReturn);
        return ret;
    }

    @Override
    public CMTempFile add(Object key, Reader reader, CMProperty property, String contentType, boolean bLockAndReturn) throws CMException {
        CMTempDataReaderWriter dataReaderWriter = new CMTempDataReaderWriter(reader);
        CMTempFile ret = this.add(key, dataReaderWriter, property, contentType, bLockAndReturn);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doAddWithAsyncDataRead(Object key, CMProperty property) {
        boolean isSuccess;
        CMTempFile entry = null;
        try {
            CMTempFile file = this.tempFileFactory.createCMTempFile(AdvancedSettings.ASYNCDATAREAD_BUFFERSIZE);
            CMTempFileLRUCache cMTempFileLRUCache = this;
            synchronized (cMTempFileLRUCache) {
                entry = this.addEntry(key, file, true);
                file.setMetadata("tempFileDataSize", (Object)-1L);
                isSuccess = this.startAsyncDataRead(entry, property);
                if (!isSuccess) {
                    this.remove(key);
                }
            }
        }
        catch (FileNotFoundException ex) {
            isSuccess = false;
        }
        catch (IOException e) {
            isSuccess = false;
        }
        finally {
            if (entry != null) {
                entry.release();
            }
        }
        return isSuccess;
    }

    protected synchronized void releaseTempFile(CMTempFile entry) {
        int objectId;
        List<Object> cacheKeys;
        this.stopWriting(entry);
        Object key = entry.getMetadata("tempFileCacheKey");
        if (key instanceof CMTempFileCacheKey && (cacheKeys = this.objectIds.get(objectId = ((CMTempFileCacheKey)key).objectId_)) != null) {
            cacheKeys.remove(key);
            if (cacheKeys.isEmpty()) {
                this.objectIds.remove(objectId);
            }
        }
        super.releaseTempFile(entry);
    }

    private synchronized void stopWriting(CMTempFile entry) {
        if (entry.hasMetadata(TEMP_FILE_THREAD_POOL_WRITER)) {
            CMThreadPoolRunnable runnable = (CMThreadPoolRunnable)entry.getMetadata(TEMP_FILE_THREAD_POOL_WRITER);
            this.asyncDataReadThreadPool.stop(runnable);
        }
    }

    private synchronized boolean isAsyncDataReadNeeded(String contentType) {
        boolean isAsyncDataReadNeeded = contentType != null;
        isAsyncDataReadNeeded = isAsyncDataReadNeeded && !this.tempFileFactory.isEncryptionActive();
        boolean bl = isAsyncDataReadNeeded = isAsyncDataReadNeeded && this.asyncDataReadThreadPool != null;
        if (isAsyncDataReadNeeded) {
            this.updateContentTypes();
            isAsyncDataReadNeeded = this.contentTypes.contains(contentType.toLowerCase());
        }
        return isAsyncDataReadNeeded;
    }

    private synchronized void updateContentTypes() {
        boolean shouldUpdate = AdvancedSettings.ASYNCDATAREAD_CONTENTTYPES != null;
        boolean bl = shouldUpdate = shouldUpdate && !AdvancedSettings.ASYNCDATAREAD_CONTENTTYPES.equals(this.contentTypesString);
        if (AdvancedSettings.ASYNCDATAREAD_CONTENTTYPES == null) {
            this.contentTypes.clear();
            this.contentTypesString = null;
        } else if (!AdvancedSettings.ASYNCDATAREAD_CONTENTTYPES.equals(this.contentTypesString)) {
            this.contentTypesString = new String(AdvancedSettings.ASYNCDATAREAD_CONTENTTYPES);
            String[] contentTypes = this.contentTypesString.toLowerCase().split(",");
            this.contentTypes.clear();
            this.contentTypes.addAll(Arrays.asList(contentTypes));
        }
    }

    private boolean startAsyncDataRead(CMTempFile entry, CMProperty property) {
        boolean hasAysncStarted;
        Object entryKey = entry.getMetadata("tempFileCacheKey");
        if (!(entryKey instanceof CMTempFileCacheKey)) {
            throw new IllegalStateException("Only CMTempFileCacheKey is supported as a temporary file key");
        }
        int objectId = ((CMTempFileCacheKey)entryKey).objectId_;
        try {
            CMDbAsyncLOBReadRunnable writer = new CMDbAsyncLOBReadRunnable(this, objectId, property);
            entry.setMetadata(TEMP_FILE_THREAD_POOL_WRITER, (Object)writer);
            String threadName = ASYNC_DATA_READ_THREAD_NAME;
            threadName = threadName + entryKey.toString();
            this.asyncDataReadThreadPool.execute(writer, threadName);
            hasAysncStarted = true;
        }
        catch (Exception ex) {
            CMIndications.logException(ex);
            hasAysncStarted = false;
        }
        return hasAysncStarted;
    }

    protected synchronized CMTempFile addEntry(Object key, CMTempFile file, boolean bLockEntry) {
        CMTempFile entry = super.addEntry(key, file, bLockEntry);
        if (key instanceof CMTempFileCacheKey) {
            int objectID = ((CMTempFileCacheKey)key).objectId_;
            List<Object> cacheKeys = this.objectIds.get(objectID);
            if (cacheKeys == null) {
                cacheKeys = new ArrayList<Object>(10);
                this.objectIds.put(objectID, cacheKeys);
            }
            cacheKeys.add(key);
        }
        return entry;
    }

    @Override
    public void removeCachedFilesForObjectId(int objectId) {
        List<Object> cacheKeys = this.objectIds.get(objectId);
        if (cacheKeys != null) {
            Object[] keys = cacheKeys.toArray();
            for (int i = 0; i < keys.length; ++i) {
                this.remove(keys[i]);
            }
        }
    }

    @Override
    public Object getNewTempFileCacheKey(int objectId, CMProperty property) {
        return new CMTempFileCacheKey(objectId, property);
    }

    protected void finalize() throws Throwable {
        for (CMTempFile iter : this.getEntries().values()) {
            this.stopWriting(iter);
        }
        super.finalize();
    }

    protected boolean hasEntry(Object key) {
        return super.hasEntry(key);
    }
}

