/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.util.CMInputStreamWithSize;
import com.cognos.cmutils.setting.AdvancedSettingsFetcher;
import com.cognos.cmutils.setting.Fetcher;
import com.cognos.cmutils.setting.SettingInteger;
import com.cognos.cmutils.tempcache.CMTempFileFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CMTempOutputStream
extends OutputStream {
    SettingInteger dataFileMin = new SettingInteger(Integer.valueOf(524288), new Fetcher[]{new AdvancedSettingsFetcher("DATAFILEMIN")});
    private long size_ = 0L;
    private boolean closed_;
    private ByteArrayOutputStream baos_ = new ByteArrayOutputStream(32768);
    private OutputStream os_ = null;
    private File fileName_ = null;

    @Override
    public void write(int b) throws IOException {
        if (this.closed_) {
            throw new IllegalStateException("CMTempOutputStream.write: file is closed");
        }
        if (this.os_ == null && this.size_ + 1L > (long)this.dataFileMin.getValue().intValue()) {
            this.spoolToFile();
        }
        if (this.os_ != null) {
            this.os_.write(b);
        } else {
            this.baos_.write(b);
        }
        ++this.size_;
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    private void spoolToFile() throws IOException {
        CMTempFileFactory tempFileFactory = CMTempFileFactory.getInstance();
        if (this.fileName_ == null) {
            this.fileName_ = tempFileFactory.createTempFile();
        }
        this.os_ = tempFileFactory.getOutputStream(this.fileName_);
        if (this.baos_.size() > 0) {
            this.baos_.writeTo(this.os_);
        }
        this.baos_ = null;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.closed_) {
            throw new IllegalStateException("CMTempOutputStream.write: file is closed");
        }
        if (this.os_ == null && this.size_ + (long)length > (long)this.dataFileMin.getValue().intValue()) {
            this.spoolToFile();
        }
        if (this.os_ != null) {
            this.os_.write(buffer, offset, length);
        } else {
            this.baos_.write(buffer, offset, length);
        }
        this.size_ += (long)length;
    }

    @Override
    public void flush() throws IOException {
        if (this.closed_) {
            return;
        }
        if (this.os_ == null) {
            this.spoolToFile();
        }
        if (this.os_ != null) {
            this.os_.flush();
        }
    }

    public void ensureFileNameExists() throws IOException {
        if (this.fileName_ == null) {
            CMTempFileFactory tempFileFactory = CMTempFileFactory.getInstance();
            this.fileName_ = tempFileFactory.createTempFile();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.os_ != null) {
                this.os_.close();
            }
        }
        finally {
            this.closed_ = true;
        }
    }

    public CMInputStreamWithSize getInputStream() throws IOException {
        InputStream is;
        if (!this.closed_) {
            throw new IllegalStateException("CMTempOutputStream.getInputStream: file is not closed for write");
        }
        if (this.fileName_ != null) {
            CMTempFileFactory tempFileFactory = CMTempFileFactory.getInstance();
            is = tempFileFactory.getInputStream(this.fileName_);
        } else {
            is = new ByteArrayInputStream(this.baos_.toByteArray());
        }
        return new CMInputStreamWithSize(is, this.size_);
    }

    public File getFile() {
        return this.fileName_;
    }

    public void delete() throws IOException {
        try {
            if (this.os_ != null) {
                this.close();
            }
        }
        finally {
            if (this.fileName_ != null) {
                this.fileName_.delete();
            }
        }
    }

    public long getSize() {
        return this.size_;
    }

    public boolean isFile() {
        return this.os_ != null;
    }

    public boolean moveTempFile(File file) {
        boolean hasMoved;
        boolean bl = hasMoved = this.fileName_ != null && this.fileName_.renameTo(file);
        if (hasMoved) {
            this.fileName_ = file;
        }
        return hasMoved;
    }
}

