/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.util.CMThreadPoolRunnable;
import com.cognos.cm.util.ThreadPoolInternalRunnable;
import com.cognos.cm.util.ThreadPoolWorker;
import java.util.LinkedList;

public class CMThreadPool {
    private LinkedList<ThreadPoolWorker> idleWorkers_ = new LinkedList();
    private ThreadPoolWorker[] workerList_;
    private int maxPoolSize_;
    private int maxIdlePoolSize_;
    private int workerThreadCount_ = 0;

    public CMThreadPool(int maxPoolSize, int maxIdlePoolSize) {
        this.maxPoolSize_ = Math.max(1, maxPoolSize);
        this.maxIdlePoolSize_ = Math.max(1, maxIdlePoolSize);
        this.workerList_ = new ThreadPoolWorker[this.maxPoolSize_];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(CMThreadPoolRunnable target, String threadName) throws InterruptedException {
        Thread worker = null;
        LinkedList<ThreadPoolWorker> linkedList = this.idleWorkers_;
        synchronized (linkedList) {
            ThreadPoolWorker[] threadPoolWorkerArray = this.workerList_;
            synchronized (this.workerList_) {
                if (this.idleWorkers_.size() == 0 && this.workerThreadCount_ < this.maxPoolSize_) {
                    worker = new ThreadPoolWorker(this.workerThreadCount_, new ThreadPoolInternalRunnable(), this);
                    this.workerList_[this.workerThreadCount_] = worker;
                    ++this.workerThreadCount_;
                    worker.setName(threadName);
                    worker.start();
                    ((ThreadPoolWorker)worker).process(target);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        {
            while (worker == null) {
                linkedList = this.idleWorkers_;
                synchronized (linkedList) {
                    if (this.idleWorkers_.size() > 0) {
                        worker = this.idleWorkers_.remove(0);
                    }
                }
                if (worker != null) continue;
                linkedList = this.idleWorkers_;
                synchronized (linkedList) {
                    this.idleWorkers_.wait();
                }
            }
            worker.setName(threadName);
            ((ThreadPoolWorker)worker).process(target);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(CMThreadPoolRunnable target) {
        ThreadPoolWorker[] threadPoolWorkerArray = this.workerList_;
        synchronized (this.workerList_) {
            for (int j = 0; j < this.maxPoolSize_; ++j) {
                ThreadPoolWorker worker = this.workerList_[j];
                if (worker == null) continue;
                Object workerKey = null;
                Object targetKey = target.getKey();
                CMThreadPoolRunnable r = null;
                LinkedList<CMThreadPoolRunnable> linkedList = worker.handoffBox_;
                synchronized (linkedList) {
                    if (worker.handoffBox_.size() > 0) {
                        r = worker.handoffBox_.get(0);
                    }
                }
                if (r != null) {
                    workerKey = r.getKey();
                }
                if (workerKey == null || workerKey != targetKey) continue;
                worker.stopRequest();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void release(ThreadPoolWorker worker) {
        boolean bDeleteThread = false;
        ThreadPoolWorker[] threadPoolWorkerArray = this.idleWorkers_;
        synchronized (this.idleWorkers_) {
            if (this.idleWorkers_.size() >= this.maxIdlePoolSize_) {
                bDeleteThread = true;
            } else {
                this.idleWorkers_.add(worker);
                this.idleWorkers_.notifyAll();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!bDeleteThread) return;
            threadPoolWorkerArray = this.workerList_;
            synchronized (this.workerList_) {
                ThreadPoolWorker workerFromList;
                int threadId = worker.threadId_;
                if (threadId >= this.maxPoolSize_) return;
                if (threadId < this.workerThreadCount_ - 1 && (workerFromList = this.workerList_[this.workerThreadCount_ - 1]) != null) {
                    workerFromList.threadId_ = threadId;
                    this.workerList_[threadId] = workerFromList;
                }
                this.workerList_[this.workerThreadCount_ - 1] = null;
                --this.workerThreadCount_;
                return;
            }
        }
    }

    public void shutdown() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        try {
            LinkedList<ThreadPoolWorker> linkedList = this.idleWorkers_;
            synchronized (linkedList) {
                for (int i = 0; i < this.idleWorkers_.size(); ++i) {
                    try {
                        ThreadPoolWorker worker = this.idleWorkers_.get(i);
                        worker.stopRequest();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            for (int j = 0; j < this.maxPoolSize_; ++j) {
                --this.workerThreadCount_;
                try {
                    ThreadPoolWorker worker = this.workerList_[j];
                    if (worker == null) continue;
                    worker.stopRequest();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.idleWorkers_.clear();
            this.workerList_ = null;
            this.maxPoolSize_ = 0;
            this.workerThreadCount_ = 0;
        }
    }
}

