/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.trustedServices.trustedService;

public class CMTrustedServiceUtil {
    private static String QUERY_REQUEST = "query";
    private static String WRITE_ACCESS = "write";
    private static String READ_ACCESS = "read";
    private static String READWRITE_ACCESS = "readwrite";

    public static void validateTrustAccess(CMObjectClass classObj, String requestName, CMProperty property) throws CMException {
        trustedService ts;
        String grantedPermission;
        boolean permissionsGranted = false;
        String serviceID = CMExecutionContext.get().getServiceId();
        String propertyName = property.getName();
        String requiredPermission = property.getTrustAccessLevel();
        String request = requestName.substring(requestName.lastIndexOf(".") + 1);
        if (request.equalsIgnoreCase(QUERY_REQUEST) && requiredPermission.equalsIgnoreCase(WRITE_ACCESS)) {
            return;
        }
        if (serviceID != null && (grantedPermission = (ts = CMExecutionContext.get().getTrustedService()).getClassPropertyPermission(classObj, propertyName)) != null && (requiredPermission.equalsIgnoreCase(grantedPermission) || (requiredPermission.equalsIgnoreCase(WRITE_ACCESS) || requiredPermission.equalsIgnoreCase(READ_ACCESS)) && grantedPermission.equalsIgnoreCase(READWRITE_ACCESS))) {
            permissionsGranted = true;
        }
        if (!permissionsGranted) {
            throw new CMException("cmTrustedRequestNotTrusted", new CMException.Parm("property", propertyName), new CMException.Parm("accessType", request));
        }
    }
}

