/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.constants.CMError;
import com.cognos.cm.plugin.Interface.CMPluginDescriptor;
import com.cognos.cm.util.CMStringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class CMUpgradeLogXMLGenerator {
    public static final String TYPE_CMINTERNAL = "dataError";
    public static final String TYPE_PLUGIN = "plugin";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String XML_PI = "<?xml:stylesheet type=\"text/xsl\" href=\"../webcontent/cmUpgradeLog.xsl\"?>";
    private static final String ELEM_ROOT = "cognosUpgrade";
    private static final String ELEM_OBJ_CLS = "objectClass";
    private static final String ELEM_PROP = "property";
    private static final String ELEM_SEARCHPATH = "searchPath";
    private static final String ELEM_MESSAGE = "message";
    private static final String ELEM_PLUGIN_ID = "pluginID";
    private static final String ELEM_OBJ_CLSES = "objectClasses";
    private static final String ELEM_PROPS = "properties";
    private static final String ELEM_PLUGIN = "plugin";
    private static final String ELEM_ERROR = "error";
    private static final String ELEM_SUMMARY = "summary";
    private static final String ELEM_START_TIME = "startTime";
    private static final String ELEM_END_TIME = "endTime";
    private static final String ELEM_DBUPGRADE = "dbUpgrade";
    private static final String ELEM_HEADING = "heading";
    private static final String ELEM_HEAD_RESULT = "upgradeResults";
    private static final String ELEM_HEAD_OBJ_CLS = "objectClass";
    private static final String ELEM_HEAD_TOTAL = "total";
    private static final String ELEM_HEAD_SUCCESS = "success";
    private static final String ELEM_HEAD_FAILURE = "failure";
    private static final String ELEM_HEAD_UPTODATE = "upToDate";
    private static final String ELEM_HEAD_ERRORS = "errors";
    private static final String ELEM_HEAD_ERROR = "error";
    private static final String ELEM_HEAD_SEARCHPATH = "searchPath";
    private static final String ELEM_HEAD_INVALIDREFS = "invalidRefs";
    private static final String ELEM_HEAD_MESSAGE = "message";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_SEVERITY = "severity";
    private static final String ATTR_ID = "id";
    private static final String ATTR_TOTAL = "total";
    private static final String ATTR_UPTODATE = "upToDate";
    private static final String ATTR_SUCCESS = "success";
    private static final String ATTR_FAILURE = "failure";
    private static List<Element> firstLevelElements_ = null;
    private static final String sEnd = "</cognosUpgrade>";

    public static void addErrorElement(String errorType, String objectClass, String property, String searchPath, String message, String pluginID) {
        CMUpgradeLogXMLGenerator.addElementWithSeverity(errorType, objectClass, property, searchPath, message, pluginID, -1);
    }

    public static void addElementWithSeverity(String errorType, String objectClass, String property, String searchPath, String message, String pluginID, int severity) {
        if (errorType == null) {
            throw new IllegalArgumentException("errorType for upgrade log error element is required");
        }
        Element objCls = CMUpgradeLogXMLGenerator.createElement("objectClass", objectClass);
        Element prop = CMUpgradeLogXMLGenerator.createElement(ELEM_PROP, property);
        Element path = CMUpgradeLogXMLGenerator.createElement("searchPath", searchPath);
        Element msg = CMUpgradeLogXMLGenerator.createElement("message", message);
        Element pluginIDElem = CMUpgradeLogXMLGenerator.createElement(ELEM_PLUGIN_ID, pluginID);
        Element parentElem = CMUpgradeLogXMLGenerator.createElement("error");
        parentElem.addAttribute(ATTR_TYPE, errorType);
        parentElem.add(path);
        if (severity != -1) {
            parentElem.addAttribute(ATTR_SEVERITY, Integer.toString(severity));
        }
        if (objCls != null) {
            parentElem.add(objCls);
        }
        if (prop != null) {
            parentElem.add(prop);
        }
        if (pluginID != null) {
            parentElem.add(pluginIDElem);
        }
        if (msg != null) {
            parentElem.add(msg);
        }
        CMUpgradeLogXMLGenerator.addToFirstLevel(parentElem);
    }

    public static void addPluginElement(CMPluginDescriptor desc, int total, int upToDate, int upgraded, int error, String cmMsg, String startTime, String endTime) {
        Element objClss = CMUpgradeLogXMLGenerator.createElement(ELEM_OBJ_CLSES);
        List objectClasses = desc.getClassNamesForDeployment();
        ListIterator clssIter = objectClasses.listIterator();
        while (clssIter.hasNext()) {
            String sClsName = (String)clssIter.next();
            Element objCls = CMUpgradeLogXMLGenerator.createElement("objectClass", sClsName);
            objClss.add(objCls);
        }
        Element propsElem = CMUpgradeLogXMLGenerator.createElement(ELEM_PROPS);
        List props = desc.getProperties();
        ListIterator propsIter = props.listIterator();
        while (propsIter.hasNext()) {
            String sProp = (String)propsIter.next();
            Element propElem = CMUpgradeLogXMLGenerator.createElement(ELEM_PROP, sProp);
            propsElem.add(propElem);
        }
        Element summary = CMUpgradeLogXMLGenerator.createSummaryForPlugin(total, upToDate, upgraded, error, cmMsg);
        Element start = CMUpgradeLogXMLGenerator.createElement(ELEM_START_TIME, startTime);
        Element end = CMUpgradeLogXMLGenerator.createElement(ELEM_END_TIME, endTime);
        Element plugin = CMUpgradeLogXMLGenerator.createElement("plugin");
        plugin.addAttribute(ATTR_ID, desc.getPluginID());
        if (start != null) {
            plugin.add(start);
        }
        if (end != null) {
            plugin.add(end);
        }
        plugin.add(objClss);
        plugin.add(propsElem);
        plugin.add(summary);
        CMUpgradeLogXMLGenerator.addToFirstLevel(plugin);
    }

    public static void addDBUpgradeElement(String startTime, String endTime) {
        Element dbUpgrade = CMUpgradeLogXMLGenerator.createElement(ELEM_DBUPGRADE);
        Element start = CMUpgradeLogXMLGenerator.createElement(ELEM_START_TIME, startTime);
        Element end = CMUpgradeLogXMLGenerator.createElement(ELEM_END_TIME, endTime);
        dbUpgrade.add(start);
        dbUpgrade.add(end);
        CMUpgradeLogXMLGenerator.addToFirstLevel(dbUpgrade);
    }

    private static Element createSummaryForPlugin(int total, int upToDate, int upgraded, int error, String cmMsg) {
        Element element = CMUpgradeLogXMLGenerator.createElement(ELEM_SUMMARY);
        element.addAttribute("total", Integer.toString(total));
        element.addAttribute("upToDate", Integer.toString(upToDate));
        element.addAttribute("success", Integer.toString(upgraded));
        element.addAttribute("failure", Integer.toString(error));
        element.addCDATA(cmMsg);
        return element;
    }

    private static void addToFirstLevel(Element elem) {
        if (firstLevelElements_ == null) {
            firstLevelElements_ = new ArrayList<Element>();
        }
        firstLevelElements_.add(elem);
    }

    private static void dumpLogWithHeading(FileOutputStream out) throws IOException {
        out.write(CMStringUtils.getUTF8BytesFromString(XML_HEADER));
        out.write(CMStringUtils.getUTF8BytesFromString(XML_PI));
        out.write(CMStringUtils.getUTF8BytesFromString("\r\n"));
        out.flush();
        OutputFormat format = new OutputFormat();
        format.setNewlines(true);
        XMLWriter writer = new XMLWriter((OutputStream)out, format);
        Element root = CMUpgradeLogXMLGenerator.getDocRoot();
        if (root != null) {
            writer.write(root);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpLogAsXML(File file, boolean bKeepLog) throws FileNotFoundException, IOException {
        if (firstLevelElements_.size() == 0) {
            return;
        }
        FileOutputStream outStream = null;
        try {
            if (file.exists() && bKeepLog) {
                CMUpgradeLogXMLGenerator.truncateEndTag(file);
                OutputFormat format = new OutputFormat();
                format.setNewlines(true);
                outStream = new FileOutputStream(file, bKeepLog);
                XMLWriter writer = new XMLWriter((OutputStream)outStream, format);
                for (int i = 0; i < firstLevelElements_.size(); ++i) {
                    Element elem = firstLevelElements_.get(i);
                    writer.write(elem);
                }
                outStream.write(CMStringUtils.getUTF8BytesFromString(sEnd));
            } else {
                outStream = new FileOutputStream(file, bKeepLog);
                CMUpgradeLogXMLGenerator.dumpLogWithHeading(outStream);
            }
        }
        finally {
            CMUpgradeLogXMLGenerator.reset();
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    public static boolean hasLogs() {
        return firstLevelElements_ != null;
    }

    private static Element createElement(String name) {
        if (name == null) {
            return null;
        }
        return DocumentHelper.createElement((String)name);
    }

    private static Element createElement(String name, String value) {
        if (value == null || name == null) {
            return null;
        }
        Element elem = DocumentHelper.createElement((String)name);
        elem.addText(value);
        return elem;
    }

    private static Element getDocRoot() {
        if (firstLevelElements_.size() == 0) {
            return null;
        }
        Element root = CMUpgradeLogXMLGenerator.createElement(ELEM_ROOT);
        root.add(CMUpgradeLogXMLGenerator.getHeadingElement());
        for (int i = 0; i < firstLevelElements_.size(); ++i) {
            Element elem = firstLevelElements_.get(i);
            if (elem == null) continue;
            root.add(elem);
        }
        return root;
    }

    private static void reset() {
        firstLevelElements_ = null;
    }

    private static Element getHeadingElement() {
        Element headingElem = CMUpgradeLogXMLGenerator.createElement(ELEM_HEADING);
        Element heading = CMUpgradeLogXMLGenerator.createElement(ELEM_HEAD_RESULT, CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogUpgradeResults", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("objectClass", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogObjectClass", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("total", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogTotal", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("success", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogSuccess", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("failure", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogFailure", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("upToDate", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogNoChangeRequired", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement(ELEM_HEAD_ERRORS, CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogErrors", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("error", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogError", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("searchPath", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogSearchPath", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement(ELEM_HEAD_INVALIDREFS, CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogInvalidRefs", null, null)));
        headingElem.add(heading);
        heading = CMUpgradeLogXMLGenerator.createElement("message", CMError.trimErrorCode(CMError.getMessage("cmUpgradeLogMessage", null, null)));
        headingElem.add(heading);
        return headingElem;
    }

    private static void truncateEndTag(File file) throws FileNotFoundException, IOException {
        RandomAccessFile randomFile = null;
        randomFile = new RandomAccessFile(file, "rw");
        int extraBytes = 8;
        long initialOffset = randomFile.length() - (long)sEnd.length() - (long)extraBytes;
        if (initialOffset < 0L) {
            return;
        }
        randomFile.seek(initialOffset);
        int bufSize = sEnd.length() + extraBytes;
        byte[] endTags = sEnd.getBytes();
        byte[] buf = new byte[bufSize];
        randomFile.read(buf);
        int skip = 0;
        for (int k = 0; k < bufSize - 4; ++k) {
            if (buf[k] != endTags[0] || buf[k + 1] != endTags[1] || buf[k + 2] != endTags[2] || buf[k + 3] != endTags[3] || buf[k + 4] != endTags[4]) continue;
            skip = k;
            break;
        }
        if (skip > 0) {
            randomFile.setLength(initialOffset + (long)skip);
        }
        randomFile.close();
    }
}

