/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.util.CMStringUtils;
import com.cognos.cm.util.DocumentBuilderPool;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CMXMLUtils
extends XMLUtils {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_END_ENCODED = "]]&gt;";
    private static SAXParserFactory saxParserFactory_ = CMXMLUtils.createSAXParserFactory();
    private static DocumentBuilderPool documentBuilderPool = new DocumentBuilderPool(AdvancedSettings.DOCUMENT_BUILDER_POOL_SIZE);
    private static LinkedList<XMLReader> g_XMLReaderPool_ = new LinkedList();
    private static int g_nXMLReaderPool_MaxSize_ = 75;

    public static final boolean parseBooleanAttribute(String strValue) throws CMException {
        if (strValue != null) {
            if (strValue.equals("1") || strValue.equalsIgnoreCase("true") || strValue.equalsIgnoreCase("t") || strValue.equalsIgnoreCase("yes") || strValue.equalsIgnoreCase("y")) {
                return true;
            }
            if (strValue.equals("0") || strValue.equalsIgnoreCase("false") || strValue.equalsIgnoreCase("f") || strValue.equalsIgnoreCase("no") || strValue.equalsIgnoreCase("n")) {
                return false;
            }
        }
        throw new CMException("cmBadBoolean", new CMException.Parm("Value", strValue));
    }

    public static final boolean isBooleanAttrTrue(String strValue) {
        if (strValue == null) {
            return false;
        }
        try {
            return CMXMLUtils.parseBooleanAttribute(strValue);
        }
        catch (CMException ex) {
            return false;
        }
    }

    public static final boolean isBooleanAttrFalse(String strValue) {
        if (strValue == null) {
            return false;
        }
        try {
            return !CMXMLUtils.parseBooleanAttribute(strValue);
        }
        catch (CMException ex) {
            return false;
        }
    }

    public static final String getBooleanXMLValue(boolean bool) {
        if (bool) {
            return "true";
        }
        return "false";
    }

    @Deprecated
    public static final String tokenize(String strToTokenize) {
        return CMStringUtils.collapseWhitespace(strToTokenize);
    }

    public static Document parseString(String src) throws SAXException, IOException {
        return CMXMLUtils.parse(new InputSource(new StringReader(src)));
    }

    public static Document parse(InputSource src) throws SAXException, IOException {
        DocumentBuilder domBuilder = documentBuilderPool.getDocumentBuilder();
        try {
            Document document = domBuilder.parse(src);
            return document;
        }
        finally {
            documentBuilderPool.returnDocumentBuilder(domBuilder);
        }
    }

    public static synchronized XMLReader getSAXParserFromPool() throws SAXException {
        XMLReader ret = null;
        ret = g_XMLReaderPool_.size() == 0 ? CMXMLUtils._getSAXParser() : g_XMLReaderPool_.removeFirst();
        return ret;
    }

    public static synchronized void returnSAXParserToPool(XMLReader rdr) {
        if (g_XMLReaderPool_.size() < g_nXMLReaderPool_MaxSize_) {
            g_XMLReaderPool_.addFirst(rdr);
        }
    }

    private static void setOptionalSAXFactoryFeature(SAXParserFactory factory, String feature, boolean value) {
        try {
            factory.setFeature(feature, value);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
    }

    private static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            factory.setFeature("http://xml.org/sax/features/namespaces", true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        CMXMLUtils.setOptionalSAXFactoryFeature(factory, "http://apache.org/xml/features/continue-after-fatal-error", false);
        CMXMLUtils.setOptionalSAXFactoryFeature(factory, "http://apache.org/xml/features/disallow-doctype-decl", true);
        return factory;
    }

    private static XMLReader _getSAXParser() throws SAXException {
        try {
            SAXParser sp = saxParserFactory_.newSAXParser();
            return sp.getXMLReader();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public static String removeContainerElements(String strXML, int count) {
        if (strXML == null || count < 0) {
            return strXML;
        }
        int nfirst = strXML.indexOf(60);
        if (nfirst != -1) {
            if (strXML.startsWith("?xml", nfirst + 1)) {
                nfirst = strXML.indexOf(62, nfirst + 5);
            } else if (count == 0) {
                --nfirst;
            }
        }
        int nlast = strXML.length();
        while (count != 0) {
            nfirst = strXML.indexOf(62, nfirst + 1);
            nlast = strXML.lastIndexOf(60, nlast - 1);
            if (nfirst == -1 || nlast == -1 || nlast < nfirst) {
                return strXML;
            }
            --count;
        }
        strXML = strXML.substring(nfirst + 1, nlast);
        return strXML;
    }

    public static String removeXMLTag(String strXML) {
        int pos;
        if (strXML != null && strXML.startsWith("<?xml") && (pos = strXML.indexOf("?>")) > 0) {
            int pos2 = strXML.indexOf("<", pos);
            if (pos2 < pos) {
                pos2 = pos + 3;
            }
            strXML = strXML.substring(pos2);
        }
        return strXML;
    }

    public static String getCharacterContent(Element elem) {
        if (elem == null) {
            return null;
        }
        if (!elem.hasChildNodes()) {
            return null;
        }
        Node child = elem.getFirstChild();
        if (child.getNextSibling() != null || child.getNodeType() != 3) {
            return null;
        }
        return child.getNodeValue();
    }

    public static Element getElementByTagName(Element el, String sTagName) throws CMException {
        NodeList nodes = el.getElementsByTagName(sTagName);
        if (nodes == null || nodes.getLength() <= 0) {
            throw new CMException();
        }
        el = (Element)nodes.item(0);
        return el;
    }

    public static Element getOptionalElementByTagName(Element el, String sTagName) {
        NodeList nodes = el.getElementsByTagName(sTagName);
        if (nodes == null || nodes.getLength() <= 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static List<String> getCharacterContentListByTagName(Element el, String sTagName) {
        if (el == null || sTagName == null) {
            return null;
        }
        NodeList nodes = el.getElementsByTagName(sTagName);
        if (nodes == null || nodes.getLength() <= 0) {
            return null;
        }
        ArrayList<String> elList = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String content;
            Node node = nodes.item(i);
            if (node == null || node.getNodeType() != 1 || (content = CMXMLUtils.getCharacterContent((Element)node)) == null) continue;
            if (elList == null) {
                elList = new ArrayList<String>();
            }
            elList.add(content);
        }
        return elList;
    }

    public static String wrapInCDATASection(String sValue) {
        if (sValue == null || sValue.length() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int start = 0;
        int end = 0;
        while ((end = sValue.indexOf(CDATA_END, start)) != -1) {
            if (end != start) {
                buf.append(CDATA_START);
                buf.append(sValue.substring(start, end));
                buf.append(CDATA_END);
            }
            buf.append(CDATA_END_ENCODED);
            start = end + CDATA_END.length();
        }
        buf.append(CDATA_START);
        buf.append(sValue.substring(start, sValue.length()));
        buf.append(CDATA_END);
        return buf.toString();
    }

    public static XMLElement convertXMLString2XMLElement(String sXML) throws CMException {
        XMLElement rootEl = null;
        StringBuffer xmlDocStrBuf = new StringBuffer();
        xmlDocStrBuf.append("<root ").append(XMLElement.getCMPrefixes()).append(">").append(sXML).append("</root>");
        String xmlDocStr = xmlDocStrBuf.toString();
        XMLDocParser parser = new XMLDocParser();
        XMLDoc xmlDoc = null;
        try {
            xmlDoc = parser.readXML(xmlDocStr);
        }
        catch (Exception ex) {
            throw new CMException(ex, "cmFailedToParseXMLString", new CMException.Parm("String", sXML));
        }
        if (xmlDoc != null && xmlDoc.baseElement_ != null) {
            rootEl = xmlDoc.getRootXMLElement();
        }
        return rootEl;
    }

    public static ArrayList<String> convertXMLElementArray2StringArray(String sXML) throws CMException {
        ArrayList<XMLElement> children;
        XMLElement valueXml;
        ArrayList<String> sList = null;
        XMLElement root = CMXMLUtils.convertXMLString2XMLElement(sXML);
        if (root != null && (valueXml = root.getOptionalChildWithName("value")) != null && (children = valueXml.getChildren()) != null) {
            sList = new ArrayList<String>();
            ListIterator iter = children.listIterator();
            while (iter.hasNext()) {
                String sValue;
                XMLElement xmlEl = (XMLElement)iter.next();
                if (xmlEl == null || xmlEl.value_ == null || (sValue = xmlEl.value_).length() <= 0) continue;
                sList.add(sValue);
            }
        }
        return sList;
    }

    public static String getCharacterContentProper(Element elem) {
        if (elem == null) {
            return null;
        }
        if (CMXMLUtils.isNilValue(elem)) {
            return null;
        }
        return CMXMLUtils.getCharacterContent(elem);
    }

    public static boolean isNilValue(Element elem) {
        if (elem == null) {
            return false;
        }
        String value = elem.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "nil");
        return value != null && ("1".equals(value) || "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value));
    }
}

