/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.TrustedRequestSession;
import com.cognos.cm.util.TrustedSession;
import java.util.BitSet;

public class ConnectionPool {
    private static final ConnectionPool instance = new ConnectionPool();
    private CAMFactory camFactory = null;
    private boolean poolDisposed = false;
    private int maximumPoolSize = 100;
    private boolean nonBlocking = false;
    private BitSet allocatedConnections = new BitSet(this.maximumPoolSize);
    private TrustedSession[] clientConnections = new TrustedSession[this.maximumPoolSize];
    private boolean disposeUponFailure = false;

    private ConnectionPool() {
    }

    public static synchronized ConnectionPool getInstance() {
        return instance;
    }

    public void initialize() throws CAMCryptoException {
        this.camFactory = new CAMFactory();
        this.camFactory.initialize("<initializeDocument><serviceID>CM</serviceID></initializeDocument>".getBytes());
        this.clientConnections[0] = new TrustedSession(this.camFactory.createTrustedSession(), 0);
        this.clientConnections[1] = new TrustedSession(this.camFactory.createTrustedSession(), 1);
        this.clientConnections[2] = new TrustedSession(this.camFactory.createTrustedSession(), 2);
        this.clientConnections[3] = new TrustedSession(this.camFactory.createTrustedSession(), 3);
        this.clientConnections[4] = new TrustedSession(this.camFactory.createTrustedSession(), 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustedSession getSession() throws IllegalStateException {
        int nextAvailablePosition = -1;
        while (true) {
            if (this.poolDisposed) {
                throw new IllegalStateException("The connection pool has been shutdown");
            }
            nextAvailablePosition = this.testAndSetNextAvailable();
            if (nextAvailablePosition != -1) break;
            try {
                if (this.nonBlocking) {
                    return null;
                }
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        TrustedSession aConnection = this.assignConnection(nextAvailablePosition);
        return aConnection;
    }

    private TrustedSession assignConnection(int position) {
        if (this.clientConnections[position] == null) {
            try {
                TrustedRequestSession trs = this.camFactory.createTrustedSession();
                this.clientConnections[position] = new TrustedSession(trs, position);
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.clientConnections[position];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int testAndSetNextAvailable() {
        int selectedPosition = -1;
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            for (int i = 0; i < this.maximumPoolSize; ++i) {
                if (this.allocatedConnections.get(i)) continue;
                selectedPosition = i;
                this.allocatedConnections.set(selectedPosition);
                break;
            }
        }
        return selectedPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int position) {
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            this.allocatedConnections.clear(position);
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                this.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.poolDisposed) {
            return;
        }
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            this.poolDisposed = true;
            this.camFactory.terminate();
        }
    }

    public void setNonBlocking(boolean b) {
        this.nonBlocking = b;
    }

    public boolean isDisposed() {
        return this.poolDisposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        BitSet bitSet = this.allocatedConnections;
        synchronized (bitSet) {
            for (int i = 0; i < this.maximumPoolSize; ++i) {
                if (!this.allocatedConnections.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    boolean isDisposeUponFailure() {
        return this.disposeUponFailure;
    }

    public void setDisposeUponFailure(boolean b) {
        this.disposeUponFailure = b;
    }
}

