/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.dbstore.CMDbStoreCacheUtil;
import com.cognos.cm.properties.CMAncestors;
import com.cognos.cm.server.CMException;
import com.cognos.cm.store.CMCache;
import com.cognos.cm.store.CMStore;
import com.cognos.pogo.handlers.contentmanager.viewer.ContentDispositionCreator;

public final class ContentDispositionBuilder {
    private static final String GENERIC_AGENT = "Mozilla/5.0";

    private ContentDispositionBuilder() {
    }

    public static String buildContentDisposition(int cmId, CMStore store, String contentType, String size, int parentId) throws CMException {
        String name = ContentDispositionBuilder.getOutputName(store, cmId, parentId);
        return ContentDispositionBuilder.buildContentDisposition(name, contentType, size, GENERIC_AGENT);
    }

    public static String buildContentDisposition(String name, String contentType, String userAgent) {
        return ContentDispositionBuilder.buildContentDisposition(name, contentType, null, userAgent);
    }

    public static String buildContentDisposition(String name, String contentType, String size, String userAgent) {
        ContentDispositionCreator dispositionCreator = new ContentDispositionCreator(contentType, name, ContentDispositionCreator.DispositionType.inline);
        String dispositionValue = dispositionCreator.createContentDisposition(userAgent);
        StringBuilder builder = new StringBuilder();
        builder.append(dispositionValue);
        if (null != size) {
            builder.append("; size=");
            builder.append(size);
        }
        return builder.toString();
    }

    private static String getOutputName(CMStore store, int outputId, int reportVersionId) throws CMException {
        CMCache cache = store.getCache();
        String objectName = cache.CMCacheGetName(outputId, CMDbStoreCacheUtil.getCacheSearchLocales());
        String reportName = ContentDispositionBuilder.getReportName(cache, outputId, reportVersionId);
        return reportName + " " + objectName;
    }

    private static String getReportName(CMCache cache, int outputId, int reportVersionId) throws CMException {
        String reportName = "";
        CMAncestors ancestors = cache.getAncestors(outputId);
        int ancestorCount = ancestors.getSize();
        if (ancestorCount == 0 && reportVersionId != -1) {
            ancestors = cache.getAncestors(reportVersionId);
            reportName = ancestors.getName(ancestors.getSize() - 1);
        } else if (ancestorCount > 2) {
            reportName = ancestors.getName(ancestorCount - 2);
        }
        return reportName;
    }
}

