/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.util.FilteringIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtils {
    public static Iterator<Node> elementIterator(Node node) {
        NodeIterator it = new NodeIterator(node);
        return new FilteringIterator<Node>((Iterator)it){

            @Override
            public boolean matches(Object obj) {
                return ((Node)obj).getNodeType() == 1;
            }
        };
    }

    public static Iterator<Node> elementIterator(Node node, final String name) {
        NodeIterator it = new NodeIterator(node);
        return new FilteringIterator<Node>((Iterator)it){

            @Override
            public boolean matches(Object obj) {
                Node n = (Node)obj;
                return n.getNodeType() == 1 && n.getLocalName().equals(name);
            }
        };
    }

    public static Iterator<Node> elementIterator(Node node, final String name, final String namespace) {
        NodeIterator it = new NodeIterator(node);
        return new FilteringIterator<Node>((Iterator)it){

            @Override
            public boolean matches(Object obj) {
                Node n = (Node)obj;
                if (n.getNodeType() == 1 && n.getLocalName().equals(name)) {
                    String ns = n.getNamespaceURI();
                    if (namespace == null) {
                        return ns == null;
                    }
                    return namespace.equals(ns);
                }
                return false;
            }
        };
    }

    public static Element element(Node node, String name) {
        Iterator<Node> it = DOMUtils.elementIterator(node, name);
        if (it.hasNext()) {
            return (Element)it.next();
        }
        return null;
    }

    public static Element element(Node node, String name, String namespace) {
        Iterator<Node> it = DOMUtils.elementIterator(node, name, namespace);
        if (it.hasNext()) {
            return (Element)it.next();
        }
        return null;
    }

    public static class NodeIterator
    implements Iterator<Node> {
        private Node node_;

        public NodeIterator(Node node) {
            this.node_ = node.getFirstChild();
        }

        @Override
        public boolean hasNext() {
            return this.node_ != null;
        }

        @Override
        public Node next() {
            if (this.node_ != null) {
                Node n = this.node_;
                this.node_ = n.getNextSibling();
                return n;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

