/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.CMRuntimeException;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

public class DocumentBuilderPool {
    private volatile DocumentBuilderFactory docBuilderFactory_ = null;
    private int maxSize;
    private Stack<DocumentBuilder> builders;

    public DocumentBuilderPool(int size) {
        this.initialize();
        this.maxSize = size;
    }

    private void initialize() {
        this.docBuilderFactory_ = DocumentBuilderFactory.newInstance();
        this.docBuilderFactory_.setNamespaceAware(true);
        this.builders = new Stack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentBuilder getDocumentBuilder() {
        Stack<DocumentBuilder> stack = this.builders;
        synchronized (stack) {
            if (this.builders.size() > 0) {
                return this.builders.pop();
            }
        }
        return this.newDocumentBuilder();
    }

    private DocumentBuilder newDocumentBuilder() {
        try {
            return this.docBuilderFactory_.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CMRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnDocumentBuilder(DocumentBuilder documentBuilder) {
        Stack<DocumentBuilder> stack = this.builders;
        synchronized (stack) {
            if (this.builders.size() < this.maxSize) {
                this.builders.push(documentBuilder);
            }
        }
    }

    int size_test() {
        return this.builders.size();
    }
}

