/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.C8Edition;
import com.cognos.cm.server.CMServlet;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;

public class EditionAwareResourceLoader
implements CMResourceLoader {
    private CMResourceLoader baseLoader;

    public EditionAwareResourceLoader(CMResourceLoader base) {
        this.baseLoader = base;
    }

    public InputStream getResourceInputStream(String resourcePath) {
        InputStream is = this.baseLoader.getResourceInputStream(EditionAwareResourceLoader.getEditionSpecificName(resourcePath));
        if (is == null) {
            is = this.baseLoader.getResourceInputStream(resourcePath);
        }
        return is;
    }

    public String[] listResourceNames(String resourcePath) {
        String[] array = this.baseLoader.listResourceNames(resourcePath);
        if (array == null) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        for (String s : array) {
            set.add(EditionAwareResourceLoader.getEditionNeutralName(s));
        }
        if (set.size() == array.length) {
            return array;
        }
        array = new String[set.size()];
        Arrays.sort(set.toArray(array));
        return array;
    }

    private static String getEditionNeutralName(String name) {
        String edition;
        int at = name.lastIndexOf(64);
        if (at == -1) {
            return name;
        }
        int dot = name.indexOf(46, at + 1);
        if (dot == -1) {
            dot = name.length();
        }
        if (C8Edition.get(edition = name.substring(at + 1, dot)) == null) {
            throw new IllegalStateException("Resource " + name + " has unrecognized edition marker");
        }
        StringBuilder bld = new StringBuilder(name.length());
        return bld.append(name, 0, at).append(name, dot, name.length()).toString();
    }

    private static String getEditionSpecificName(String name) {
        if (CMServlet.getEdition() == null) {
            return name;
        }
        String edition = CMServlet.getEdition().getName();
        int i = name.lastIndexOf(46);
        if (i == -1) {
            i = name.length();
        }
        StringBuilder bld = new StringBuilder();
        return bld.append(name, 0, i).append('@').append(edition).append(name, i, name.length()).toString();
    }
}

