/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

public class IntBitField {
    private int freeBitsOffset = 0;

    public Bits allocateBits(int numBits) {
        Bits member = new Bits(this.freeBitsOffset, numBits);
        this.freeBitsOffset += numBits;
        return member;
    }

    public static class Bits {
        private static long[] BITMASKS = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L};
        private int bitShift;
        private int bitSize;
        private long bitMask;
        private long bitMax;

        private Bits(int bitShift, int bitSize) {
            if (bitShift < 0 || bitShift > 31 || bitSize < 1 || bitSize > 32) {
                throw new IllegalArgumentException("Only 32-bit bit fields are supported");
            }
            this.bitShift = bitShift;
            this.bitSize = bitSize;
            for (int i = 0; i < bitSize; ++i) {
                this.bitMask += BITMASKS[bitShift + i];
                this.bitMax += BITMASKS[i];
            }
        }

        public int setBits(int bitFieldHolder, boolean b) {
            if (this.bitSize != 1) {
                throw new IllegalArgumentException("A boolean argument cannot be used with a multi-bit member");
            }
            int bits = (int)((long)((b ? 1 : 0) << this.bitShift) & this.bitMask);
            return (int)((long)bitFieldHolder & (this.bitMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)bits);
        }

        public int setBits(int bitFieldHolder, int i) {
            if ((long)i > this.bitMax) {
                throw new IllegalArgumentException("The supplied value (" + i + ") exceeds the maximum (" + this.bitMax + ")");
            }
            int bits = (int)((long)(i << this.bitShift) & this.bitMask);
            return (int)((long)bitFieldHolder & (this.bitMask ^ 0xFFFFFFFFFFFFFFFFL) | (long)bits);
        }

        public int getBits(int bitFieldHolder) {
            return (int)(((long)bitFieldHolder & this.bitMask) >>> this.bitShift);
        }

        public boolean isSet(int bitFieldHolder) {
            if (this.bitSize != 1) {
                throw new IllegalArgumentException("Boolean conversion cannot be used with a multi-bit member");
            }
            return this.getBits(bitFieldHolder) == 1;
        }
    }
}

