/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class JsonWriter {
    private static final int STR_BUFFER_LEN = 4096;
    protected boolean prettyPrint;
    protected Writer out;
    protected char[] indentChars;
    protected int indentLevel;
    private char[] strBuf;

    public JsonWriter(Writer w) {
        this.out = w;
        this.strBuf = new char[4096];
    }

    public boolean setPrettyPrint(boolean newValue) {
        boolean oldValue = this.prettyPrint;
        this.prettyPrint = newValue;
        this.indentChars = this.prettyPrint ? new char[60] : new char[0];
        Arrays.fill(this.indentChars, 0, this.indentChars.length, ' ');
        this.indentLevel = 0;
        return oldValue;
    }

    void setBufferSize(int size) {
        this.strBuf = new char[size];
    }

    public void write(Object obj) throws IOException {
        this.write(obj, true);
    }

    public void write(Object obj, boolean flush) throws IOException {
        this.writeAny(obj);
        if (flush) {
            this.out.flush();
        }
    }

    protected void writeAny(Object obj) throws IOException {
        if (obj == null) {
            this.out.write("null");
        } else if (obj instanceof Map) {
            this.writeObject((Map)obj);
        } else if (obj instanceof List) {
            this.writeArray((List)obj);
        } else if (obj instanceof String) {
            this.writeString((String)obj);
        } else if (obj instanceof Double || obj instanceof Float) {
            this.out.write(obj.toString());
        } else if (obj instanceof Boolean || obj instanceof Number) {
            this.out.write(obj.toString());
        } else {
            throw new IOException("Unexpected object type: " + obj.getClass().getCanonicalName());
        }
    }

    private void writeArray(List<Object> obj) throws IOException {
        if (obj.isEmpty()) {
            this.out.write("[]");
            return;
        }
        this.out.write("[");
        this.indent();
        boolean first = true;
        for (Object o : obj) {
            if (first) {
                first = false;
            } else {
                this.out.write(",");
            }
            this.newLine();
            this.writeAny(o);
        }
        this.unindent();
        this.newLine();
        this.out.write("]");
    }

    protected void writeObject(Map<Object, Object> obj) throws IOException {
        if (obj.isEmpty()) {
            this.out.write("{}");
            return;
        }
        if (this.indentLevel != 0) {
            this.newLine();
        }
        this.out.write("{");
        this.indent();
        boolean first = true;
        for (Map.Entry<Object, Object> entry : obj.entrySet()) {
            if (first) {
                first = false;
            } else {
                this.out.write(",");
            }
            this.newLine();
            String key = (String)entry.getKey();
            this.writeString(key);
            if (this.prettyPrint) {
                this.out.write(": ");
            } else {
                this.out.write(":");
            }
            this.writeAny(entry.getValue());
        }
        this.unindent();
        this.newLine();
        this.out.write("}");
    }

    protected void writeString(String value) throws IOException {
        this.out.write(34);
        int start = 0;
        int end = 0;
        int strLen = value.length();
        while (end < strLen) {
            start = end;
            int n = Math.min(this.strBuf.length, strLen - start);
            end = start + n;
            value.getChars(start, end, this.strBuf, 0);
            int off = 0;
            String escape = null;
            for (int i = 0; i < n; ++i) {
                char ch = this.strBuf[i];
                switch (ch) {
                    case '\b': {
                        escape = "\\b";
                        break;
                    }
                    case '\t': {
                        escape = "\\t";
                        break;
                    }
                    case '\n': {
                        escape = "\\n";
                        break;
                    }
                    case '\f': {
                        escape = "\\f";
                        break;
                    }
                    case '\r': {
                        escape = "\\r";
                        break;
                    }
                    case '\"': {
                        escape = "\\\"";
                        break;
                    }
                    case '/': {
                        escape = "\\/";
                        break;
                    }
                    case '\\': {
                        escape = "\\\\";
                        break;
                    }
                    default: {
                        if (ch >= ' ' && ch <= '~') break;
                        escape = String.format("\\u%04x", ch);
                    }
                }
                if (escape == null) continue;
                if (i != off) {
                    this.out.write(this.strBuf, off, i - off);
                }
                this.out.write(escape);
                escape = null;
                off = i + 1;
            }
            if (off >= n) continue;
            this.out.write(this.strBuf, off, n - off);
        }
        this.out.write(34);
    }

    protected void newLine() throws IOException {
        if (this.prettyPrint) {
            this.out.write("\r\n");
            this.out.write(this.indentChars, 0, this.indentLevel);
        }
    }

    protected void indent() {
        if (this.prettyPrint) {
            this.indentLevel += 3;
            if (this.indentLevel > this.indentChars.length) {
                char[] tmp = new char[this.indentChars.length + 60];
                Arrays.fill(tmp, ' ');
                this.indentChars = tmp;
            }
        }
    }

    protected void unindent() {
        if (this.prettyPrint) {
            this.indentLevel -= 3;
            if (this.indentLevel < 0) {
                throw new IllegalStateException();
            }
        }
    }
}

