/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUMap<K, V>
extends LinkedHashMap<K, V> {
    private int maxSize;
    private LRU_Ordering ordering;

    public LRUMap(int maxSize, LRU_Ordering ordering) {
        super(maxSize, 0.75f, ordering == LRU_Ordering.ACCESS);
        this.setMaxSize(maxSize);
        this.ordering = ordering;
    }

    public LRUMap(int maxSize) {
        this(maxSize, LRU_Ordering.INSERT);
    }

    @Override
    public V put(K key, V value) {
        if (this.ordering == LRU_Ordering.UPDATE) {
            return this.updateValue(key, value);
        }
        return super.put(key, value);
    }

    private V updateValue(K key, V value) {
        Object oldValue = this.remove(key);
        super.put(key, value);
        return oldValue;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.getMaxSize();
    }

    public void setMaxSize(int maxSize) {
        if (maxSize < this.maxSize) {
            this.clear();
        }
        this.maxSize = maxSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public static enum LRU_Ordering {
        INSERT,
        UPDATE,
        ACCESS;

    }
}

