/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.CMException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class MultiVolumeZipFile
extends ZipFile {
    private boolean isMultivolume_;
    private HashMap<String, ZipEntry> entries_;
    private String archiveName_;
    private ArrayList<Volume> volumes_;

    public MultiVolumeZipFile(String s) throws IOException, CMException {
        this(new File(s));
    }

    public MultiVolumeZipFile(File file) throws IOException, CMException {
        super(file);
        if (MultiVolumeZipFile.getVolumeMarker(this) == null) {
            return;
        }
        this.isMultivolume_ = true;
        this.archiveName_ = file.getPath();
        super.close();
        ArrayList<ArrayList<ZipEntry>> unsortedEntries = new ArrayList<ArrayList<ZipEntry>>();
        this.volumes_ = new ArrayList();
        try {
            this.findAllVolumes(file, unsortedEntries);
            this.createEntriesMap(unsortedEntries);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        catch (CMException e) {
            this.close();
            throw e;
        }
        catch (InternalError er) {
            throw new CMException("cmArchiveBad", new CMException.Parm("Archive", file.getName()));
        }
    }

    @Override
    public String getName() {
        if (this.isMultivolume_) {
            return super.getName();
        }
        return this.archiveName_;
    }

    @Override
    public int size() {
        if (!this.isMultivolume_) {
            return super.size();
        }
        return this.entries_.size();
    }

    @Override
    public ZipEntry getEntry(String name) {
        if (!this.isMultivolume_) {
            return super.getEntry(name);
        }
        return this.entries_.get(name);
    }

    @Override
    public Enumeration<? extends ZipEntry> entries() {
        if (!this.isMultivolume_) {
            return super.entries();
        }
        return new Enumeration<ZipEntry>(){
            private Iterator<ZipEntry> it_;
            {
                this.it_ = MultiVolumeZipFile.this.entries_.values().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it_.hasNext();
            }

            @Override
            public ZipEntry nextElement() throws NoSuchElementException {
                return this.it_.next();
            }
        };
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        if (!this.isMultivolume_) {
            return super.getInputStream(entry);
        }
        if (!(entry instanceof ZipEntryEx)) {
            return null;
        }
        if (entry != this.entries_.get(entry.getName())) {
            return null;
        }
        return new ZipFileInputStream((ZipEntryEx)entry);
    }

    @Override
    public void close() throws IOException {
        if (!this.isMultivolume_) {
            super.close();
        } else {
            for (int i = 0; i < this.volumes_.size(); ++i) {
                Volume volume = this.volumes_.get(i);
                if (volume == null) continue;
                MultiVolumeZipFile.safeCloseZip(volume.zip);
            }
            this.entries_ = null;
            this.volumes_ = null;
        }
    }

    private ZipFile openVolume(int i) throws IOException {
        Volume volume = this.volumes_.get(i);
        ++volume.refCount;
        if (volume.refCount == 1) {
            if (volume.zip != null) {
                throw new IllegalStateException("volume is already opened");
            }
            volume.zip = new ZipFile(volume.file);
        }
        if (volume.zip == null) {
            throw new IllegalStateException("volume is not opened");
        }
        return volume.zip;
    }

    private void closeVolume(int i) throws IOException {
        Volume volume = this.volumes_.get(i);
        if (volume.zip == null) {
            throw new IllegalStateException("volume is already closed");
        }
        --volume.refCount;
        if (volume.refCount == 0) {
            volume.zip.close();
            volume.zip = null;
        }
    }

    static String getVolumeMarker(ZipFile zip) {
        ZipEntry entry = zip.getEntry("volume.id");
        if (entry != null) {
            return entry.getComment();
        }
        return null;
    }

    static int getVolumeNumber(ZipFile zfile) {
        String marker = MultiVolumeZipFile.getVolumeMarker(zfile);
        if (marker != null) {
            String lastVolume = ":last";
            if (marker.endsWith(lastVolume)) {
                marker = marker.substring(0, marker.length() - lastVolume.length());
            }
            try {
                return Integer.parseInt(marker);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    static boolean isLastVolume(ZipFile zfile) {
        String marker = MultiVolumeZipFile.getVolumeMarker(zfile);
        return marker != null && marker.endsWith(":last");
    }

    static ArrayList<ZipEntry> createListOfEntries(ZipFile zip) {
        ArrayList<ZipEntry> result = new ArrayList<ZipEntry>();
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            result.add(en.nextElement());
        }
        return result;
    }

    private void createEntriesMap(ArrayList<ArrayList<ZipEntry>> unsortedEntries) {
        this.entries_ = new HashMap();
        for (int i = 0; i < unsortedEntries.size(); ++i) {
            for (ZipEntry entry : unsortedEntries.get(i)) {
                String name = entry.getName();
                if (name.equals("volume.id")) continue;
                if (this.entries_.containsKey(name)) {
                    ((ZipEntryEx)this.entries_.get(name)).extend(entry, i);
                    continue;
                }
                this.entries_.put(name, new ZipEntryEx(entry, i));
            }
        }
    }

    private void findAllVolumes(File file, ArrayList<ArrayList<ZipEntry>> unsortedEntries) throws CMException, IOException {
        String parent = file.getParent();
        if (parent == null) {
            parent = ".";
        }
        File[] files = new File(parent).listFiles(new PartsNameFilter(file.getName()));
        boolean haveLast = false;
        ZipFile zip = null;
        try {
            for (int i = 0; i < files.length; ++i) {
                zip = new ZipFile(files[i]);
                int idx = MultiVolumeZipFile.getVolumeNumber(zip);
                if (idx >= 0) {
                    if (MultiVolumeZipFile.isLastVolume(zip)) {
                        haveLast = true;
                    }
                    while (this.volumes_.size() <= idx) {
                        this.volumes_.add(null);
                        unsortedEntries.add(null);
                    }
                    Volume volume = new Volume();
                    volume.file = files[i];
                    this.volumes_.set(idx, volume);
                    unsortedEntries.set(idx, MultiVolumeZipFile.createListOfEntries(zip));
                }
                zip.close();
                zip = null;
            }
        }
        catch (IOException ioex) {
            MultiVolumeZipFile.safeCloseZip(zip);
            throw ioex;
        }
        if (!haveLast) {
            throw new CMException("cmDeployVolumeMissing");
        }
        MultiVolumeZipFile.checkForMissingVolume(this.volumes_);
    }

    private static void safeCloseZip(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void checkForMissingVolume(ArrayList<Volume> volumes) throws CMException {
        for (int i = 0; i < volumes.size(); ++i) {
            if (volumes.get(i) != null) continue;
            throw new CMException("cmDeployVolumeMissing");
        }
    }

    private static class Volume {
        File file;
        ZipFile zip;
        int refCount;

        private Volume() {
        }
    }

    private static class PartsNameFilter
    implements FilenameFilter {
        private String pattern_;
        private String name_;

        public PartsNameFilter(String name) throws CMException {
            String pattern;
            this.name_ = name;
            int dot = name.lastIndexOf(46);
            if (dot == -1 || name.length() < dot + 2) {
                throw new CMException("cmDeployVolumeMissing");
            }
            this.pattern_ = pattern = name.substring(0, dot + 2);
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.startsWith(this.pattern_)) {
                if (name.equals(this.name_)) {
                    return true;
                }
                String ext = name.substring(this.pattern_.length());
                try {
                    Integer.parseInt(ext);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private class ZipFileInputStream
    extends InputStream {
        private InputStream zipStream_;
        private ZipEntryEx zipEntry_;
        private int volume_;
        private boolean isOpen;

        private boolean openInputStream(int volume) throws IOException {
            if (volume < this.zipEntry_.getFirstVolume() || volume > this.zipEntry_.getLastVolume()) {
                return false;
            }
            if (this.zipStream_ != null) {
                this.zipStream_.close();
                MultiVolumeZipFile.this.closeVolume(this.volume_);
            }
            this.volume_ = volume;
            ZipFile zip = MultiVolumeZipFile.this.openVolume(this.volume_);
            ZipEntry ze = zip.getEntry(this.zipEntry_.getName());
            this.zipStream_ = zip.getInputStream(ze);
            return true;
        }

        ZipFileInputStream(ZipEntryEx entry) throws IOException {
            this.zipEntry_ = entry;
            this.isOpen = this.openInputStream(entry.getFirstVolume());
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 0 || off < 0 || off + len > b.length) {
                throw new IndexOutOfBoundsException();
            }
            int n = this.zipStream_.read(b, off, len);
            if (n >= 0) {
                return n;
            }
            if (!this.openInputStream(this.volume_ + 1)) {
                return n;
            }
            return this.zipStream_.read(b, off, len);
        }

        @Override
        public int read() throws IOException {
            int n;
            byte[] b = new byte[1];
            while ((n = this.read(b, 0, 1)) == 0) {
            }
            return n == -1 ? -1 : b[0];
        }

        @Override
        public long skip(long l) throws IOException {
            if (l == 0L) {
                return 0L;
            }
            long n = this.zipStream_.skip(l);
            if (n == 0L) {
                return this.read() == -1 ? -1L : 1L;
            }
            return n;
        }

        @Override
        public int available() throws IOException {
            return this.zipStream_.available();
        }

        @Override
        public void close() throws IOException {
            if (this.isOpen) {
                this.zipStream_.close();
                MultiVolumeZipFile.this.closeVolume(this.volume_);
                this.isOpen = false;
            }
        }
    }

    private class ZipEntryEx
    extends ZipEntry {
        private int firstVol_;
        private int lastVol_;
        private long size_;

        ZipEntryEx(ZipEntry entry, int vol) {
            super(entry);
            this.firstVol_ = vol;
            this.lastVol_ = vol;
            this.size_ = entry.getSize();
        }

        void extend(ZipEntry entry, int vol) {
            if (vol != this.lastVol_ + 1) {
                throw new IndexOutOfBoundsException();
            }
            this.size_ += entry.getSize();
            this.setCompressedSize(this.getCompressedSize() + entry.getCompressedSize());
            this.lastVol_ = vol;
        }

        @Override
        public long getSize() {
            return this.size_;
        }

        int getFirstVolume() {
            return this.firstVol_;
        }

        int getLastVolume() {
            return this.lastVol_;
        }
    }
}

