/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class MultiVolumeZipOutputStream
extends ZipOutputStream {
    public static final String VOLUME_ID = "volume.id";
    public static final String DATA_FILE = "data/0.dat";
    public static final String LAST_VOLUME = ":last";
    private static final int MAX_ENTRY_COUNT = 65533;
    private static final long MAX_ENTRY_SIZE = Integer.MAX_VALUE;
    private static final long MAX_VOLUME_SIZE = 0x7FFF7FFFL;
    private String parentPath_;
    private String name_;
    private ZipOutputStream zipStream_;
    private DataOutputStream dataStream_;
    private ZipEntry lastEntry_;
    private ZipEntry contEntry_;
    private int volume_ = -1;
    private int entryCount_;
    private long entrySize_;
    private long dirSize_;
    private long volumeSize_ = 0x7FFF7FFFL;
    private int level_ = -1;
    private int method_ = 8;

    public MultiVolumeZipOutputStream(String name) throws IOException {
        this(new File(name));
    }

    public MultiVolumeZipOutputStream(File file) throws IOException {
        super(new ByteArrayOutputStream());
        this.parentPath_ = file.getParent();
        if (this.parentPath_ == null) {
            this.parentPath_ = ".";
        }
        this.name_ = file.getName();
        if (this.name_.lastIndexOf(46) == -1) {
            this.name_ = this.name_ + ".zip";
        }
        MultiVolumeZipOutputStream.deleteAllVolumes(file);
        this.openNewVolume();
    }

    public void setVolumeSize(long size) {
        if (size > 0x7FFF7FFFL || size < 0L) {
            throw new IllegalArgumentException("invalid ZIP volume size");
        }
        this.volumeSize_ = size;
    }

    public long getVolumeSize() {
        return this.volumeSize_;
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public void setComment(String s) {
        this.zipStream_.setComment(s);
    }

    @Override
    public void setMethod(int i) {
        this.zipStream_.setMethod(i);
        this.method_ = i;
    }

    @Override
    public void setLevel(int i) {
        this.zipStream_.setLevel(i);
        this.level_ = i;
    }

    @Override
    public void putNextEntry(ZipEntry entry) throws IOException {
        if (this.lastEntry_ != null) {
            this.closeEntry();
        }
        if (this.entryCount_ == 65533) {
            this.openNewVolume();
        } else {
            this.dirSize_ += (long)this.getEntrySize(entry);
            if (this.dirSize_ + (long)this.dataStream_.size() >= this.volumeSize_ && this.entryCount_ != 0) {
                this.openNewVolume();
            }
        }
        this.zipStream_.putNextEntry(entry);
        this.lastEntry_ = entry;
        this.entrySize_ = 0L;
        ++this.entryCount_;
    }

    @Override
    public void closeEntry() throws IOException {
        this.zipStream_.closeEntry();
        if (this.contEntry_ != null) {
            this.updateEntrySize();
            this.contEntry_ = null;
        }
        this.lastEntry_ = null;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.dirSize_ + (long)this.dataStream_.size() >= this.volumeSize_ && this.entrySize_ != 0L) {
            this.openNewVolume();
        }
        int len2 = 0;
        if (this.entrySize_ + (long)len > Integer.MAX_VALUE) {
            len2 = (int)((long)len - (Integer.MAX_VALUE - this.entrySize_));
            len = (int)(Integer.MAX_VALUE - this.entrySize_);
        }
        this.zipStream_.write(b, off, len);
        this.entrySize_ += (long)len;
        if (len2 != 0) {
            this.openNewVolume();
            this.zipStream_.write(b, off + len, len2);
            this.entrySize_ += (long)len2;
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.zipStream_ == null) {
            return;
        }
        if (this.lastEntry_ != null) {
            this.closeEntry();
        }
        this.putVolumeMarker(true);
        this.zipStream_.finish();
        this.zipStream_.close();
        this.zipStream_ = null;
    }

    private void updateEntrySize() {
        long size = this.lastEntry_.getSize() + this.contEntry_.getSize();
        if (size > 0xFFFFFFFFL) {
            size = 0xFFFFFFFFL;
        }
        this.lastEntry_.setSize(size);
        this.lastEntry_.setCompressedSize(this.lastEntry_.getCompressedSize() + this.contEntry_.getCompressedSize());
    }

    private void openNewVolume() throws IOException {
        if (this.zipStream_ != null) {
            this.putVolumeMarker(false);
            this.zipStream_.finish();
            this.zipStream_.close();
        }
        String name = this.name_;
        ++this.volume_;
        if (this.volume_ != 0) {
            int dot = this.name_.lastIndexOf(46);
            String ext = String.valueOf(this.volume_);
            if (ext.length() == 1) {
                ext = "0".concat(ext);
            }
            name = this.name_.substring(0, dot + 2).concat(ext);
        }
        File file = new File(this.parentPath_, name);
        this.dataStream_ = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file), 32768));
        this.zipStream_ = new ZipOutputStream(this.dataStream_);
        this.dirSize_ = 0L;
        this.entryCount_ = 0;
        this.entrySize_ = 0L;
        if (this.contEntry_ != null) {
            this.updateEntrySize();
        }
        this.zipStream_.setMethod(this.method_);
        this.zipStream_.setLevel(this.level_);
        if (this.lastEntry_ != null) {
            this.contEntry_ = new ZipEntry(this.lastEntry_.getName());
            this.contEntry_.setMethod(this.lastEntry_.getMethod());
            this.zipStream_.putNextEntry(this.contEntry_);
            this.dirSize_ = this.getEntrySize(this.contEntry_);
            this.entryCount_ = 1;
        }
    }

    private int getEntrySize(ZipEntry entry) {
        int entrySize = 46;
        entrySize += entry.getName().length();
        if (entry.getComment() != null) {
            entrySize += entry.getComment().length();
        }
        if (entry.getExtra() != null) {
            entrySize += entry.getExtra().length;
        }
        return entrySize;
    }

    private void putVolumeMarker(boolean last) throws IOException {
        if (this.volume_ == 0 && last) {
            return;
        }
        ZipEntry entry = new ZipEntry(VOLUME_ID);
        String comment = String.valueOf(this.volume_);
        if (last) {
            comment = comment + LAST_VOLUME;
        }
        entry.setComment(comment);
        this.zipStream_.putNextEntry(entry);
    }

    public static boolean deleteAllVolumes(File archive) {
        String name;
        String parentPath = archive.getParent();
        if (parentPath == null) {
            parentPath = ".";
        }
        if ((name = archive.getName()).lastIndexOf(46) == -1) {
            name = name + ".zip";
        }
        boolean result = true;
        int dot = name.lastIndexOf(46);
        String pattern = name.substring(0, dot + 2);
        String[] list = new File(parentPath).list();
        for (int i = 0; i < list.length; ++i) {
            boolean deleteFile = false;
            if (list[i].startsWith(pattern)) {
                deleteFile = list[i].equals(name) ? true : MultiVolumeZipOutputStream.extensionEndsInNumber(list[i], dot + 2);
            }
            if (!deleteFile) continue;
            result = new File(parentPath, list[i]).delete() && result;
        }
        return result;
    }

    private static boolean extensionEndsInNumber(String ext, int numberStart) {
        String number = ext.substring(numberStart);
        try {
            Integer.parseInt(number);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

