/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.CMException;
import com.cognos.cm.util.CMResourceUtils;
import com.cognos.cm.util.IPluginLoader;
import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PluginLoader
implements IPluginLoader {
    private static IPluginLoader instance;
    private CMResourceLoader resourceLoader;

    private PluginLoader() {
        this.resourceLoader = CMResourceUtils.getResourceLoader();
    }

    protected PluginLoader(CMResourceLoader mockResourceLoader) {
        this.resourceLoader = mockResourceLoader;
    }

    public static synchronized IPluginLoader get() {
        if (instance == null) {
            instance = new PluginLoader();
        }
        return instance;
    }

    @Override
    public Class<?> getPluginWithCaching(Map<String, Class<?>> cachedClasses, String pluginClassName) throws Exception {
        Class<?> pluginClass = cachedClasses.get(pluginClassName);
        if (pluginClass != null) {
            return pluginClass;
        }
        pluginClass = Class.forName(pluginClassName);
        cachedClasses.put(pluginClassName, pluginClass);
        return pluginClass;
    }

    @Override
    public String getPluginShortName(String pluginClassName) {
        int lastDotIndex = pluginClassName.lastIndexOf(46);
        if (lastDotIndex < 0) {
            return pluginClassName;
        }
        if (lastDotIndex >= pluginClassName.length() - 1) {
            throw new IllegalStateException("Plugin class name \"" + pluginClassName + "\" must not end in a \".\"");
        }
        return pluginClassName.substring(lastDotIndex + 1);
    }

    private InputStream getPluginConfigurationFileInputStream(String pluginConfigurationResourceName) {
        InputStream pluginConfigurationFileInputStream = this.resourceLoader.getResourceInputStream(pluginConfigurationResourceName);
        return pluginConfigurationFileInputStream;
    }

    @Override
    public Document getPluginConfigurationDocument(String pluginConfigurationResourceName) throws CMException {
        InputStream pluginConfigurationFileInputStream = this.getPluginConfigurationFileInputStream(pluginConfigurationResourceName);
        if (pluginConfigurationFileInputStream == null) {
            return null;
        }
        SAXReader reader = new SAXReader();
        try {
            return reader.read(pluginConfigurationFileInputStream);
        }
        catch (Exception ex) {
            throw new CMException("cmBadConfigFile", new CMException.Parm("File", pluginConfigurationResourceName));
        }
    }

    @Override
    public String getRequiredAttribute(Element rootNode, String attributeName, String taskConfigurationResourceName) throws CMException {
        String name = rootNode.attributeValue(attributeName);
        if (name == null || name.length() <= 0) {
            this.throwConfigurationParsingException(taskConfigurationResourceName, attributeName);
        }
        return name;
    }

    @Override
    public String getOptionalAttribute(Element rootNode, String attributeName, String taskConfigurationResourceName) throws CMException {
        String name = rootNode.attributeValue(attributeName);
        return name;
    }

    @Override
    public Element getRequiredChildElement(Element rootNode, String elementName, String taskConfigurationResourceName) throws CMException {
        Element element = rootNode.element(elementName);
        if (element == null) {
            this.throwConfigurationParsingException(taskConfigurationResourceName, elementName);
        }
        return element;
    }

    @Override
    public List<?> getRequiredChildElements(Element rootNode, String elementName, String taskConfigurationResourceName) throws CMException {
        List elements = rootNode.elements(elementName);
        if (elements == null) {
            this.throwConfigurationParsingException(taskConfigurationResourceName, elementName);
        }
        return elements;
    }

    @Override
    public CMException createConfigurationParsingException(String taskConfigurationResourceName, Throwable ex) {
        return new CMException(ex, "cmErrorParsingTaskConfig", new CMException.Parm("Message", ex.getMessage()), new CMException.Parm("File", taskConfigurationResourceName));
    }

    @Override
    public void throwConfigurationParsingException(String taskConfigurationResourceName, String message) throws CMException {
        throw new CMException("cmErrorParsingTaskConfig", new CMException.Parm("Message", message), new CMException.Parm("File", taskConfigurationResourceName));
    }
}

