/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.dbstore.CMDbConnection;
import com.cognos.cm.dbstore.CMDbStoreFactory;
import com.cognos.cm.indications.CMIndicationGlobals;
import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.properties.CMArrayPropertyValue;
import com.cognos.cm.properties.CMBaseClassArray;
import com.cognos.cm.properties.CMNameValuePairArray;
import com.cognos.cm.properties.CMObjectClass;
import com.cognos.cm.properties.CMObjectReference;
import com.cognos.cm.properties.CMProperty;
import com.cognos.cm.properties.CMPropertyMeaning;
import com.cognos.cm.properties.CMPropertySet;
import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.CMExecutionContext;
import com.cognos.cm.server.XMLDoc;
import com.cognos.cm.server.XMLDocParser;
import com.cognos.cm.server.XMLElement;
import com.cognos.cm.store.CMStore;
import com.cognos.cm.store.CMStoreQueryResults;
import com.cognos.cm.store.path.CMStoreXPath;
import com.cognos.cm.util.CMCAMIDHelper;
import com.cognos.cm.util.CMTempOutputStream;
import com.cognos.cmutils.io.CMStreamUtils;
import com.cognos.cmutils.tempcache.CMTempFile;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;

public class ReportOutputFile {
    private static final String DESCRIPTOR_EXTENSION = ".xml";
    private static final String DESCRIPTOR_SUFFIX = "_desc";
    private static final String FORMAT_PDF = "PDF";
    private static final String FORMAT_CSV = "CSV";
    private static final String FORMAT_XML = "XML";
    private static final String FORMAT_XLWA = "XLWA";
    private static final String FORMAT_HTML = "HTML";
    private static final String FORMAT_XHMTL = "XHTML";
    private static final String FORMAT_SPREADSHEETML = "spreadsheetML";
    private static final String FORMAT_SPREADSHEETMLDATA = "xlsxData";
    private static final String FORMAT_SPREADSHHETMLOFFICECONNECTIONENABLED = "spreadsheetMLOfficeConnectionEnabled";
    private static final String[] complexType = new String[]{"simpleParmValueItem", "hierarchicalParmValueItem", "boundRangeParmValueItem", "unboundedEndRangeParmValueItem", "unboundedStartRangeParmValueItem"};
    private Integer objectId_;
    private InputStream inputStream_;
    private String format_;
    private String burstKey_ = "";
    private String location_;
    private String script_;
    private String searchPath_;
    private String outputFileName_;
    private String descriptorFileName_;
    private CMTempOutputStream tempFileOutputStream_ = null;
    private CMTempFile tempFile_ = null;
    private CMStoreQueryResults outputResults_ = null;
    private Object tempFileCacheKey_;

    public ReportOutputFile(Integer objectId, String location, String script) {
        this.objectId_ = objectId;
        this.location_ = location;
        if (this.location_ != null && !this.location_.endsWith(File.separator)) {
            this.location_ = this.location_ + File.separator;
        }
        this.script_ = script;
    }

    public void write() throws CMException {
        try {
            if (this.location_ != null) {
                this.initialize();
                if (this.supportedFormat(this.format_)) {
                    this.writeOutput();
                    this.writeDescriptor();
                    if (this.outputFileName_ != null && new File(this.outputFileName_).length() > 0L) {
                        this.runShellScript();
                    }
                }
            }
        }
        finally {
            if (this.inputStream_ != null) {
                try {
                    this.inputStream_.close();
                }
                catch (IOException iOException) {}
            }
            if (this.tempFile_ != null) {
                this.tempFile_.release();
            }
            if (this.tempFileOutputStream_ != null) {
                try {
                    this.tempFileOutputStream_.delete();
                }
                catch (IOException iOException) {}
            }
            if (this.outputResults_ != null) {
                this.outputResults_.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws CMException {
        CMProperty[] outputProps2;
        CMStore store = CMExecutionContext.get().getStore();
        CMPropertySet propSet = store.getPropertySets().getPropertySet();
        this.searchPath_ = store.getObjectSearchPath(this.objectId_);
        CMProperty dataProperty = propSet.getProperty(CMPropertyMeaning.DATA, CMObjectClass.OUTPUT);
        this.tempFileCacheKey_ = CMDbStoreFactory.tempfileCache_.getNewTempFileCacheKey(this.objectId_, dataProperty);
        try {
            this.tempFile_ = CMDbStoreFactory.tempfileCache_.get(this.tempFileCacheKey_);
            if (this.tempFile_ != null) {
                this.inputStream_ = this.tempFile_.getInputStream();
            }
        }
        catch (FileNotFoundException ex) {
            throw new CMException((Exception)ex, "cmFailedOutputCopy", new CMException.Parm("Filename", "unknown"), new CMException.Parm("Path", this.searchPath_));
        }
        CMProperty dataIsCompressedProperty = propSet.getProperty(CMPropertyMeaning._DATAISCOMPRESSED, CMObjectClass.OUTPUT);
        boolean isCompressed = false;
        if (this.inputStream_ == null) {
            outputProps2 = new CMProperty[]{CMProperty.FORMAT, dataIsCompressedProperty, CMProperty.BURSTKEY, dataProperty};
            this.outputResults_ = store.executeQuery(new CMStoreXPath(this.searchPath_), outputProps2, null, 0, 512, null);
        } else {
            outputProps2 = new CMProperty[]{CMProperty.FORMAT, dataIsCompressedProperty, CMProperty.BURSTKEY};
            this.outputResults_ = store.executeQuery(new CMStoreXPath(this.searchPath_), outputProps2, null, 0, 512, null);
        }
        if (this.outputResults_ != null && this.outputResults_.next()) {
            if (this.outputResults_.getValue(0) != null) {
                this.format_ = this.outputResults_.getValue(0).toString();
            }
            if (this.outputResults_.getValue(1) != null) {
                isCompressed = this.outputResults_.getValue(1).toString().equals("true");
            }
            if (this.outputResults_.getValue(2) != null) {
                this.burstKey_ = this.outputResults_.getValue(2).toString();
            }
            if (this.inputStream_ == null && this.outputResults_.getValue(3) != null) {
                this.inputStream_ = (InputStream)this.outputResults_.getValue(3);
                if (isCompressed && CMDbConnection.dbms_ == 1) {
                    try {
                        try {
                            this.tempFileOutputStream_ = new CMTempOutputStream();
                            CMStreamUtils.copyStream((InputStream)this.inputStream_, (OutputStream)this.tempFileOutputStream_);
                        }
                        finally {
                            try {
                                this.tempFileOutputStream_.close();
                            }
                            catch (IOException outputProps2) {}
                        }
                        this.inputStream_ = this.tempFileOutputStream_.getInputStream();
                    }
                    catch (IOException e) {
                        throw new CMException((Exception)e, "cmFailedOutputCopy", new CMException.Parm("Filename", "unknown"), new CMException.Parm("Path", this.searchPath_));
                    }
                }
            }
        }
        if (isCompressed) {
            try {
                this.inputStream_ = new GZIPInputStream(this.inputStream_, 32768);
            }
            catch (IOException ex) {
                throw new CMException((Exception)ex, "cmFailedOutputCopy", new CMException.Parm("Filename", "unknown"), new CMException.Parm("Path", this.searchPath_));
            }
        }
        if (AdvancedSettings.OUTPUTBYBURSTKEY && this.burstKey_ != null && this.burstKey_.length() > 0) {
            this.location_ = this.location_ + this.burstKey_ + File.separatorChar;
        }
        Timestamp creationTime = store.getCreationTimeObjectID(this.objectId_);
        String outputName = this.objectId_.toString() + "_" + (creationTime.getTime() / 1000L * 1000L + (long)creationTime.getNanos() / 1000000L);
        this.outputFileName_ = this.location_ + outputName + ReportOutputFile.getOutputExtensionWithDot(this.format_);
        String descriptorName = outputName + DESCRIPTOR_SUFFIX;
        this.descriptorFileName_ = this.location_ + descriptorName + DESCRIPTOR_EXTENSION;
    }

    private void writeOutput() throws CMException {
        File locationDirectory = new File(this.location_);
        if (!locationDirectory.exists() && !locationDirectory.mkdirs()) {
            throw new CMException("cmFailedOutputCopy", new CMException.Parm("Filename", this.outputFileName_), new CMException.Parm("Path", this.searchPath_));
        }
        File outputFile = new File(this.outputFileName_);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outputFile);
            if (CMIndicationGlobals.bTempDebugLogEnabled) {
                CMIndications.CMTempDebugTrace("Writing Output.");
            }
            byte[] inputData = new byte[32768];
            if (this.inputStream_ != null) {
                int nBytesRead = this.inputStream_.read(inputData);
                while (nBytesRead > 0) {
                    outputStream.write(inputData, 0, nBytesRead);
                    nBytesRead = this.inputStream_.read(inputData);
                }
            }
        }
        catch (IOException e) {
            throw new CMException((Exception)e, "cmFailedOutputCopy", new CMException.Parm("Filename", this.outputFileName_), new CMException.Parm("Path", this.searchPath_));
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDescriptor() throws CMException {
        FileOutputStream outputStream = null;
        String fileName = this.outputFileName_.substring(this.location_.length());
        CMStoreQueryResults qresults = null;
        try {
            CMStore store = CMExecutionContext.get().getStore();
            String defaultName = "";
            String locale = "";
            CMStoreXPath outputPath = new CMStoreXPath(null, this.searchPath_, false);
            CMProperty[] outputProps = new CMProperty[]{CMProperty.DEFAULTNAME, CMProperty.LOCALE};
            try {
                qresults = store.executeQuery(outputPath, outputProps, null, 0, 512, null);
                if (qresults != null && qresults.next()) {
                    if (qresults.getValue(0) != null) {
                        defaultName = qresults.getValue(0).toString();
                    }
                    if (qresults.getValue(1) != null) {
                        locale = qresults.getValue(1).toString();
                    }
                }
            }
            finally {
                if (qresults != null) {
                    qresults.release();
                }
            }
            String reportVersionTenantID = "";
            String asOfTime = "";
            CMArrayPropertyValue parameters = null;
            String sParmXML = "";
            CMArrayPropertyValue contacts = null;
            String sContXML = "";
            String reportVersionSearchPath = this.searchPath_ + "/..";
            CMStoreXPath reportVersionPath = new CMStoreXPath(null, reportVersionSearchPath, false);
            CMProperty[] reportVersionProps = new CMProperty[]{CMProperty.ASOFTIME, CMProperty.PARAMETERS, CMProperty.CONTACT, CMProperty.TENANTID};
            try {
                int i;
                qresults = store.executeQuery(reportVersionPath, reportVersionProps, null, 0, 512, null);
                if (qresults != null && qresults.next()) {
                    if (qresults.getValue(0) != null) {
                        asOfTime = qresults.getValue(0).toString();
                    }
                    if (qresults.getValue(1) != null) {
                        parameters = (CMNameValuePairArray)qresults.getValue(1);
                    }
                    if (qresults.getValue(2) != null) {
                        contacts = (CMBaseClassArray)qresults.getValue(2);
                    }
                    if (qresults.getValue(3) != null) {
                        reportVersionTenantID = qresults.getValue(3).toString();
                    }
                }
                if (parameters != null) {
                    for (i = 0; i < parameters.getSize(); ++i) {
                        sParmXML = sParmXML + this.getParameters(parameters.getXMLItemContent(i, CMProperty.PARAMETERS, 0));
                    }
                }
                if (contacts != null) {
                    for (i = 0; i < contacts.getSize(); ++i) {
                        sContXML = sContXML + this.getContacts(contacts.getXMLItemContent(i, CMProperty.CONTACT, 0));
                    }
                }
            }
            finally {
                if (qresults != null) {
                    qresults.release();
                }
            }
            String defaultDescription = "";
            String reportSearchPath = "";
            String reportViewSearchPath = null;
            String baseReportSearchPath = reportVersionSearchPath + "/..";
            CMStoreXPath baseReportPath = new CMStoreXPath(null, baseReportSearchPath, false);
            CMProperty[] baseReportProps = new CMProperty[]{CMProperty.BASE, CMProperty.CONTACT, CMProperty.DEFAULTDESCRIPTION};
            try {
                qresults = store.executeQuery(baseReportPath, baseReportProps, null, 0, 512, null);
                if (qresults != null && qresults.next()) {
                    if (qresults.getValue(0) != null) {
                        CMObjectReference ref;
                        reportViewSearchPath = qresults.getSearchPath();
                        CMBaseClassArray value = (CMBaseClassArray)qresults.getValue(0);
                        if (value.getSize() > 0 && (ref = value.getReference(0)) != null) {
                            reportSearchPath = ref.getSearchPath();
                        }
                    } else {
                        reportSearchPath = qresults.getSearchPath();
                    }
                    if (qresults.getValue(1) != null && contacts == null && (contacts = (CMBaseClassArray)qresults.getValue(1)) != null) {
                        for (int i = 0; i < contacts.getSize(); ++i) {
                            sContXML = sContXML + this.getContacts(contacts.getXMLItemContent(i, CMProperty.CONTACT, 0));
                        }
                    }
                    if (qresults.getValue(2) != null) {
                        defaultDescription = qresults.getValue(2).toString();
                    }
                }
            }
            finally {
                if (qresults != null) {
                    qresults.release();
                }
            }
            String owner = "";
            int ownerObjectId = store.getOwnerObjectID(this.objectId_);
            String ownerSearchPath = store.getObjectSearchPath(ownerObjectId);
            CMStoreXPath ownerPath = new CMStoreXPath(null, ownerSearchPath, false);
            CMProperty[] ownerProps = new CMProperty[]{CMProperty.USERNAME};
            try {
                qresults = store.executeQuery(ownerPath, ownerProps, null, 0, 512, null);
                if (qresults != null && qresults.next() && qresults.getValue(0) != null) {
                    owner = qresults.getValue(0).toString();
                }
            }
            finally {
                if (qresults != null) {
                    qresults.release();
                }
            }
            String camid = CMCAMIDHelper.CAMIDFromSearchPath(ownerSearchPath);
            String ownerNamespace = CMCAMIDHelper.CAMIDIsExternal(camid) ? CMCAMIDHelper.getNamespaceIDFromCAMID(camid) : "Cognos";
            if (CMIndicationGlobals.bTempDebugLogEnabled) {
                CMIndications.CMTempDebugTrace("Writing Output Descriptor.");
            }
            StringBuffer outputData = new StringBuffer(5000);
            outputData.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
            outputData.append("<outputDescriptor\r\n");
            outputData.append("\t\txmlns=\"http://developer.cognos.com/schema/OutputDescriptor/1.0\"\r\n");
            outputData.append("\t\txmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\"\r\n");
            outputData.append("\t\txmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\r\n");
            outputData.append("\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n");
            outputData.append("\t\t>\r\n");
            outputData.append("\t<tenantID>" + reportVersionTenantID + "</tenantID>\r\n");
            outputData.append("\t<asOfTime>" + asOfTime + "</asOfTime>\r\n");
            outputData.append("\t<burstKey>" + XMLUtils.escape((String)this.burstKey_) + "</burstKey>\r\n");
            if (sContXML.length() == 0) {
                outputData.append("\t<contact/>\r\n");
            } else {
                outputData.append("\t<contact>\r\n" + sContXML + "\t</contact>\r\n");
            }
            outputData.append("\t<defaultDescription>" + XMLUtils.escape((String)defaultDescription) + "</defaultDescription>\r\n");
            outputData.append("\t<defaultName>" + XMLUtils.escape((String)defaultName) + "</defaultName>\r\n");
            outputData.append("\t<fileName>" + fileName + "</fileName>\r\n");
            outputData.append("\t<locale>" + locale + "</locale>\r\n");
            outputData.append("\t<owner>" + XMLUtils.escape((String)owner) + "</owner>\r\n");
            outputData.append("\t<ownerNamespace>" + XMLUtils.escape((String)ownerNamespace) + "</ownerNamespace>\r\n");
            if (sParmXML.length() == 0) {
                outputData.append("\t<parameterValues/>\r\n");
            } else {
                outputData.append("\t<parameterValues>\r\n" + sParmXML + "\t</parameterValues>\r\n");
            }
            outputData.append("\t<reportSearchPath>" + XMLUtils.escape((String)reportSearchPath) + "</reportSearchPath>\r\n");
            if (reportViewSearchPath == null) {
                outputData.append("\t<reportViewSearchPath xsi:nil=\"true\"/>\r\n");
            } else {
                outputData.append("\t<reportViewSearchPath>" + XMLUtils.escape((String)reportViewSearchPath) + "</reportViewSearchPath>\r\n");
            }
            outputData.append("</outputDescriptor>\r\n");
            File descriptorFile = new File(this.descriptorFileName_);
            outputStream = new FileOutputStream(descriptorFile);
            outputStream.write(outputData.toString().getBytes("UTF-8"));
        }
        catch (CMException e) {
            throw new CMException((Exception)e, "cmFailedOutputDescriptor", new CMException.Parm("Filename", this.descriptorFileName_), new CMException.Parm("Path", this.searchPath_));
        }
        catch (IOException e) {
            throw new CMException((Exception)e, "cmFailedOutputDescriptor", new CMException.Parm("Filename", this.descriptorFileName_), new CMException.Parm("Path", this.searchPath_));
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void runShellScript() throws CMException {
        if (this.script_ != null && this.script_.length() > 0) {
            if (CMIndicationGlobals.bTempDebugLogEnabled) {
                CMIndications.CMTempDebugTrace("Running Output Script.");
            }
            String[] cmdArray = new String[]{this.script_, this.outputFileName_, this.descriptorFileName_};
            try {
                ProcessBuilder pb = new ProcessBuilder(cmdArray);
                pb.redirectErrorStream(true);
                final Process p = pb.start();
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        InputStream is = p.getInputStream();
                        byte[] buffer = new byte[8192];
                        try {
                            while (0 <= is.read(buffer)) {
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                };
                t.start();
            }
            catch (IOException e) {
                throw new CMException((Exception)e, "cmFailedOutputScript", new CMException.Parm("Scriptname", this.script_), new CMException.Parm("Path", this.searchPath_));
            }
        }
    }

    private boolean supportedFormat(String format) {
        return format != null && (format.equals(FORMAT_PDF) || format.equals(FORMAT_CSV) || format.equals(FORMAT_XLWA) || format.equals(FORMAT_XML) || format.equals(FORMAT_HTML) || format.equals(FORMAT_XHMTL) || format.equals(FORMAT_SPREADSHEETML) || format.equals(FORMAT_SPREADSHEETMLDATA) || format.equals(FORMAT_SPREADSHHETMLOFFICECONNECTIONENABLED));
    }

    private static String getOutputExtensionWithDot(String format) {
        String extention = ReportOutputFile.getOutputExtension(format);
        if (extention.length() > 0) {
            extention = "." + extention;
        }
        return extention;
    }

    public static String getOutputExtension(String format) {
        if (format != null) {
            if (format.equals(FORMAT_PDF)) {
                return "pdf";
            }
            if (format.equals(FORMAT_XML)) {
                return "xml";
            }
            if (format.equals(FORMAT_CSV)) {
                return "csv";
            }
            if (format.equals(FORMAT_XLWA)) {
                return "mht";
            }
            if (format.equals(FORMAT_HTML)) {
                return "htm";
            }
            if (format.equals(FORMAT_XHMTL)) {
                return "mht";
            }
            if (format.equals(FORMAT_SPREADSHEETML) || format.equals(FORMAT_SPREADSHEETMLDATA) || format.equals(FORMAT_SPREADSHHETMLOFFICECONNECTIONENABLED)) {
                return "xlsx";
            }
        }
        return "";
    }

    private String getParameters(String sParameters) throws CMException {
        XMLElement rootElem = this.getRootElement(sParameters);
        if (rootElem == null) {
            return null;
        }
        rootElem = this.removeXsiType(rootElem);
        String sRet = rootElem.makeXML("\t\t", true, false);
        return sRet;
    }

    private String getContacts(String sContacts) throws CMException {
        XMLElement rootElem = this.getRootElement(sContacts);
        if (rootElem == null) {
            return null;
        }
        rootElem = this.removeXsiType(rootElem);
        rootElem = this.removeXmlSpace(rootElem);
        String sRet = rootElem.makeXML("\t\t", true, false);
        return sRet;
    }

    private XMLElement getRootElement(String xmlContent) throws CMException {
        XMLDocParser parser = new XMLDocParser();
        XMLDoc doc = null;
        try {
            doc = parser.readXML("<item xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" xmlns:bus=\"http://developer.cognos.com/schemas/bibus/3/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">" + xmlContent + "</item>\r\n");
        }
        catch (Exception e) {
            throw new CMException(e, "cmErrParse");
        }
        if (doc == null) {
            return null;
        }
        XMLElement rootElem = doc.getRootXMLElement();
        if (rootElem == null || !rootElem.hasChildren()) {
            return null;
        }
        return rootElem;
    }

    private boolean isComplexType(String sTypeIn) {
        for (int i = 0; i < complexType.length; ++i) {
            String sType = complexType[i];
            if (!sType.equals(sTypeIn)) continue;
            return true;
        }
        return false;
    }

    private XMLElement removeXsiType(XMLElement elem) {
        String sXsiType = elem.xsiType_;
        if (this.isComplexType(sXsiType)) {
            elem.xsiTypeNs_ = null;
        } else {
            elem.xsiType_ = null;
        }
        if (elem.hasChildren()) {
            ArrayList<XMLElement> list = elem.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                XMLElement elem1 = (XMLElement)list.get(i);
                if (!elem.hasChildren()) continue;
                this.removeXsiType(elem1);
            }
        }
        return elem;
    }

    private XMLElement removeXmlSpace(XMLElement elem) {
        int idx;
        if (elem.attributes_ != null && (idx = elem.attributes_.getIndex("xml:space")) > -1) {
            elem.attributes_.removeAttribute(idx);
        }
        if (elem.hasChildren()) {
            ArrayList<XMLElement> list = elem.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                XMLElement elem1 = (XMLElement)list.get(i);
                if (!elem.hasChildren()) continue;
                this.removeXmlSpace(elem1);
            }
        }
        return elem;
    }
}

