/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.server.CMException;
import com.cognos.cmutils.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RequestPasswordRemover {
    public static String CREDENTIALS = "&lt;credential";
    public static String CREDENTIAL = "credential>";
    public static String PASSWORD = "password";
    private static final String CAMPASSWORD = "CAMPassword";
    private static final String CAMOLDPASSWORD = "CAMOldPassword";
    private static final String CAMNEWPASSWORD = "CAMNewPassword";
    static final String PASSWORD_REPLACEMENT = "##PASSWORD##";

    public static boolean containsPasword(String req) {
        return req.indexOf(CAMPASSWORD) != -1 || req.indexOf(CREDENTIAL) != -1 || req.indexOf(CREDENTIALS) != -1 || req.indexOf(CAMOLDPASSWORD) != -1 || req.indexOf(CAMNEWPASSWORD) != -1;
    }

    public static Document filterOutPassword(Document doc) {
        Element temp = doc.getRootElement();
        if (temp.getName().equals("Envelope")) {
            RequestPasswordRemover.handleFormFieldVars(temp);
            RequestPasswordRemover.handleCredentials(temp);
            RequestPasswordRemover.handleHeaderCredential(temp);
        }
        return doc;
    }

    private static void handleHeaderCredential(Element el) {
        List pswNodes = XMLUtils.selectNodes((Element)el, (String)"//password");
        if (pswNodes.size() != 0) {
            for (Element psw : pswNodes) {
                psw.setText(PASSWORD_REPLACEMENT);
            }
        }
    }

    private static Element selectElement(Element root, String ... path) {
        String name;
        String[] stringArray = path;
        int n = stringArray.length;
        for (int i = 0; i < n && (root = root.element(name = stringArray[i])) != null; ++i) {
        }
        return root;
    }

    private static void handleFormFieldVars(Element el) {
        if ((el = RequestPasswordRemover.selectElement(el, "Header", "biBusHeader", "hdrSession", "formFieldVars")) == null) {
            return;
        }
        List items = el.elements();
        for (Element item : items) {
            Element value;
            Element name = item.element("name");
            if (name == null || !RequestPasswordRemover.needReplace(name.getText()) || (value = item.element("value")) == null) continue;
            value.setText(PASSWORD_REPLACEMENT);
        }
    }

    private static boolean needReplace(String text) {
        return text.equals(CAMPASSWORD) || text.equals(CAMOLDPASSWORD) || text.equals(CAMNEWPASSWORD);
    }

    private static void handleCredentials(Element el) {
        List credNodes = XMLUtils.selectNodes((Element)el, (String)"//credentials");
        if (credNodes.size() == 0) {
            return;
        }
        for (Element elem : credNodes) {
            if (!elem.isTextOnly() && (elem = elem.element("value")) == null) continue;
            elem.setText(RequestPasswordRemover.replaceCredentialPassword(elem.getText()));
        }
    }

    private static String replaceCredentialPassword(String s) {
        if (s.indexOf("encryptedValue") != -1) {
            return s;
        }
        try {
            Document doc = DocumentHelper.parseText((String)s);
            List passwordList = XMLUtils.selectNodes((Document)doc, (String)"//password");
            if (passwordList.size() != 0) {
                for (Element e : passwordList) {
                    e.setText(PASSWORD_REPLACEMENT);
                }
                return doc.getRootElement().asXML();
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        return s;
    }

    public static String filterOutPassword(String req) {
        String result;
        if (req == null || !RequestPasswordRemover.containsPasword(req)) {
            return req;
        }
        SAXReader reader = new SAXReader();
        try {
            Document doc = reader.read((InputStream)new ByteArrayInputStream(req.getBytes("UTF-8")));
            Document resDoc = RequestPasswordRemover.filterOutPassword(doc);
            result = resDoc.asXML();
        }
        catch (Exception e) {
            CMException excep = new CMException(e, "cmErrorsWhileRemovingPassword");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println("<!-- ");
            pw.write(excep.getLocalizedMessage());
            pw.println();
            e.printStackTrace(pw);
            pw.print(" -->\n");
            pw.close();
            result = sw.toString();
        }
        return result;
    }
}

