/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cmutils.resource.CMResourceLoader;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.ServletContext;

public class Servlet2dot3ResourceLoader
implements CMResourceLoader {
    private ServletContext context;

    public Servlet2dot3ResourceLoader(ServletContext context) {
        this.context = context;
    }

    public InputStream getResourceInputStream(String resourceName) {
        return this.context.getResourceAsStream(resourceName);
    }

    public String[] listResourceNames(String path) {
        String[] resourceNames = null;
        Set resourcePaths = this.context.getResourcePaths(path);
        if (resourcePaths != null) {
            Object[] resourcePathsArray = resourcePaths.toArray();
            resourceNames = new String[resourcePathsArray.length];
            for (int i = 0; i < resourceNames.length; ++i) {
                String resourcePath = "";
                if (resourcePathsArray[i] != null) {
                    resourcePath = resourcePathsArray[i].toString();
                }
                if (resourcePath.equals(path)) {
                    resourceNames[i] = ".";
                    continue;
                }
                int startIndex = 0;
                int endIndex = resourcePath.length();
                if (resourcePath.startsWith(path)) {
                    startIndex = path.length();
                } else if (resourcePath.startsWith("/")) {
                    ++startIndex;
                }
                if (resourcePath.endsWith("/")) {
                    --endIndex;
                }
                resourceNames[i] = resourcePath.substring(startIndex, endIndex);
            }
        }
        if (resourceNames != null) {
            Arrays.sort(resourceNames);
        }
        return resourceNames;
    }
}

