/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util;

import com.cognos.cm.indications.CMIndications;
import com.cognos.cm.server.CMException;
import com.cognos.cm.server.ConfigurationFactory;
import com.cognos.cm.server.IConfiguration;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class UrlUtils {
    protected static InetAddressResolverImplementation inetAddressResolver = new InetAddressResolverImplementation();

    public static String normalizeHostString(String hostString, boolean convertHostToIPAddress) {
        String host = hostString;
        if (host != null && (host.startsWith("127.") || host.equals("[::1]"))) {
            try {
                host = inetAddressResolver.getLocalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (!convertHostToIPAddress) {
            if (host == null || "localhost".equalsIgnoreCase(host)) {
                try {
                    host = inetAddressResolver.getLocalHostName();
                }
                catch (UnknownHostException ex) {
                    host = "localhost";
                }
            }
            if (host != null) {
                host = host.toLowerCase();
            }
        } else if (host == null || "localhost".equalsIgnoreCase(host)) {
            try {
                host = inetAddressResolver.getLocalHostAddress();
            }
            catch (UnknownHostException ex) {
                host = "localhost";
            }
        } else {
            try {
                host = inetAddressResolver.getRemoteHostAddress(host);
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return host;
    }

    public static String removeProtocol(String pathWithProtocol) {
        return UrlUtils.removeProtocol(pathWithProtocol, false);
    }

    public static String removeProtocol(String pathWithProtocol, boolean convertHostToIPAddress) {
        String pathWithoutProtocol = null;
        String host = null;
        String port = null;
        String path = null;
        URL tmpUrl = null;
        try {
            tmpUrl = new URL(pathWithProtocol);
        }
        catch (MalformedURLException ex) {
            String newPath = UrlUtils.unknownProtocolWorkaround(pathWithProtocol);
            try {
                tmpUrl = new URL(newPath);
            }
            catch (MalformedURLException ex1) {
                return pathWithProtocol;
            }
        }
        host = tmpUrl.getHost();
        int portNumber = tmpUrl.getPort();
        if (portNumber > -1) {
            port = String.valueOf(portNumber);
        }
        path = tmpUrl.getPath();
        host = UrlUtils.normalizeHostString(host, convertHostToIPAddress);
        if (port == null) {
            port = new String("8080");
        }
        StringBuffer dispatcherName = new StringBuffer();
        dispatcherName.append(host);
        dispatcherName.append(":");
        dispatcherName.append(port);
        dispatcherName.append(path);
        pathWithoutProtocol = dispatcherName.toString();
        return pathWithoutProtocol;
    }

    protected static String unknownProtocolWorkaround(String url) {
        String protocolSeparator = "://";
        int index = url.indexOf(protocolSeparator);
        String result = index != -1 ? "http://" + url.substring(index + protocolSeparator.length()) : "http://" + url;
        return result;
    }

    public static boolean contentManagerNamesEqual(String name1, String name2) {
        String name1NoProtocol = UrlUtils.removeProtocol(name1, true);
        String name2NoProtocol = UrlUtils.removeProtocol(name2, true);
        return name1NoProtocol.equalsIgnoreCase(name2NoProtocol);
    }

    public static String convertURItoDispatcherPath(String theURI, boolean includePath) throws CMException {
        return UrlUtils.convertURItoDispatcherPath(theURI, includePath, false);
    }

    public static String convertURItoDispatcherPath(String theURI, boolean includePath, boolean convertHostToIPAddress) throws CMException {
        String dispatcherPath = null;
        String protocol = null;
        String host = null;
        String port = null;
        String path = null;
        try {
            URL tmpUrl = new URL(theURI);
            protocol = tmpUrl.getProtocol();
            host = tmpUrl.getHost();
            int portNumber = tmpUrl.getPort();
            if (portNumber > -1) {
                port = String.valueOf(portNumber);
            }
            path = tmpUrl.getPath();
        }
        catch (MalformedURLException ex) {
            throw new CMException(ex, "cmErrDispatcherURL");
        }
        host = UrlUtils.normalizeHostString(host, convertHostToIPAddress);
        if (host.indexOf(58) != -1 && host.indexOf(91) == -1) {
            host = "[" + host + "]";
        }
        if (port == null) {
            port = new String("8080");
        }
        if (protocol == null) {
            protocol = new String("http");
        }
        StringBuffer dispatcherName = new StringBuffer();
        dispatcherName.append(protocol);
        dispatcherName.append("://");
        dispatcherName.append(host);
        dispatcherName.append(":");
        dispatcherName.append(port);
        if (includePath) {
            dispatcherName.append(path);
        } else {
            StringTokenizer pathToken = new StringTokenizer(path, "/");
            if (pathToken.hasMoreTokens()) {
                dispatcherName.append("/");
                dispatcherName.append(pathToken.nextToken());
            }
        }
        dispatcherPath = dispatcherName.toString();
        return dispatcherPath;
    }

    public static boolean localContentManager(String cmURI) {
        try {
            IConfiguration config = ConfigurationFactory.getConfig();
            cmURI = UrlUtils.convertURItoDispatcherPath(cmURI, false, false);
            String externalDispatcherURI = config.getCognosProp("externalDispatcher");
            externalDispatcherURI = UrlUtils.convertURItoDispatcherPath(externalDispatcherURI, false, false);
            if (UrlUtils.contentManagerNamesEqual(cmURI, externalDispatcherURI)) {
                return true;
            }
            String internalDispatcherURI = config.getCognosProp("internalDispatcher");
            if (UrlUtils.contentManagerNamesEqual(cmURI, internalDispatcherURI = UrlUtils.convertURItoDispatcherPath(internalDispatcherURI, false, false))) {
                return true;
            }
        }
        catch (CMException e) {
            CMIndications.logException(e);
        }
        return false;
    }

    public static class InetAddressResolverImplementation {
        public String getLocalHostName() throws UnknownHostException {
            return InetAddress.getLocalHost().getHostName();
        }

        public String getLocalHostAddress() throws UnknownHostException {
            return InetAddress.getLocalHost().getHostAddress();
        }

        public String getRemoteHostAddress(String hostName) throws UnknownHostException {
            return InetAddress.getByName(hostName).getHostAddress();
        }
    }
}

