/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.caching;

import com.cognos.cm.server.AdvancedSettings;
import com.cognos.cm.util.CMPerfAlarm;
import com.cognos.cm.util.caching.AbstractCountersCache;
import com.cognos.cm.util.caching.CMCacheEntryScale;
import com.cognos.cm.util.caching.CMDefaultCacheEntryScale;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractCMCache<K, V>
extends AbstractCountersCache<K, V> {
    protected long m_maxBytes;
    protected int m_maxSize;
    protected ConcurrentHashMap<K, CMCacheEntry> m_entries;
    protected long m_currentBytes;
    protected CMCacheEntryScale m_scale;
    private boolean firedAlarm_ = false;
    private boolean inRatioFailedState_ = false;

    public AbstractCMCache(String name, CMCacheEntryScale scale, int maxEntries, long maxBytes) {
        super(name);
        this.m_scale = scale;
        this.m_maxBytes = maxBytes;
        this.m_maxSize = maxEntries;
        this.m_entries = new ConcurrentHashMap();
        if (this.m_scale == null) {
            this.m_scale = new CMDefaultCacheEntryScale();
        }
    }

    protected abstract CMCacheEntry getNextEntryForEviction();

    protected abstract void keyRebound(CMCacheEntry var1);

    protected abstract void addEntry(CMCacheEntry var1);

    protected abstract void touchEntry(CMCacheEntry var1);

    protected abstract void removeEntry(CMCacheEntry var1);

    protected abstract CMCacheEntry newEntry(K var1, V var2);

    protected synchronized CMCacheEntry evictLeastImportantEntry() {
        CMCacheEntry entry = this.getNextEntryForEviction();
        if (entry != null) {
            this.eviction(1);
            this.remove(entry.key);
        }
        return entry;
    }

    @Override
    public synchronized void add(K key, V value) {
        CMCacheEntry entry = this.m_entries.get(key);
        if (entry != null) {
            long oldSize = this.m_scale.weigh(entry.value);
            entry.value = value;
            this.keyRebound(entry);
            this.m_currentBytes += this.m_scale.weigh(entry.value) - oldSize;
        } else {
            this.reportAdd();
            entry = this.newEntry(key, value);
            this.m_entries.put(key, entry);
            this.addEntry(entry);
            this.m_currentBytes += this.m_scale.weigh(value);
        }
        this.adjust();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        V result = null;
        CMCacheEntry entry = this.m_entries.get(key);
        if (entry != null) {
            this.hit();
            AbstractCMCache abstractCMCache = this;
            synchronized (abstractCMCache) {
                this.touchEntry(entry);
            }
            result = entry.value;
        } else {
            this.reportMiss();
        }
        return result;
    }

    private void hit() {
        this.reportHit();
        this.fireAlarm();
    }

    @Override
    public V peek(K key) {
        V result = null;
        CMCacheEntry entry = this.m_entries.get(key);
        if (entry != null) {
            result = entry.value;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        V result = null;
        CMCacheEntry entry = this.m_entries.remove(key);
        if (entry != null) {
            result = entry.value;
            AbstractCMCache abstractCMCache = this;
            synchronized (abstractCMCache) {
                this.removeEntry(entry);
                this.m_currentBytes -= this.m_scale.weigh(result);
            }
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        this.m_entries.clear();
        this.m_currentBytes = 0L;
    }

    protected synchronized boolean maxEntriesReached() {
        return this.getMaxSize() > 0 && this.size() > this.getMaxSize();
    }

    protected synchronized boolean maxBytesReached() {
        return this.getMaxBytes() > 0L && this.byteSize() > this.getMaxBytes();
    }

    protected synchronized void adjust() {
        if (this.maxEntriesReached()) {
            this.evictCount(this.size() - this.getMaxSize());
        }
        if (this.maxBytesReached()) {
            this.evictBytes(this.byteSize() - this.getMaxBytes());
        }
    }

    @Override
    public synchronized void evict() {
        this.evictPercent(0.25f);
    }

    @Override
    public synchronized void evictBytes(long bytes) {
        if (this.byteSize() == 0L) {
            return;
        }
        if (bytes >= this.byteSize()) {
            this.eviction(this.size());
            this.clear();
        } else {
            while (bytes > 0L && this.size() > 0) {
                CMCacheEntry entry = this.evictLeastImportantEntry();
                bytes -= this.m_scale.weigh(entry.value);
            }
        }
    }

    private void eviction(int i) {
        this.reportEvictions(i);
        this.fireAlarm();
    }

    private void fireAlarm() {
        this.inRatioFailedState_ = this.shouldFireAlarm() ? (this.firedAlarm_ = CMPerfAlarm.alarmRatioViolation(this.getHitCount(), this.getEvictionCount(), "AbstractCMCache", this.m_name)) : CMPerfAlarm.isRatioFail(this.getHitCount(), this.getEvictionCount());
    }

    private boolean shouldFireAlarm() {
        return (!this.firedAlarm_ || !AdvancedSettings.CACHE_RATIO_ALARM_ONE_TIME) && !this.inRatioFailedState_;
    }

    @Override
    public synchronized void evictCount(int count) {
        if (count > this.size()) {
            this.eviction(this.size());
            this.clear();
        } else {
            while (count > 0 && this.size() > 0) {
                this.evictLeastImportantEntry();
                --count;
            }
        }
    }

    @Override
    public synchronized void evictPercent(float percent) {
        int toRemove = (int)Math.ceil((float)this.size() * percent);
        if (toRemove > 0) {
            this.evictCount(toRemove);
        }
    }

    @Override
    public int size() {
        return this.m_entries.size();
    }

    @Override
    public long byteSize() {
        return this.m_currentBytes;
    }

    @Override
    public long getMaxBytes() {
        return this.m_maxBytes;
    }

    @Override
    public int getMaxSize() {
        return this.m_maxSize;
    }

    @Override
    public synchronized void setMaxBytes(long maxBytes) {
        this.m_maxBytes = maxBytes;
        this.adjust();
    }

    @Override
    public synchronized void setMaxSize(int maxElements) {
        this.m_maxSize = maxElements;
        this.adjust();
    }

    protected void setScale(CMCacheEntryScale scale) {
        this.m_scale = scale;
    }

    protected class CMCacheEntry {
        public K key;
        public V value;

        public CMCacheEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

