/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.caching;

import com.cognos.cm.util.caching.CMObjectCache;
import com.cognos.perfMonitor.PerfCounter;
import com.cognos.perfMonitor.PerfMonitor;

public abstract class AbstractCountersCache<K, V>
implements CMObjectCache<K, V> {
    protected PerfCounter m_perfCounterHits;
    protected PerfCounter m_perfCounterMisses;
    protected PerfCounter m_perfCounterEvictions;
    protected PerfCounter m_perfCounterAdds;
    protected String m_name;

    public AbstractCountersCache(String name) {
        this.m_name = name;
        this.m_perfCounterHits = PerfMonitor.getCounter((String)("com.cognos.cm.cache." + this.m_name + ".hits"), (String)("The number of " + this.m_name + " hits."), (int)6);
        this.m_perfCounterMisses = PerfMonitor.getCounter((String)("com.cognos.cm.cache." + this.m_name + ".misses"), (String)("The number of " + this.m_name + " misses."), (int)6);
        this.m_perfCounterEvictions = PerfMonitor.getCounter((String)("com.cognos.cm.cache." + this.m_name + ".evictions"), (String)("The nuber of " + this.m_name + " evictions"), (int)6);
        this.m_perfCounterAdds = PerfMonitor.getCounter((String)("com.cognos.cm.cache." + this.m_name + ".adds"), (String)("The number of unique adds to the " + this.m_name), (int)6);
    }

    protected void reportAdd() {
        this.m_perfCounterAdds.incr();
    }

    protected void resetAddCounter() {
        this.m_perfCounterAdds.resetPeriod();
    }

    protected void reportHit() {
        this.m_perfCounterHits.incr();
    }

    protected void reportMiss() {
        this.m_perfCounterMisses.incr();
    }

    @Override
    public long getHitCount() {
        return this.m_perfCounterHits.getThisPeriodCount();
    }

    @Override
    public double getHitMissRatio() {
        double hits = this.getHitCount();
        double misses = this.getMissCount();
        if (hits == 0.0 && misses == 0.0) {
            return 0.0;
        }
        return hits / (hits + misses);
    }

    @Override
    public long getMissCount() {
        return this.m_perfCounterMisses.getThisPeriodCount();
    }

    @Override
    public void resetHitAndMissCounts() {
        this.m_perfCounterHits.resetPeriod();
        this.m_perfCounterMisses.resetPeriod();
    }

    protected void reportEviction() {
        this.m_perfCounterEvictions.incr();
    }

    protected void reportEvictions(long evictionCount) {
        this.m_perfCounterEvictions.incr(evictionCount);
    }

    @Override
    public long getEvictionCount() {
        return this.m_perfCounterEvictions.getThisPeriodCount();
    }

    @Override
    public void resetEvictionCount() {
        this.m_perfCounterEvictions.resetPeriod();
    }

    @Override
    public void resetAllCounters() {
        this.resetEvictionCount();
        this.resetHitAndMissCounts();
        this.resetAddCounter();
    }
}

