/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.caching;

import com.cognos.cm.util.caching.AbstractCountersCache;
import com.cognos.cm.util.caching.CMCacheEntryScale;
import com.cognos.cm.util.caching.CMFrequencyCache;
import com.cognos.cm.util.caching.CMObjectCache;
import com.cognos.cm.util.caching.CMPromotionCache;
import com.cognos.cm.util.caching.CMRecencyCache;

public class CMCacheFactory {
    public static final int CACHE_STRATEGY_LRU = 0;
    public static final int CACHE_STRATEGY_LFU = 1;
    public static final int CACHE_STRATEGY_DOUBLE_LRU = 3;
    public static final float DEFAULT_CACHE_DIVISION = 0.6f;

    public static <K, V> CMObjectCache<K, V> createCache(String name, int strategy, int maxEntries, long maxBytes, CMCacheEntryScale scale) {
        return CMCacheFactory.createCache(strategy, name, scale, maxEntries, maxBytes, 0.6f);
    }

    public static <K, V> CMObjectCache<K, V> createCache(int strategy, String name, CMCacheEntryScale scale, int maxEntries, long maxBytes, float cacheDivision) {
        AbstractCountersCache result = null;
        switch (strategy) {
            case 1: {
                result = new CMFrequencyCache(name, scale, maxEntries, maxBytes);
                break;
            }
            case 0: {
                result = new CMRecencyCache(name, scale, maxEntries, maxBytes);
                break;
            }
            case 3: {
                CMRecencyCache primary1 = new CMRecencyCache(name + ".primaryRecencyCache", scale, 0, 0L);
                CMRecencyCache secondary1 = new CMRecencyCache(name + ".secondaryRecencyCache", scale, 0, 0L);
                result = new CMPromotionCache(name, maxEntries, maxBytes, cacheDivision, primary1, secondary1);
            }
        }
        return result;
    }
}

