/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.caching;

import com.cognos.cm.util.caching.AbstractCMCache;
import com.cognos.cm.util.caching.CMCacheEntryScale;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;

public class CMFrequencyCache<K, V>
extends AbstractCMCache<K, V> {
    private TreeSet<FrequencyEntry> m_priorityQueue = new TreeSet<FrequencyEntry>(new FrequencyEntryComparator());

    public CMFrequencyCache(String name, CMCacheEntryScale scale, int maxEntries, long maxBytes) {
        super(name, scale, maxEntries, maxBytes);
    }

    @Override
    protected AbstractCMCache.CMCacheEntry newEntry(K key, V value) {
        return new FrequencyEntry(key, value);
    }

    @Override
    protected synchronized void addEntry(AbstractCMCache.CMCacheEntry entry) {
        this.m_priorityQueue.add((FrequencyEntry)entry);
    }

    @Override
    protected synchronized void touchEntry(AbstractCMCache.CMCacheEntry entry) {
        FrequencyEntry freEntry = (FrequencyEntry)entry;
        this.m_priorityQueue.remove(freEntry);
        freEntry.touch();
        this.m_priorityQueue.add(freEntry);
    }

    @Override
    protected synchronized void keyRebound(AbstractCMCache.CMCacheEntry entry) {
        this.touchEntry(entry);
    }

    @Override
    protected synchronized void removeEntry(AbstractCMCache.CMCacheEntry entry) {
        this.m_priorityQueue.remove(entry);
    }

    @Override
    protected AbstractCMCache.CMCacheEntry getNextEntryForEviction() {
        return this.m_priorityQueue.first();
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.m_priorityQueue.clear();
    }

    public synchronized String dumpInOrder() {
        StringBuffer buf = new StringBuffer();
        Iterator<FrequencyEntry> inOrder = this.m_priorityQueue.iterator();
        while (inOrder.hasNext()) {
            FrequencyEntry current = inOrder.next();
            buf.append(current.key.toString()).append("->").append(current.value.toString()).append("(").append(current.hitCount).append(")");
            if (!inOrder.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private class FrequencyEntryComparator
    implements Comparator<FrequencyEntry> {
        private FrequencyEntryComparator() {
        }

        @Override
        public int compare(FrequencyEntry e1, FrequencyEntry e2) {
            if (e1.equals(e2)) {
                return 0;
            }
            int res = 0;
            res = e1.hitCount - e2.hitCount;
            if (res == 0) {
                if (e1.timestamp > e2.timestamp) {
                    res = 1;
                } else if (e1.timestamp < e2.timestamp) {
                    res = -1;
                }
            }
            return res == 0 ? e1.hashCode() - e2.hashCode() : res;
        }
    }

    public class FrequencyEntry
    extends AbstractCMCache.CMCacheEntry {
        public long timestamp;
        public int hitCount;

        public FrequencyEntry(K key, V value) {
            super(key, value);
            this.timestamp = System.currentTimeMillis();
        }

        public void touch() {
            ++this.hitCount;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

