/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.caching;

import com.cognos.cm.util.caching.AbstractCountersCache;
import com.cognos.cm.util.caching.CMObjectCache;

public class CMPromotionCache<K, V>
extends AbstractCountersCache<K, V> {
    private CMObjectCache<K, V> m_primaryCache;
    private CMObjectCache<K, V> m_promotionCache;
    private float m_cacheDivision;
    private long m_maxBytes;
    private int m_maxEntries;

    public CMPromotionCache(String name, int maxEntries, long maxBytes, float cacheDivision, CMObjectCache<K, V> primaryCache, CMObjectCache<K, V> promotionCache) {
        super(name);
        this.m_primaryCache = primaryCache;
        this.m_promotionCache = promotionCache;
        this.m_cacheDivision = cacheDivision;
        this.m_maxBytes = maxBytes;
        this.m_maxEntries = maxEntries;
        int primaryMaxEntries = (int)((float)this.m_maxEntries * this.m_cacheDivision);
        int promotionMaxEntries = this.m_maxEntries - primaryMaxEntries;
        this.m_primaryCache.setMaxBytes(0L);
        this.m_primaryCache.setMaxSize(primaryMaxEntries);
        this.m_promotionCache.setMaxBytes(0L);
        this.m_promotionCache.setMaxSize(promotionMaxEntries);
    }

    @Override
    public synchronized void add(K key, V value) {
        if (this.m_promotionCache.peek(key) != null) {
            this.m_promotionCache.add(key, value);
        } else if (this.m_primaryCache.peek(key) != null) {
            this.m_primaryCache.remove(key);
            this.m_promotionCache.add(key, value);
        } else {
            this.reportAdd();
            this.m_primaryCache.add(key, value);
        }
        this.adjustForMaxBytes();
    }

    @Override
    public synchronized V get(K key) {
        V result = this.m_promotionCache.get(key);
        if (result == null && (result = this.m_primaryCache.get(key)) != null) {
            V value = this.m_primaryCache.remove(key);
            this.m_promotionCache.add(key, value);
        }
        if (result != null) {
            this.reportHit();
        } else {
            this.reportMiss();
        }
        return result;
    }

    @Override
    public synchronized V peek(K key) {
        V result = this.m_promotionCache.get(key);
        if (result == null) {
            result = this.m_primaryCache.get(key);
        }
        return result;
    }

    @Override
    public synchronized V remove(K key) {
        V result = null;
        if (this.m_promotionCache.peek(key) != null) {
            result = this.m_promotionCache.remove(key);
        }
        if (this.m_primaryCache.peek(key) != null) {
            result = this.m_primaryCache.remove(key);
        }
        return result;
    }

    @Override
    public synchronized void clear() {
        this.m_promotionCache.clear();
        this.m_primaryCache.clear();
    }

    private synchronized void adjustForMaxBytes() {
        long currentSize = this.byteSize();
        if (this.m_maxBytes > 0L && currentSize - this.getMaxBytes() > 0L) {
            this.evictBytes(currentSize - this.getMaxBytes());
        }
    }

    @Override
    public synchronized void evict() {
        this.m_primaryCache.evict();
        this.m_promotionCache.evict();
    }

    @Override
    public synchronized void evictBytes(long bytes) {
        if (this.byteSize() == 0L) {
            return;
        }
        long aimingFor = this.byteSize() - bytes;
        if (aimingFor <= 0L) {
            this.m_primaryCache.evictCount(this.m_primaryCache.size());
            this.m_promotionCache.evictCount(this.m_promotionCache.size());
            return;
        }
        while (this.byteSize() > aimingFor && (this.m_primaryCache.size() != 0 || this.m_promotionCache.size() != 0)) {
            if (this.m_primaryCache.size() >= this.m_promotionCache.size()) {
                this.m_primaryCache.evictCount(1);
                continue;
            }
            this.m_promotionCache.evictCount(1);
        }
    }

    public synchronized void evictBytesFromPrimaryCache(long bytes) {
        this.m_primaryCache.evictBytes(bytes);
    }

    public synchronized void evictBytesFromPromotionCache(long bytes) {
        this.m_promotionCache.evictBytes(bytes);
    }

    @Override
    public synchronized void evictCount(int count) {
        if (count <= 0) {
            return;
        }
        int primaryCacheRemoval = (int)Math.ceil((float)count * this.m_cacheDivision);
        int promotionCacheRemoval = count - primaryCacheRemoval;
        int primaryCacheLeftOver = primaryCacheRemoval - this.m_primaryCache.size();
        int promotionCacheLeftOver = promotionCacheRemoval - this.m_promotionCache.size();
        if (primaryCacheLeftOver <= 0 && promotionCacheLeftOver <= 0 || primaryCacheLeftOver > 0 && promotionCacheLeftOver > 0) {
            this.m_primaryCache.evictCount(primaryCacheRemoval);
            this.m_promotionCache.evictCount(promotionCacheRemoval);
        } else if (primaryCacheLeftOver > 0) {
            this.m_primaryCache.evictCount(this.m_primaryCache.size());
            this.m_promotionCache.evictCount(promotionCacheRemoval + primaryCacheLeftOver);
        } else if (promotionCacheLeftOver > 0) {
            this.m_promotionCache.evictCount(this.m_promotionCache.size());
            this.m_primaryCache.evictCount(primaryCacheRemoval + promotionCacheLeftOver);
        }
    }

    public synchronized void evictCountFromPrimaryCache(int count) {
        this.m_primaryCache.evictCount(count);
    }

    public synchronized void evictCountFromPromotionCache(int count) {
        this.m_promotionCache.evictCount(count);
    }

    @Override
    public synchronized void evictPercent(float percent) {
        this.m_primaryCache.evictPercent(percent);
        this.m_promotionCache.evictPercent(percent);
    }

    public synchronized void evictPercentFromPrimaryCache(float percent) {
        this.m_primaryCache.evictPercent(percent);
    }

    public synchronized void evictPercentFromPromotionCache(float percent) {
        this.m_promotionCache.evictPercent(percent);
    }

    @Override
    public synchronized long byteSize() {
        return this.m_promotionCache.byteSize() + this.m_primaryCache.byteSize();
    }

    public long getPrimaryCacheCurrentBytes() {
        return this.m_primaryCache.byteSize();
    }

    public long getPromotionCacheCurrentBytes() {
        return this.m_promotionCache.byteSize();
    }

    @Override
    public int size() {
        return this.m_promotionCache.size() + this.m_primaryCache.size();
    }

    public long getPrimaryCacheCurrentCount() {
        return this.m_primaryCache.size();
    }

    public long getPromotionCacheCurrentCount() {
        return this.m_promotionCache.size();
    }

    @Override
    public long getMaxBytes() {
        return this.m_maxBytes;
    }

    @Override
    public int getMaxSize() {
        return this.m_maxEntries;
    }

    public synchronized void setCacheDivision(float division) {
        this.m_cacheDivision = division;
        int primaryMaxEntries = (int)((float)this.m_maxEntries * this.m_cacheDivision);
        int promotionMaxEntries = this.m_maxEntries - primaryMaxEntries;
        this.m_primaryCache.setMaxSize(primaryMaxEntries);
        this.m_promotionCache.setMaxSize(promotionMaxEntries);
    }

    public float getCacheDivision() {
        return this.m_cacheDivision;
    }

    @Override
    public synchronized void setMaxBytes(long maxBytes) {
        this.m_maxBytes = maxBytes;
        this.adjustForMaxBytes();
    }

    @Override
    public synchronized void setMaxSize(int maxElements) {
        this.m_maxEntries = maxElements;
        int primaryMaxEntries = (int)((float)this.m_maxEntries * this.m_cacheDivision);
        int promotionMaxEntries = this.m_maxEntries - primaryMaxEntries;
        this.m_primaryCache.setMaxSize(primaryMaxEntries);
        this.m_promotionCache.setMaxSize(promotionMaxEntries);
    }

    @Override
    public long getEvictionCount() {
        return this.m_primaryCache.getEvictionCount() + this.m_promotionCache.getEvictionCount();
    }

    @Override
    public void resetAllCounters() {
        super.resetAllCounters();
        this.m_primaryCache.resetAllCounters();
        this.m_promotionCache.resetAllCounters();
    }

    @Override
    public void resetEvictionCount() {
        super.resetEvictionCount();
        this.m_primaryCache.resetEvictionCount();
        this.m_promotionCache.resetEvictionCount();
    }

    @Override
    public void resetHitAndMissCounts() {
        super.resetHitAndMissCounts();
        this.m_primaryCache.resetHitAndMissCounts();
        this.m_promotionCache.resetHitAndMissCounts();
    }
}

