/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.cm.util.caching;

import com.cognos.cm.util.caching.AbstractCMCache;
import com.cognos.cm.util.caching.CMCacheEntryScale;

public class CMRecencyCache<K, V>
extends AbstractCMCache<K, V> {
    private RecencyEntry m_head;
    private RecencyEntry m_tail;

    public CMRecencyCache(String name, CMCacheEntryScale scale, int maxEntries, long maxBytes) {
        super(name, scale, maxEntries, maxBytes);
    }

    @Override
    protected AbstractCMCache.CMCacheEntry newEntry(K key, V value) {
        return new RecencyEntry(key, value);
    }

    @Override
    protected synchronized void touchEntry(AbstractCMCache.CMCacheEntry entry) {
        this.unlink((RecencyEntry)entry);
        this.insertAtHead((RecencyEntry)entry);
    }

    @Override
    protected synchronized void addEntry(AbstractCMCache.CMCacheEntry entry) {
        this.insertAtHead((RecencyEntry)entry);
    }

    @Override
    protected synchronized void keyRebound(AbstractCMCache.CMCacheEntry entry) {
        this.unlink((RecencyEntry)entry);
        this.insertAtHead((RecencyEntry)entry);
    }

    @Override
    protected AbstractCMCache.CMCacheEntry getNextEntryForEviction() {
        return this.m_tail;
    }

    @Override
    protected synchronized void removeEntry(AbstractCMCache.CMCacheEntry entry) {
        this.unlink((RecencyEntry)entry);
    }

    protected synchronized void unlink(RecencyEntry entry) {
        RecencyEntry prevEntry = entry.previous;
        RecencyEntry nextEntry = entry.next;
        if (prevEntry != null) {
            prevEntry.next = nextEntry;
            entry.previous = null;
        } else if (this.m_head == entry) {
            this.m_head = nextEntry;
        }
        if (nextEntry != null) {
            nextEntry.previous = prevEntry;
            entry.next = null;
        } else if (this.m_tail == entry) {
            this.m_tail = prevEntry;
        }
    }

    protected synchronized void insertAtHead(RecencyEntry entry) {
        if (this.m_head != null) {
            this.m_head.previous = entry;
            entry.next = this.m_head;
        } else {
            this.m_tail = entry;
        }
        this.m_head = entry;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.m_head = null;
        this.m_tail = null;
    }

    public synchronized String dumpInOrder() {
        StringBuffer buf = new StringBuffer();
        RecencyEntry iter = this.m_head;
        while (iter != null) {
            buf.append(iter.key.toString()).append("->").append(iter.value.toString());
            if (iter.next != null) {
                buf.append(", ");
            }
            iter = iter.next;
        }
        return buf.toString();
    }

    public class RecencyEntry
    extends AbstractCMCache.CMCacheEntry {
        public long hitCount;
        public RecencyEntry previous;
        public RecencyEntry next;

        public RecencyEntry(K key, V value) {
            super(key, value);
        }
    }
}

